/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public class MonitorTask
extends TimerTask {
    private static boolean initialized = false;
    private static boolean needORBMonitoring = false;
    private static boolean needEJBMonitoring = false;
    private static boolean needJDBCMonitoring = false;
    private static ArrayList monitorableList = null;
    private static long schedPeriod = 180000L;
    private static Timer timer;

    private static synchronized boolean isMonitoring() {
        if (!initialized) {
            try {
                String string = System.getProperties().getProperty("MONITOR_ORB");
                String string2 = System.getProperties().getProperty("MONITOR_EJB");
                String string3 = System.getProperties().getProperty("MONITOR_JDBC");
                String string4 = System.getProperties().getProperty("MONITOR_TIME_PERIOD_SECONDS");
                if (null != string && (string.startsWith("true") || string.startsWith("TRUE"))) {
                    needORBMonitoring = true;
                }
                if (null != string2 && (string2.startsWith("true") || string2.startsWith("TRUE"))) {
                    needEJBMonitoring = true;
                }
                if (null != string3 && (string3.startsWith("true") || string3.startsWith("TRUE"))) {
                    needJDBCMonitoring = true;
                }
                if ((needORBMonitoring || needEJBMonitoring || needJDBCMonitoring) && null != string4) {
                    schedPeriod = 1000L * Long.parseLong(string4);
                }
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.FINE, "MINOR: Unable to start a performance monitoring task > " + exception);
            }
            if (needORBMonitoring || needEJBMonitoring || needJDBCMonitoring) {
                monitorableList = new ArrayList();
                timer = new Timer();
                timer.schedule((TimerTask)new MonitorTask(), schedPeriod, schedPeriod);
                LogWrap.logger.log(Level.SEVERE, "Starting the MonitorTask every " + schedPeriod + " milliseconds.");
            }
            initialized = true;
        }
        return needORBMonitoring || needEJBMonitoring || needJDBCMonitoring;
    }

    public static void addORBMonitorable(Object object) {
        if (MonitorTask.isMonitoring() && needORBMonitoring) {
            monitorableList.add(object);
        }
    }

    public static void addEJBMonitorable(Object object) {
        if (MonitorTask.isMonitoring() && needEJBMonitoring) {
            monitorableList.add(object);
        }
    }

    public static void addJDBCMonitorable(Object object) {
        if (MonitorTask.isMonitoring() && needJDBCMonitoring) {
            monitorableList.add(object);
        }
    }

    public static ArrayList getMonitorableList() {
        return monitorableList;
    }

    public void run() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            boolean bl = true;
            stringBuffer.append("MONITORING : ");
            Iterator iterator = MonitorTask.getMonitorableList().iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(iterator.next().toString());
            }
            LogWrap.logger.log(Level.SEVERE, stringBuffer.toString());
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "MonitorTask received an exception > " + exception);
        }
    }

    protected Timer getTimer() {
        return timer;
    }
}

