/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.security;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.serverbeans.SecurityService;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.server.ApplicationServer;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.web.SecurityRole;
import com.sun.enterprise.deployment.web.WebComponentDescriptor;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.connector.HttpRequestBase;

public class Audit {
    private static boolean auditFlag;
    private static Logger logger;
    private static String strPrivateAudit;
    private static String strDenied;
    private static String strOK;
    private static String strMethodName;
    private static String strSession;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$security$Audit;

    public static boolean isActive() {
        return auditFlag;
    }

    public static void init() {
        Object object;
        try {
            object = ApplicationServer.getServerContext().getConfigContext();
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            Server server = ServerBeansFactory.getServerBean((ConfigContext)object);
            if (!$assertionsDisabled && server == null) {
                throw new AssertionError();
            }
            SecurityService securityService = server.getSecurityService();
            if (!$assertionsDisabled && securityService == null) {
                throw new AssertionError();
            }
            auditFlag = securityService.isAuditEnabled();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "audit.badinit", exception);
        }
        if (auditFlag) {
            logger.info("audit.enabled");
        }
        object = logger.getResourceBundle();
        strPrivateAudit = ((ResourceBundle)object).getString("audit.string_private_audit");
        strDenied = " " + ((ResourceBundle)object).getString("audit.denied");
        strOK = " " + ((ResourceBundle)object).getString("audit.ok");
        strMethodName = " " + ((ResourceBundle)object).getString("audit.methodname");
        strSession = " " + ((ResourceBundle)object).getString("audit.session");
    }

    public static void ejbMethodInvocation(SecurityContext securityContext, EJBLocalRemoteObject eJBLocalRemoteObject, Method method, boolean bl) {
        Object object;
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        String string = "(null)";
        if (securityContext != null && (object = securityContext.getCallerPrincipal()) != null) {
            string = object.getName();
        }
        object = "(N/A)";
        if (eJBLocalRemoteObject != null) {
            object = eJBLocalRemoteObject.toString();
        }
        String string2 = "(N/A)";
        if (method != null) {
            string2 = method.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(strPrivateAudit);
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("(null)");
        }
        stringBuffer.append(" ejb=");
        stringBuffer.append((String)object);
        stringBuffer.append(strMethodName);
        stringBuffer.append(method);
        if (bl) {
            stringBuffer.append(strOK);
        } else {
            stringBuffer.append(strDenied);
        }
        logger.info(stringBuffer.toString());
    }

    public static void webInvocation(HttpRequest httpRequest, boolean bl) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        if (httpRequest == null) {
            logger.fine("Audit: No HttpRequest available.");
            return;
        }
        if (!(httpRequest instanceof HttpRequestBase)) {
            logger.fine("Audit internal error, class: " + httpRequest.getClass());
            return;
        }
        HttpRequestBase httpRequestBase = (HttpRequestBase)httpRequest;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(strPrivateAudit);
        String string = httpRequestBase.getRemoteUser();
        if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("(null)");
        }
        stringBuffer.append(" ");
        stringBuffer.append(httpRequestBase.getMethod());
        stringBuffer.append(" ");
        stringBuffer.append(httpRequestBase.getRequestURI());
        stringBuffer.append(strSession);
        stringBuffer.append(httpRequestBase.getRequestedSessionId());
        if (bl) {
            stringBuffer.append(strOK);
        } else {
            stringBuffer.append(strDenied);
        }
        logger.info(stringBuffer.toString());
    }

    public static void showACL(Application application) {
        if (!Audit.isActive() || !logger.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            Audit.dumpDiagnostics(application);
        }
        catch (Throwable throwable) {
            logger.fine("Error while showing ACL diagnostics: " + throwable.toString());
        }
    }

    private static void dumpDiagnostics(Application application) {
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        Object object4;
        Object object5;
        Iterator iterator2;
        Object object6;
        Serializable serializable;
        Iterator iterator3;
        Object object7;
        Object object8;
        Object object9;
        logger.finest("====[ Role and ACL Summary ]==========");
        if (!application.isVirtual()) {
            logger.finest("Summary for application: " + application.getRegistrationName());
        } else {
            logger.finest("Standalone module.");
        }
        logger.finest("EJB components: " + application.getEjbComponentCount());
        logger.finest("Web components: " + application.getWebComponentCount());
        Set set = application.getRoles();
        if (set == null) {
            logger.finest("- No roles present.");
            return;
        }
        RoleMapper roleMapper = application.getRoleMapper();
        if (roleMapper == null) {
            logger.finest("- No role mappings present.");
            return;
        }
        Iterator iterator4 = set.iterator();
        logger.finest("--[ Configured roles and mappings ]--");
        HashMap hashMap = new HashMap();
        while (iterator4.hasNext()) {
            object9 = (Role)iterator4.next();
            logger.finest(" [" + ((PrincipalImpl)object9).getName() + "]");
            hashMap.put(((PrincipalImpl)object9).getName(), new HashSet());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  is mapped to groups: ");
            object8 = roleMapper.getGroupsAssignedTo((Role)object9);
            while (object8.hasMoreElements()) {
                stringBuffer.append(object8.nextElement());
                stringBuffer.append(" ");
            }
            logger.finest(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            stringBuffer.append("  is mapped to principals: ");
            object7 = roleMapper.getUsersAssignedTo((Role)object9);
            while (object7.hasMoreElements()) {
                stringBuffer.append(object7.nextElement());
                stringBuffer.append(" ");
            }
            logger.finest(stringBuffer.toString());
        }
        object9 = application.getEjbBundleDescriptors();
        iterator4 = object9.iterator();
        while (iterator4.hasNext()) {
            object8 = (EjbBundleDescriptor)iterator4.next();
            logger.finest("--[ EJB module: " + ((EjbBundleDescriptor)object8).getName() + " ]--");
            object7 = ((EjbBundleDescriptor)object8).getEjbs();
            iterator3 = object7.iterator();
            while (iterator3.hasNext()) {
                serializable = (EjbDescriptor)iterator3.next();
                logger.finest("EJB: " + ((EjbDescriptor)serializable).getEjbClassName());
                if (!((EjbDescriptor)serializable).getUsesCallerIdentity()) {
                    object6 = ((EjbDescriptor)serializable).getRunAsIdentity();
                    if (object6 == null) {
                        logger.finest(" (ejb does not use caller identity)");
                    } else {
                        iterator2 = ((RunAsIdentityDescriptor)object6).getRoleName();
                        object5 = ((RunAsIdentityDescriptor)object6).getPrincipal();
                        logger.finest(" Will run-as: Role: " + iterator2 + "  Principal: " + (String)object5);
                        if (iterator2 == null || "".equals(iterator2) || object5 == null || "".equals(object5)) {
                            logger.finest("*** Configuration error!");
                        }
                    }
                }
                logger.finest(" Method to Role restriction list:");
                object6 = ((EjbDescriptor)serializable).getMethodDescriptors();
                iterator2 = object6.iterator();
                while (iterator2.hasNext()) {
                    HashSet hashSet;
                    object5 = (MethodDescriptor)iterator2.next();
                    logger.finest("   " + ((MethodDescriptor)object5).getFormattedString());
                    object4 = ((EjbDescriptor)serializable).getMethodPermissionsFor((MethodDescriptor)object5);
                    object3 = new StringBuffer();
                    ((StringBuffer)object3).append("     can only be invoked by: ");
                    iterator = object4.iterator();
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    while (iterator.hasNext()) {
                        object2 = (MethodPermission)iterator.next();
                        if (((MethodPermission)object2).isExcluded()) {
                            bl2 = true;
                            logger.finest("     excluded - can not be invoked");
                            continue;
                        }
                        if (((MethodPermission)object2).isUnchecked()) {
                            bl = true;
                            logger.finest("     unchecked - can be invoked by all");
                            continue;
                        }
                        if (!((MethodPermission)object2).isRoleBased()) continue;
                        bl3 = true;
                        object = ((MethodPermission)object2).getRole();
                        ((StringBuffer)object3).append(((PrincipalImpl)object).getName());
                        ((StringBuffer)object3).append(" ");
                        hashSet = (HashSet)hashMap.get(((PrincipalImpl)object).getName());
                        hashSet.add(((EjbBundleDescriptor)object8).getName() + ":" + ((EjbDescriptor)serializable).getEjbClassName() + "." + ((MethodDescriptor)object5).getFormattedString());
                    }
                    if (bl3) {
                        logger.finest(((StringBuffer)object3).toString());
                        if (!bl2 && !bl) continue;
                        logger.finest("*** Configuration error!");
                        continue;
                    }
                    if (bl) {
                        if (bl2) {
                            logger.finest("*** Configuration error!");
                        }
                        object2 = hashMap.keySet();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            hashSet = (HashSet)hashMap.get(object.next());
                            hashSet.add(((EjbBundleDescriptor)object8).getName() + ":" + ((EjbDescriptor)serializable).getEjbClassName() + "." + ((MethodDescriptor)object5).getFormattedString());
                        }
                        continue;
                    }
                    if (bl2) continue;
                    logger.finest("*** Configuration error!");
                }
                logger.finest(" IOR configuration:");
                object5 = ((EjbDescriptor)serializable).getIORConfigurationDescriptors();
                if (object5 == null) continue;
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (EjbIORConfigurationDescriptor)object4.next();
                    iterator = new StringBuffer();
                    ((StringBuffer)((Object)iterator)).append("realm=");
                    ((StringBuffer)((Object)iterator)).append(((EjbIORConfigurationDescriptor)object3).getRealmName());
                    ((StringBuffer)((Object)iterator)).append(", integrity=");
                    ((StringBuffer)((Object)iterator)).append(((EjbIORConfigurationDescriptor)object3).getIntegrity());
                    ((StringBuffer)((Object)iterator)).append(", trust-in-target=");
                    ((StringBuffer)((Object)iterator)).append(((EjbIORConfigurationDescriptor)object3).getEstablishTrustInTarget());
                    ((StringBuffer)((Object)iterator)).append(", trust-in-client=");
                    ((StringBuffer)((Object)iterator)).append(((EjbIORConfigurationDescriptor)object3).getEstablishTrustInClient());
                    ((StringBuffer)((Object)iterator)).append(", propagation=");
                    ((StringBuffer)((Object)iterator)).append(((EjbIORConfigurationDescriptor)object3).getCallerPropagation());
                    ((StringBuffer)((Object)iterator)).append(", auth-method=");
                    ((StringBuffer)((Object)iterator)).append(((EjbIORConfigurationDescriptor)object3).getAuthenticationMethod());
                    logger.finest(((StringBuffer)((Object)iterator)).toString());
                }
            }
        }
        logger.finest("--[ EJB methods accessible by role ]--");
        object8 = hashMap.keySet();
        object7 = object8.iterator();
        while (object7.hasNext()) {
            iterator3 = (String)object7.next();
            logger.finest(" [" + iterator3 + "]");
            serializable = (HashSet)hashMap.get(iterator3);
            object6 = ((HashSet)serializable).iterator();
            while (object6.hasNext()) {
                iterator2 = (String)object6.next();
                logger.finest("   " + (String)((Object)iterator2));
            }
        }
        iterator3 = application.getWebBundleDescriptors();
        iterator4 = iterator3.iterator();
        while (iterator4.hasNext()) {
            serializable = (WebBundleDescriptor)iterator4.next();
            logger.finest("--[ Web module: " + ((WebBundleDescriptor)serializable).getContextRoot() + " ]--");
            object6 = ((WebBundleDescriptor)serializable).getLoginConfiguration();
            if (object6 != null) {
                logger.finest("  Login config: realm=" + object6.getRealmName() + ", method=" + object6.getAuthenticationMethod() + ", form=" + object6.getFormLoginPage() + ", error=" + object6.getFormErrorPage());
            }
            logger.finest("  Contains components:");
            iterator2 = ((WebBundleDescriptor)serializable).getWebComponentDescriptorsSet();
            object5 = iterator2.iterator();
            while (object5.hasNext()) {
                object4 = (WebComponentDescriptor)object5.next();
                object3 = new StringBuffer();
                ((StringBuffer)object3).append("   - " + object4.getCanonicalName());
                ((StringBuffer)object3).append(" [ ");
                iterator = object4.getUrlPatterns();
                while (iterator.hasMoreElements()) {
                    ((StringBuffer)object3).append(iterator.nextElement().toString());
                    ((StringBuffer)object3).append(" ");
                }
                ((StringBuffer)object3).append("]");
                logger.finest(((StringBuffer)object3).toString());
                RunAsIdentityDescriptor runAsIdentityDescriptor = object4.getRunAsIdentity();
                if (runAsIdentityDescriptor == null) continue;
                String string = runAsIdentityDescriptor.getRoleName();
                String string2 = runAsIdentityDescriptor.getPrincipal();
                logger.finest("      Will run-as: Role: " + string + "  Principal: " + string2);
                if (string != null && !"".equals(string) && string2 != null && !"".equals(string2)) continue;
                logger.finest("*** Configuration error!");
            }
            logger.finest("  Security constraints:");
            object4 = ((WebBundleDescriptor)serializable).getSecurityConstraints();
            while (object4.hasMoreElements()) {
                Enumeration enumeration;
                Descriptor descriptor;
                object3 = (SecurityConstraintImpl)object4.nextElement();
                iterator = ((SecurityConstraintImpl)object3).getWebResourceCollectionSet();
                Iterator iterator5 = iterator.iterator();
                while (iterator5.hasNext()) {
                    descriptor = (WebResourceCollectionImpl)iterator5.next();
                    enumeration = ((WebResourceCollectionImpl)descriptor).getHttpMethods();
                    object2 = new StringBuffer();
                    while (enumeration.hasMoreElements()) {
                        ((StringBuffer)object2).append(enumeration.nextElement());
                        ((StringBuffer)object2).append(" ");
                    }
                    logger.finest("     Using method: " + ((StringBuffer)object2).toString());
                    object = ((WebResourceCollectionImpl)descriptor).getUrlPatterns();
                    while (object.hasMoreElements()) {
                        logger.finest("       " + object.nextElement().toString());
                    }
                }
                descriptor = (AuthorizationConstraintImpl)((SecurityConstraintImpl)object3).getAuthorizationConstraint();
                enumeration = ((AuthorizationConstraintImpl)descriptor).getSecurityRoles();
                object2 = new StringBuffer();
                ((StringBuffer)object2).append("     Accessible by roles: ");
                while (enumeration.hasMoreElements()) {
                    object = (SecurityRole)enumeration.nextElement();
                    ((StringBuffer)object2).append(object.getName());
                    ((StringBuffer)object2).append(" ");
                }
                logger.finest(((StringBuffer)object2).toString());
                object = ((SecurityConstraintImpl)object3).getUserDataConstraint();
                if (object == null) continue;
                logger.finest("     Transport guarantee: " + object.getTransportGuarantee());
            }
        }
        logger.finest("======================================");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$security$Audit == null ? (class$com$iplanet$ias$security$Audit = Audit.class$("com.iplanet.ias.security.Audit")) : class$com$iplanet$ias$security$Audit).desiredAssertionStatus();
        auditFlag = false;
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        strPrivateAudit = null;
        strDenied = null;
        strOK = null;
        strMethodName = null;
        strSession = null;
    }
}

