/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.loader;

import com.iplanet.ias.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderUtils {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    public static ClassLoader getClassLoader(File[] fileArray, File[] fileArray2, ClassLoader classLoader) throws IOException {
        URLClassLoader uRLClassLoader = null;
        URL[] uRLArray = ClassLoaderUtils.getUrls(fileArray, fileArray2);
        if (uRLArray != null) {
            uRLClassLoader = classLoader != null ? new URLClassLoader(uRLArray, classLoader) : new URLClassLoader(uRLArray);
        }
        return uRLClassLoader;
    }

    public static URL[] getUrls(File[] fileArray, File[] fileArray2) throws IOException {
        File[] fileArray3;
        File file;
        int n;
        URL[] uRLArray = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (fileArray != null) {
            n = 0;
            while (n < fileArray.length) {
                file = fileArray[n];
                if (file.isDirectory() || file.canRead()) {
                    fileArray3 = file.toURL();
                    arrayList.add(fileArray3);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Adding directory to class path:" + fileArray3.toString());
                    }
                }
                ++n;
            }
        }
        if (fileArray2 != null) {
            n = 0;
            while (n < fileArray2.length) {
                file = fileArray2[n];
                if (file.isDirectory() || file.canRead()) {
                    fileArray3 = file.listFiles();
                    int n2 = 0;
                    while (n2 < fileArray3.length) {
                        File file2 = fileArray3[n2];
                        if (FileUtils.isJar(file2) || FileUtils.isZip(file2)) {
                            arrayList.add(file2.toURL());
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, "Adding jar to class path:" + file2.toURL());
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (arrayList.size() > 0) {
            uRLArray = new URL[arrayList.size()];
            uRLArray = arrayList.toArray(uRLArray);
        }
        return uRLArray;
    }

    public static List getUrlList(File[] fileArray, File[] fileArray2) throws IOException {
        File file;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fileArray != null) {
            n = 0;
            while (n < fileArray.length) {
                file = fileArray[n];
                if (file.isDirectory() || file.canRead()) {
                    arrayList.add(file.getCanonicalPath());
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Adding directory to class path:" + file.getCanonicalPath());
                    }
                }
                ++n;
            }
        }
        if (fileArray2 != null) {
            n = 0;
            while (n < fileArray2.length) {
                file = fileArray2[n];
                if (file.isDirectory() || file.canRead()) {
                    File[] fileArray3 = file.listFiles();
                    int n2 = 0;
                    while (n2 < fileArray3.length) {
                        File file2 = fileArray3[n2];
                        if (FileUtils.isJar(file2) || FileUtils.isZip(file2)) {
                            arrayList.add(file2.getCanonicalPath());
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, "Adding jar to class path:" + file2.getCanonicalPath());
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static URL[] getUrlsFromClasspath(String string) {
        Object object;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (string == null) {
            return (URL[])arrayList.toArray();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object = new File(stringTokenizer.nextToken());
                arrayList.add(((File)object).toURL());
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "loader.unexpected_error_while_creating_urls", exception);
            }
        }
        if (arrayList.size() > 0) {
            object = new URL[arrayList.size()];
            object = arrayList.toArray((T[])object);
        } else {
            object = new URL[]{};
        }
        return object;
    }

    public static void main(String[] stringArray) {
        try {
            URL[] uRLArray = ClassLoaderUtils.getUrls(new File[]{new File(stringArray[0])}, new File[]{new File(stringArray[1])});
            int n = 0;
            while (n < uRLArray.length) {
                System.out.println(uRLArray[n]);
                ++n;
            }
            URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoaderUtils.getClassLoader(new File[]{new File(stringArray[0])}, new File[]{new File(stringArray[1])}, null);
            Class<?> clazz = uRLClassLoader.loadClass(stringArray[2]);
            System.out.println("Loaded: " + clazz.getName());
            System.out.println("Loaded class has the following methods...");
            Method[] methodArray = clazz.getDeclaredMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                System.out.println(methodArray[n2]);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

