/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.jms;

import com.iplanet.ias.jms.IASJmsUtil;
import com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.logging.LogDomains;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class IASJmsConfig {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    private static final boolean debug = false;
    public static final int PERSIST_CHANGES_ONLY = 0;
    public static final int UPDATE_NAMESPACE_ONLY = 1;
    public static final int ALL = 2;
    private static final String CREATE_QUEUE = "-createQueue";
    private static final String CREATE_TOPIC = "-createTopic";
    private static final String DELETE_DESTINATION = "-deleteDestination";
    private static final String CREATE_QUEUE_CF = "-createQueueConnectionFactory";
    private static final String CREATE_TOPIC_CF = "-createTopicConnectionFactory";
    private static final String DELETE_CF = "-deleteConnectionFactory";
    private JMSAdmin jmsAdmin_;
    private Context namingContext_;
    private J2EEResourceCollection resources_;

    public IASJmsConfig(int n) throws Exception {
        if (n != 1) {
            throw new Exception("Internal Error: operation not supported");
        }
        this.namingContext_ = new InitialContext();
        this.getJmsAdmin();
    }

    public void createDestination(String string, boolean bl) throws Exception {
        this.createDestination(string, bl, new Properties());
    }

    public void createDestination(String string, boolean bl, Map map) throws Exception {
        Destination destination = null;
        int n = IASJmsConfig.getStyleType(bl);
        destination = (Destination)this.getJmsAdmin().createDestinationObject(n, map);
        this.namingContext_.rebind(string, (Object)destination);
    }

    public void createConnectionFactory(String string, boolean bl) throws Exception {
        this.createConnectionFactory(string, bl, new Properties());
    }

    public void createConnectionFactory(String string, boolean bl, Map map) throws Exception {
        int n = IASJmsConfig.getStyleType(bl);
        ConnectionFactory connectionFactory = (ConnectionFactory)this.getJmsAdmin().createConnectionFactoryObject(n, map);
        ConnectionFactoryWrapperStandalone connectionFactoryWrapperStandalone = new ConnectionFactoryWrapperStandalone(string, connectionFactory);
        this.namingContext_.rebind(string, (Object)connectionFactoryWrapperStandalone);
        String string2 = IASJmsUtil.getXAConnectionFactoryName(string);
        try {
            this.createXAConnectionFactory(string2, bl, map);
        }
        catch (Exception exception) {
            try {
                this.namingContext_.unbind(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    public void createXAConnectionFactory(String string, boolean bl) throws Exception {
        this.createXAConnectionFactory(string, bl, new Properties());
    }

    public void createXAConnectionFactory(String string, boolean bl, Map map) throws Exception {
        int n = IASJmsConfig.getStyleType(bl);
        JMSXAConnectionFactory jMSXAConnectionFactory = (JMSXAConnectionFactory)this.getJmsAdmin().createXAConnectionFactoryObject(n, map);
        this.namingContext_.rebind(string, (Object)jMSXAConnectionFactory);
    }

    public void deleteConnectionFactory(String string) throws Exception {
        NamingException namingException;
        block5: {
            namingException = null;
            try {
                this.namingContext_.unbind(string);
            }
            catch (NamingException namingException2) {
                _logger.log(Level.SEVERE, "jms.delete_connectionfactory_resource_error", namingException2.getMessage());
                _logger.log(Level.SEVERE, "jms.delete_connectionfactory_resource_exception", namingException2);
                namingException = namingException2;
            }
            try {
                String string2 = IASJmsUtil.getXAConnectionFactoryName(string);
                this.deleteXAConnectionFactory(string2);
            }
            catch (NamingException namingException3) {
                _logger.log(Level.SEVERE, "jms.delete_connectionfactory_resource_error", namingException3.getMessage());
                _logger.log(Level.SEVERE, "jms.delete_connectionfactory_resource_exception", namingException3);
                if (namingException != null) break block5;
                namingException = namingException3;
            }
        }
        if (namingException != null) {
            throw namingException;
        }
    }

    public void deleteXAConnectionFactory(String string) throws Exception {
        this.namingContext_.unbind(string);
    }

    public void deleteDestination(String string) throws Exception {
        try {
            this.namingContext_.unbind(string);
        }
        catch (NamingException namingException) {
            _logger.log(Level.SEVERE, "jms.delete_destination_resource_error", namingException.getMessage());
            _logger.log(Level.SEVERE, "jms.delete_destination_resource_exception", namingException);
            throw namingException;
        }
    }

    private static int getStyleType(boolean bl) {
        return bl ? 0 : 1;
    }

    private JMSAdmin getJmsAdmin() throws Exception {
        if (this.jmsAdmin_ == null) {
            this.jmsAdmin_ = IASJmsUtil.getJMSAdmin();
        }
        return this.jmsAdmin_;
    }
}

