/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.util.StringUtils;

public class ModuleEnvironment {
    private String mModuleName = null;
    private String mModulePath = null;
    private String mModuleBackupPath = null;
    private String mModuleStubPath = null;
    private String mModuleJSPPath = null;
    private InstanceEnvironment mInstance = null;
    private DeployableObjectType mType = null;

    public ModuleEnvironment(InstanceEnvironment instanceEnvironment, String string, DeployableObjectType deployableObjectType) {
        if (instanceEnvironment == null || string == null) {
            throw new IllegalArgumentException();
        }
        if (deployableObjectType == null) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_MODULE_TYPE));
        }
        this.mType = deployableObjectType;
        this.mInstance = instanceEnvironment;
        this.mModuleName = string;
        this.createModulePath();
        this.createModuleBackupPath();
        this.createModuleStubPath();
        this.createModuleJSPPath();
    }

    private void createModulePath() {
        String string = this.mInstance.getModuleRepositoryPath();
        String[] stringArray = new String[]{string, this.mModuleName};
        this.mModulePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String getModulePath() {
        return this.mModulePath;
    }

    public void createModuleStubPath() {
        String[] stringArray = new String[]{this.mInstance.getModuleStubPath(), this.mModuleName};
        this.mModuleStubPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String getModuleStubPath() {
        return this.mModuleStubPath;
    }

    public void createModuleJSPPath() {
        String[] stringArray = new String[]{this.mInstance.getWebModuleCompileJspPath(), this.mModuleName};
        this.mModuleJSPPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String getModuleJSPPath() {
        return this.mModuleJSPPath;
    }

    public String getModuleBackupPath() {
        return this.mModuleBackupPath;
    }

    public void createModuleBackupPath() {
        String[] stringArray = new String[]{this.mInstance.getModuleBackupRepositoryPath(), this.mModuleName};
        this.mModuleBackupPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String verify() {
        return null;
    }
}

