/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.instance;

import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.server.core.ManualChangeManager;
import com.iplanet.ias.admin.server.core.channel.AdminChannel;
import com.iplanet.ias.admin.server.core.channel.RMIClient;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.ConfigFactory;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.Mime;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.config.serverbeans.VirtualServer;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import com.iplanet.ias.deployment.backend.DeployableObjectType;
import com.iplanet.ias.installer.core.installConfig;
import com.iplanet.ias.instance.ApplicationEnvironment;
import com.iplanet.ias.instance.ExceptionType;
import com.iplanet.ias.instance.Localizer;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.instance.ServerManager;
import com.iplanet.ias.util.OS;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.ObjectAnalyzer;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InstanceEnvironment {
    private static Object lock;
    private static final boolean TIMESTAMP_MECHANISM_ENABLED = true;
    private static final boolean MIMETYPE_TIMESTAMP_MECHANISM_ENABLED = true;
    private static final boolean VIRTUAL_SERVER_TIMESTAMP_MECHANISM_ENABLED = true;
    private static final long INVALID_TIME_STAMP = 0L;
    private static final long UNINITIALIZED_TIME_STAMP = 0L;
    private static Logger _logger;
    public static final String kConfigDirName = "config";
    public static final String kBackupDirName = "backup";
    public static final String kGeneratedDirName = "generated";
    public static final String kRepositoryDirName = "applications";
    public static final String kApplicationDirName = "j2ee-apps";
    public static final String kModuleDirName = "j2ee-modules";
    public static final String kLifecycleModuleDirName = "lifecycle-modules";
    public static final String kEJBStubDirName = "ejb";
    public static final String kConfigXMLFileName = "server.xml";
    public static final String kLibDirName = "lib";
    public static final String kAutoDeployDirName = "autodeploy";
    public static final String kLibClassesDirName = "classes";
    public static final String kCompileJspDirName = "jsp";
    public static final String kSessionStoreDirName = "session-store";
    public static final String kHttpSessionDirName = "http";
    public static final String kDocRootDirName = "docroot";
    public static final String kObjectFileName = "obj.conf";
    public static final String kInitFileName = "init.conf";
    public static final String kSecurityPasswordsFileName = "password.conf";
    public static final String kRealmsKeyFileName = "keyfile";
    public static final String kInstallDirName = "install";
    public static final String kTemplatesDirName = "templates";
    public static final String kAclTemplate = "template.acl";
    public static final int kOrbListenerPort = 3700;
    public static final int kJmsProviderPort = 7676;
    private String instanceRoot = null;
    private String mLogicalName = null;
    private String mInstanceDirPath = null;
    private String mConfigFilePath = null;
    private String mBackupConfigFilePath = null;
    private String mApplicationRootPath = null;
    private String mApplicationRepositoryPath = null;
    private String mApplicationBackupRepositoryPath = null;
    private String mModuleRepositoryPath = null;
    private String mModuleBackupRepositoryPath = null;
    private String mApplicationStubRepositoryPath = null;
    private String mModuleStubRepositoryPath = null;
    private String mLibPath = null;
    private String mAutoDeployDirPath = null;
    private String mLibClassesPath = null;
    private String mApplicationPassivatedEjbPath = null;
    private String mModulePassivatedEjbPath = null;
    private String mApplicationCompiledJspPath = null;
    private String mWebModuleCompiledJspPath = null;
    private String mApplicationHttpSessionStorePath = null;
    private String mModuleHttpSessionStorePath = null;
    private String mDocRootPath = null;
    private String mStopCommandPath = null;
    private String mDefaultAccessLogPath = null;
    private String mObjectFilePath = null;
    private String mInitFilePath = null;
    private String mBackupObjectFilePath = null;
    private String mBackupInitFilePath = null;
    private String mSecurityPasswordsFilePath = null;
    private String mRealmsKeyFilePath = null;
    private String mBackupRealmsKeyFilePath = null;
    private String mAclFilePath = null;
    private String mBackupAclFilePath = null;
    private String kAclFilePrefix = "generated";
    private String kBackupAclFilePrefix = "genwork";
    private String kAclFileSuffix = "acl";
    private boolean mInited = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$instance$InstanceEnvironment;

    public InstanceEnvironment(String string) {
        this(System.getProperty("com.sun.aas.instanceRoot"), string);
    }

    public InstanceEnvironment(String string, String string2) {
        if (!StringUtils.ok((String)string2)) {
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NULL_ARG));
        }
        this.mLogicalName = string2;
        this.createInstanceDirPath(string, string2);
        boolean bl = new File(this.mInstanceDirPath).exists();
        if (!bl) {
            Object[] objectArray = new Object[]{this.mInstanceDirPath, this.mLogicalName};
            throw new IllegalArgumentException(Localizer.getValue(ExceptionType.NO_INSTANCE_DIR, objectArray));
        }
        this.createConfigFilePath();
        this.createBackupConfigFilePath();
    }

    private void init() {
        if (this.mInited) {
            return;
        }
        this.createApplicationRootPath();
        this.createApplicationRepositoryPath();
        this.createApplicationBackupRepositoryPath();
        this.createModuleRepositoryPath();
        this.createModuleBackupRepositoryPath();
        this.createApplicationStubPath();
        this.createModuleStubPath();
        this.createLibPath();
        this.createLibClassesPath();
        this.createAutoDeployDirPath();
        this.createPassivatedEjbPaths();
        this.createApplicationCompiledJspPath();
        this.createWebModuleCompiledJspPath();
        this.createHttpSessionStorePaths();
        this.createDocRootPath();
        this.createStopCommandPath();
        this.createDefaultAccessLogPath();
        this.createObjectFilePath();
        this.createInitFilePath();
        this.createBackupObjectFilePath();
        this.createBackupInitFilePath();
        this.createSecurityPasswordsFilePath();
        this.createRealmsKeyFilePath();
        this.createBackupRealmsKeyFilePath();
        this.createAclFilePath();
        this.createBackupAclFilePath();
        this.mInited = true;
    }

    public void applyChangesFromBackup() throws ConfigException {
        this.init();
        this.applyChangesFromBackup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangesFromBackup(boolean bl) throws ConfigException {
        _logger.finest("Entering applyChangesFromBackup with overwrite=" + bl);
        this.init();
        Object object = lock;
        synchronized (object) {
            if (!bl && this.hasHotChanged()) {
                throw new AFRuntimeStoreException(Localizer.getValue(ExceptionType.CANNOT_APPLY_CHANGES));
            }
            ConfigContext configContext = ConfigFactory.createConfigContext(this.getConfigFilePath(), true, false, false);
            _logger.finest("applyChangesFromBackup: applying changes");
            this.applyServerXmlChanges(true);
            this.applyInitFileChanges();
            this.applyObjectFileChanges();
            this.applyAllMimeFileChanges();
            this.applyRealmsKeyFileChanges();
            this.applyAclFileChanges();
            this.applyVirtualServersConfFileChanges(configContext);
            ManualChangeManager.removeManualChangeStatus(this.mLogicalName);
        }
        _logger.finest("applyChangesFromBackup: successfully applied changes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHotChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            if (this.hasHotXmlChanged() || this.hasHotInitChanged() || this.hasHotObjectChanged() || this.hasHotMimeChanged() || this.hasHotRealmsKeyChanged() || this.hasHotVirtualServerConfChanged()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasInitOrObjConfFileChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            if (this.hasHotInitChanged() || this.getConfigFileTimeStamp(this.mBackupInitFilePath) > this.getConfigFileTimeStamp(this.mInitFilePath)) {
                return true;
            }
            return this.hasHotObjectChanged() || this.getConfigFileTimeStamp(this.mBackupObjectFilePath) > this.getConfigFileTimeStamp(this.mObjectFilePath);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRealmsKeyConfFileChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            return this.hasHotRealmsKeyChanged() || this.getConfigFileTimeStamp(this.mBackupRealmsKeyFilePath) > this.getConfigFileTimeStamp(this.mRealmsKeyFilePath);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMimeConfFileChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            if (this.hasHotMimeChanged() || this.hasBakMimeChanged()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVirtualServerConfFileChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            return this.hasHotVirtualServerConfChanged() || this.hasBakupVirtualServerConfChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCGIConfigFilesChanged() {
        this.init();
        boolean bl = false;
        Object object = lock;
        synchronized (object) {
            bl = this.hasInitOrObjConfFileChanged();
            if (!bl) {
                bl = this.hasMimeConfFileChanged();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHotInitChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            long l = this.getLastModifiedFromTSFile(this.getTimeStampFileName(this.mBackupInitFilePath));
            if (l == 0L || l == this.getConfigFileTimeStamp(this.mInitFilePath)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHotRealmsKeyChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            long l = this.getLastModifiedFromTSFile(this.getTimeStampFileName(this.mBackupRealmsKeyFilePath));
            if (l == 0L || l == this.getConfigFileTimeStamp(this.mRealmsKeyFilePath)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHotObjectChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            long l = this.getLastModifiedFromTSFile(this.getTimeStampFileName(this.mBackupObjectFilePath));
            if (l == 0L || l == this.getConfigFileTimeStamp(this.mObjectFilePath)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHotXmlChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            long l = this.getLastModifiedFromTSFile(this.getTimeStampFileName(this.mBackupConfigFilePath));
            if (l == 0L || l == this.getConfigFileTimeStamp(this.mConfigFilePath)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canReloadManualXmlChanges() {
        this.init();
        Object object = lock;
        synchronized (object) {
            if (this.hasOnlyHotXmlChanged()) {
                try {
                    ConfigContext configContext = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
                    if (configContext == null) {
                        throw new ConfigException(Localizer.getValue(ExceptionType.BIZARRO_MESSAGE));
                    }
                    return !configContext.isChanged();
                    {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private boolean hasOnlyHotXmlChanged() {
        return this.hasHotXmlChanged() && !this.hasHotObjectChanged() && !this.hasHotInitChanged() && !this.hasHotMimeChanged() && !this.hasHotRealmsKeyChanged() && !this.hasHotVirtualServerConfChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHotMimeChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            try {
                ConfigContext configContext = ConfigFactory.createConfigContext(this.mConfigFilePath, true, false, false);
                if (configContext == null) {
                    throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML));
                }
                Server server = ServerBeansFactory.getServerBean(configContext);
                HttpService httpService = server.getHttpService();
                Mime[] mimeArray = httpService.getMime();
                int n = 0;
                while (n < mimeArray.length) {
                    Mime mime = mimeArray[n];
                    String string = mime.getFile();
                    String string2 = this.getBackupConfigDirPath() + File.separator + string;
                    String string3 = this.getConfigDirPath() + File.separator + string;
                    long l = this.getLastModifiedFromTSFile(this.getTimeStampFileName(string2));
                    if (l != 0L && l != this.getConfigFileTimeStamp(string3)) {
                        return true;
                    }
                    ++n;
                }
                configContext.cleanup();
                return false;
            }
            catch (Throwable throwable) {
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHotVirtualServerConfChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            try {
                ConfigContext configContext = ConfigFactory.createConfigContext(this.getConfigFilePath(), true, false, false);
                return this.hasVirtualServerConfChanged(configContext, true);
            }
            catch (Throwable throwable) {
                _logger.warning(throwable.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBakupVirtualServerConfChanged() {
        this.init();
        Object object = lock;
        synchronized (object) {
            try {
                ConfigContext configContext = ConfigFactory.createConfigContext(this.getBackupConfigFilePath());
                return this.hasVirtualServerConfChanged(configContext, false);
            }
            catch (Throwable throwable) {
                _logger.warning(throwable.getMessage());
            }
        }
        return true;
    }

    private boolean hasVirtualServerConfChanged(ConfigContext configContext, boolean bl) throws ConfigException {
        try {
            if (configContext == null) {
                throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML));
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            HttpService httpService = server.getHttpService();
            VirtualServerClass[] virtualServerClassArray = httpService.getVirtualServerClass();
            int n = 0;
            while (n < virtualServerClassArray.length) {
                VirtualServerClass virtualServerClass = virtualServerClassArray[n];
                VirtualServer[] virtualServerArray = virtualServerClass.getVirtualServer();
                int n2 = 0;
                while (n2 < virtualServerArray.length) {
                    long l;
                    VirtualServer virtualServer = virtualServerArray[n2];
                    String string = virtualServer.getConfigFile();
                    String string2 = this.getBackupConfigDirPath() + File.separator + string;
                    String string3 = this.getConfigDirPath() + File.separator + string;
                    if (bl ? (l = this.getLastModifiedFromTSFile(this.getTimeStampFileName(string2))) != 0L && l != this.getConfigFileTimeStamp(string3) : (l = this.getConfigFileTimeStamp(string2)) > this.getConfigFileTimeStamp(string3)) {
                        return true;
                    }
                    ++n2;
                }
                ++n;
            }
            return false;
        }
        catch (Throwable throwable) {
            _logger.warning(throwable.toString());
            return true;
        }
    }

    private long getConfigFileTimeStamp(String string) {
        long l = 0L;
        try {
            File file = new File(string);
            l = file.lastModified();
        }
        catch (Throwable throwable) {}
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastModifiedFromTSFile(String string) {
        long l = 0L;
        InputStreamReader inputStreamReader = null;
        try {
            File file = new File(string);
            inputStreamReader = new FileReader(file);
            char[] cArray = new char[13];
            inputStreamReader.read(cArray);
            String string2 = new String(cArray);
            l = new Long(string2);
            return l;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                inputStreamReader.close();
                inputStreamReader = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private String getTimeStampFileName(String string) {
        return string + ".timestamp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useManualConfigChanges() throws ConfigException {
        this.init();
        Object object = lock;
        synchronized (object) {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.getBackupConfigFilePath());
            this.useManualServerXmlChanges();
            this.useManualInitFileChanges();
            this.useManualObjectFileChanges();
            this.useManualRealmsKeyFileChanges();
            this.useManualAllMimeFileChanges();
            this.useManualVirtualServerConfFileChanges(configContext);
            ManualChangeManager.removeManualChangeStatus(this.mLogicalName);
            ConfigFactory.removeConfigContext(configContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useManualServerXmlChanges() throws ConfigException {
        this.init();
        Object object = lock;
        synchronized (object) {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mConfigFilePath, true, false, false);
            configContext.refresh();
            File file = new File(this.mConfigFilePath);
            File file2 = new File(this.mBackupConfigFilePath);
            this.copyFile(file, file2);
            this.saveTimeStamp(this.getTimeStampFileName(this.mBackupConfigFilePath), this.mConfigFilePath);
            ManualChangeManager.removeServerXmlManualChangeStatus(this.mLogicalName);
        }
    }

    private void useManualInitFileChanges() throws ConfigException {
        File file = new File(this.mInitFilePath);
        File file2 = new File(this.mBackupInitFilePath);
        this.copyFile(file, file2);
        this.saveTimeStamp(this.getTimeStampFileName(this.mBackupInitFilePath), this.mInitFilePath);
    }

    private void useManualRealmsKeyFileChanges() throws ConfigException {
        File file = new File(this.mRealmsKeyFilePath);
        File file2 = new File(this.mBackupRealmsKeyFilePath);
        this.copyFile(file, file2);
        this.saveTimeStamp(this.getTimeStampFileName(this.mBackupRealmsKeyFilePath), this.mRealmsKeyFilePath);
    }

    private void useManualObjectFileChanges() throws ConfigException {
        File file = new File(this.mObjectFilePath);
        File file2 = new File(this.mBackupObjectFilePath);
        this.copyFile(file, file2);
        this.saveTimeStamp(this.getTimeStampFileName(this.mBackupObjectFilePath), this.mObjectFilePath);
    }

    private void useManualAllMimeFileChanges() throws ConfigException {
        ConfigContext configContext = ConfigFactory.createConfigContext(this.mConfigFilePath, true, false, false);
        if (configContext == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML));
        }
        Server server = ServerBeansFactory.getServerBean(configContext);
        HttpService httpService = server.getHttpService();
        Mime[] mimeArray = httpService.getMime();
        int n = 0;
        while (n < mimeArray.length) {
            Mime mime = mimeArray[n];
            String string = mime.getFile();
            String string2 = this.getBackupConfigDirPath() + File.separator + string;
            String string3 = this.getConfigDirPath() + File.separator + string;
            this.copyFile(new File(string3), new File(string2));
            String string4 = this.getTimeStampFileName(string2);
            this.saveTimeStamp(string4, string3);
            ++n;
        }
    }

    private void useManualVirtualServerConfFileChanges(ConfigContext configContext) throws ConfigException {
        ConfigContext configContext2 = ConfigFactory.createConfigContext(this.getConfigFilePath(), true, false, false);
        if (configContext2 == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML));
        }
        Server server = ServerBeansFactory.getServerBean(configContext2);
        HttpService httpService = server.getHttpService();
        VirtualServerClass[] virtualServerClassArray = httpService.getVirtualServerClass();
        int n = 0;
        while (n < virtualServerClassArray.length) {
            VirtualServerClass virtualServerClass = virtualServerClassArray[n];
            VirtualServer[] virtualServerArray = virtualServerClass.getVirtualServer();
            int n2 = 0;
            while (n2 < virtualServerArray.length) {
                VirtualServer virtualServer = virtualServerArray[n2];
                String string = virtualServer.getConfigFile();
                if (string != null && string.length() != 0) {
                    String string2 = this.getBackupConfigDirPath() + File.separator + string;
                    String string3 = this.getConfigDirPath() + File.separator + string;
                    this.copyFile(new File(string3), new File(string2));
                    if (this.isChownNeeded(null)) {
                        this.chownFile(string2);
                    }
                    String string4 = this.getTimeStampFileName(string2);
                    this.saveTimeStamp(string4, string3);
                }
                ++n2;
            }
            ++n;
        }
        this.deleteVirtualServerConfigFiles(configContext, configContext2, false);
    }

    private void deleteVirtualServerConfigFiles(ConfigContext configContext, ConfigContext configContext2, boolean bl) throws ConfigException {
        Server server = ServerBeansFactory.getServerBean(configContext);
        HttpService httpService = server.getHttpService();
        Server server2 = ServerBeansFactory.getServerBean(configContext2);
        HttpService httpService2 = server2.getHttpService();
        VirtualServerClass[] virtualServerClassArray = httpService.getVirtualServerClass();
        int n = 0;
        while (n < virtualServerClassArray.length) {
            VirtualServerClass virtualServerClass = virtualServerClassArray[n];
            String string = virtualServerClass.getId();
            VirtualServerClass virtualServerClass2 = httpService2.getVirtualServerClassById(string);
            boolean bl2 = false;
            if (virtualServerClass2 == null) {
                bl2 = true;
            }
            VirtualServer[] virtualServerArray = virtualServerClass.getVirtualServer();
            int n2 = 0;
            while (n2 < virtualServerArray.length) {
                String string2;
                VirtualServer virtualServer = virtualServerArray[n2];
                String string3 = virtualServer.getId();
                if ((bl2 || virtualServerClass2.getVirtualServerById(string3) == null) && (string2 = virtualServer.getConfigFile()) != null && string2.length() != 0) {
                    File file;
                    String string4 = bl ? this.getConfigDirPath() : this.getBackupConfigDirPath();
                    File file2 = new File(string4, string2);
                    if (file2.exists()) {
                        file2.delete();
                    }
                    if (!bl && (file = new File(string4, string2 + ".timestamp")).exists()) {
                        file.delete();
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTimeStampFiles() {
        this.init();
        Object object = lock;
        synchronized (object) {
            this.createTSFile(this.getTimeStampFileName(this.mBackupConfigFilePath), this.mConfigFilePath, this.mBackupConfigFilePath);
            this.createTSFile(this.getTimeStampFileName(this.mBackupInitFilePath), this.mInitFilePath, this.mBackupInitFilePath);
            this.createTSFile(this.getTimeStampFileName(this.mBackupObjectFilePath), this.mObjectFilePath, this.mBackupObjectFilePath);
            this.createTSFile(this.getTimeStampFileName(this.mBackupRealmsKeyFilePath), this.mRealmsKeyFilePath, this.mBackupRealmsKeyFilePath);
            this.createMimeTSFiles();
            this.createVirtualServersConfTSFiles();
        }
    }

    private void createTSFile(String string, String string2, String string3) {
        File file = new File(string);
        if (!file.exists()) {
            this.saveTimeStamp(string, string2, string3);
        }
    }

    private void createMimeTSFiles() {
        try {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mConfigFilePath, true, false, false);
            if (configContext == null) {
                return;
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            HttpService httpService = server.getHttpService();
            Mime[] mimeArray = httpService.getMime();
            int n = 0;
            while (n < mimeArray.length) {
                Mime mime = mimeArray[n];
                String string = mime.getFile();
                String string2 = this.getBackupConfigDirPath() + File.separator + string;
                String string3 = this.getConfigDirPath() + File.separator + string;
                String string4 = this.getTimeStampFileName(string2);
                File file = new File(string4);
                if (!file.exists()) {
                    this.saveTimeStamp(string4, string3, string2);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "core.create_mime_ts_file_exception", throwable);
        }
    }

    private void createVirtualServersConfTSFiles() {
        try {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mConfigFilePath, true, false, false);
            if (configContext == null) {
                return;
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            HttpService httpService = server.getHttpService();
            VirtualServerClass[] virtualServerClassArray = httpService.getVirtualServerClass();
            int n = 0;
            while (n < virtualServerClassArray.length) {
                VirtualServerClass virtualServerClass = virtualServerClassArray[n];
                VirtualServer[] virtualServerArray = virtualServerClass.getVirtualServer();
                int n2 = 0;
                while (n2 < virtualServerArray.length) {
                    VirtualServer virtualServer = virtualServerArray[n2];
                    String string = virtualServer.getConfigFile();
                    if (string != null && string.length() != 0) {
                        String string2 = this.getBackupConfigDirPath() + File.separator + string;
                        String string3 = this.getConfigDirPath() + File.separator + string;
                        String string4 = this.getTimeStampFileName(string2);
                        File file = new File(string4);
                        if (!file.exists()) {
                            this.saveTimeStamp(string4, string3, string2);
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "core.create_mime_ts_file_exception", throwable);
        }
    }

    private void saveTimeStamp(String string, String string2, String string3) {
        long l = this.saveTimeStamp(string, string2);
        new File(string3).setLastModified(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long saveTimeStamp(String string, String string2) {
        long l;
        block8: {
            l = this.getConfigFileTimeStamp(string2);
            File file = null;
            OutputStreamWriter outputStreamWriter = null;
            file = new File(string);
            outputStreamWriter = new FileWriter(file);
            outputStreamWriter.write("" + l);
            Object var9_6 = null;
            try {
                outputStreamWriter.close();
            }
            catch (Throwable throwable) {}
            break block8;
            {
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, "core.file_io_exception", throwable);
                    Object var9_7 = null;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (Throwable throwable2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyServerXmlChanges(boolean bl) throws ConfigException {
        this.init();
        Object object = lock;
        synchronized (object) {
            Object object2;
            if (!bl && this.hasHotXmlChanged()) {
                throw new AFRuntimeStoreException(Localizer.getValue(ExceptionType.CANNOT_APPLY_CHANGES));
            }
            try {
                object2 = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
                object2.flush(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2 = new File(this.mConfigFilePath);
            File file = new File(this.mBackupConfigFilePath);
            this.copyFile(file, (File)object2);
            this.saveTimeStamp(this.getTimeStampFileName(this.mBackupConfigFilePath), this.mConfigFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyInitFileChanges() throws ConfigException {
        this.init();
        File file = new File(this.mInitFilePath);
        File file2 = new File(this.mBackupInitFilePath);
        Object object = lock;
        synchronized (object) {
            this.copyFile(file2, file);
            this.saveTimeStamp(this.getTimeStampFileName(this.mBackupInitFilePath), this.mInitFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyRealmsKeyFileChanges() throws ConfigException {
        this.init();
        File file = new File(this.mRealmsKeyFilePath);
        File file2 = new File(this.mBackupRealmsKeyFilePath);
        Object object = lock;
        synchronized (object) {
            this.copyFile(file2, file);
            this.saveTimeStamp(this.getTimeStampFileName(this.mBackupRealmsKeyFilePath), this.mRealmsKeyFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyObjectFileChanges() throws ConfigException {
        this.init();
        File file = new File(this.mObjectFilePath);
        File file2 = new File(this.mBackupObjectFilePath);
        Object object = lock;
        synchronized (object) {
            this.copyFile(file2, file);
            this.saveTimeStamp(this.getTimeStampFileName(this.mBackupObjectFilePath), this.mObjectFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAllMimeFileChanges() throws ConfigException {
        this.init();
        Object object = lock;
        synchronized (object) {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
            if (configContext == null) {
                throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML_BU));
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            HttpService httpService = server.getHttpService();
            Mime[] mimeArray = httpService.getMime();
            int n = 0;
            while (n < mimeArray.length) {
                Mime mime = mimeArray[n];
                String string = mime.getFile();
                String string2 = this.getBackupConfigDirPath() + File.separator + string;
                String string3 = this.getConfigDirPath() + File.separator + string;
                this.copyFile(new File(string2), new File(string3));
                String string4 = this.getTimeStampFileName(string2);
                this.saveTimeStamp(string4, string3);
                ++n;
            }
        }
    }

    public void applyAclFileChanges() throws ConfigException {
        this.init();
        File file = new File(this.mAclFilePath);
        File file2 = new File(this.mBackupAclFilePath);
        this.copyFile(file2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyVirtualServersConfFileChanges(ConfigContext configContext) throws ConfigException {
        this.init();
        Object object = lock;
        synchronized (object) {
            ConfigContext configContext2 = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
            if (configContext2 == null) {
                throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML_BU));
            }
            Server server = ServerBeansFactory.getServerBean(configContext2);
            HttpService httpService = server.getHttpService();
            VirtualServerClass[] virtualServerClassArray = httpService.getVirtualServerClass();
            int n = 0;
            while (n < virtualServerClassArray.length) {
                VirtualServerClass virtualServerClass = virtualServerClassArray[n];
                VirtualServer[] virtualServerArray = virtualServerClass.getVirtualServer();
                int n2 = 0;
                while (n2 < virtualServerArray.length) {
                    VirtualServer virtualServer = virtualServerArray[n2];
                    String string = virtualServer.getConfigFile();
                    File file = null;
                    if (string != null) {
                        file = new File(this.getBackupConfigDirPath(), string);
                    }
                    if (file != null && file.exists()) {
                        File file2 = new File(this.getConfigDirPath(), string);
                        this.copyFile(file, file2);
                        if (this.isChownNeeded(null)) {
                            this.chownFile(file2.getAbsolutePath());
                        }
                        String string2 = this.getTimeStampFileName(file.getAbsolutePath());
                        this.saveTimeStamp(string2, file2.getAbsolutePath());
                    }
                    ++n2;
                }
                ++n;
            }
            this.deleteVirtualServerConfigFiles(configContext, configContext2, true);
        }
    }

    private void copyFile(File file, File file2) throws ConfigException {
        if (!file.exists()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FROM_NOT_EXIST, file.getPath()));
        }
        if (file.isDirectory()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FROM_IS_DIR, file.getPath()));
        }
        if (file2.isDirectory()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.TO_IS_DIR, file2.getPath()));
        }
        if (file2.exists() && !file2.canWrite()) {
            throw new ConfigException(Localizer.getValue(ExceptionType.TO_READ_ONLY, file2.getPath()));
        }
        try {
            FileUtils.copy(file, file2);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{file.getPath(), file2.getPath(), exception.toString()};
            throw new ConfigException(Localizer.getValue(ExceptionType.FAILED_COPY, objectArray), exception);
        }
    }

    private void createInstanceDirPath(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        this.mInstanceDirPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createConfigFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kConfigXMLFileName};
        this.mConfigFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createBackupConfigFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kBackupDirName, kConfigXMLFileName};
        this.mBackupConfigFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createApplicationRootPath() {
        try {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
            Server server = ServerBeansFactory.getServerBean(configContext);
            this.mApplicationRootPath = server.getApplicationRoot();
            if (this.mApplicationRootPath == null || this.mApplicationRootPath.length() <= 0) {
                this.createDefaultApplicationRootPath();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "InstanceEnv.createApplicationRootPath()", exception);
        }
    }

    private void createDefaultApplicationRootPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kRepositoryDirName};
        this.mApplicationRootPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createApplicationRepositoryPath() {
        String[] stringArray = new String[]{this.mApplicationRootPath, kApplicationDirName};
        this.mApplicationRepositoryPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createModuleRepositoryPath() {
        String[] stringArray = new String[]{this.mApplicationRootPath, kModuleDirName};
        this.mModuleRepositoryPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createApplicationBackupRepositoryPath() {
        String[] stringArray = new String[]{this.mApplicationRootPath, kBackupDirName, kApplicationDirName};
        this.mApplicationBackupRepositoryPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createModuleBackupRepositoryPath() {
        String[] stringArray = new String[]{this.mApplicationRootPath, kBackupDirName, kModuleDirName};
        this.mModuleBackupRepositoryPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createAutoDeployDirPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kAutoDeployDirName};
        this.mAutoDeployDirPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createLibPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kLibDirName};
        this.mLibPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createLibClassesPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kLibDirName, kLibClassesDirName};
        this.mLibClassesPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createApplicationStubPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kGeneratedDirName, kEJBStubDirName, kApplicationDirName};
        this.mApplicationStubRepositoryPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createModuleStubPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kGeneratedDirName, kEJBStubDirName, kModuleDirName};
        this.mModuleStubRepositoryPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private String getDefaultSessionStorePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kSessionStoreDirName};
        return StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createPassivatedEjbPaths() {
        try {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
            Server server = ServerBeansFactory.getServerBean(configContext);
            String string = server.getSessionStore();
            if (string == null || string.length() <= 0) {
                string = this.getDefaultSessionStorePath();
            }
            String[] stringArray = new String[]{string, kEJBStubDirName, kApplicationDirName};
            this.mApplicationPassivatedEjbPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
            stringArray[2] = kModuleDirName;
            this.mModulePassivatedEjbPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "InstanceEnv.createApplicationRootPath()", exception);
        }
    }

    private void createHttpSessionStorePaths() {
        try {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
            Server server = ServerBeansFactory.getServerBean(configContext);
            String string = server.getSessionStore();
            if (string == null || string.length() <= 0) {
                string = this.getDefaultSessionStorePath();
            }
            String[] stringArray = new String[]{string, kHttpSessionDirName, kApplicationDirName};
            this.mApplicationHttpSessionStorePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
            stringArray[2] = kModuleDirName;
            this.mModuleHttpSessionStorePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "InstanceEnv.createApplicationRootPath()", exception);
        }
    }

    private void createApplicationCompiledJspPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kGeneratedDirName, kCompileJspDirName, kApplicationDirName};
        this.mApplicationCompiledJspPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createWebModuleCompiledJspPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kGeneratedDirName, kCompileJspDirName, kModuleDirName};
        this.mWebModuleCompiledJspPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createDocRootPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kDocRootDirName};
        this.mDocRootPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createStopCommandPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath};
        String string = null;
        string = OS.isWindows() ? "stopserv.bat" : "stopserv";
        this.mStopCommandPath = StringUtils.makeFilePath((String[])stringArray, (boolean)true) + string;
    }

    private void createDefaultAccessLogPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, "logs", "access"};
        this.mDefaultAccessLogPath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createObjectFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kObjectFileName};
        this.mObjectFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createInitFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kInitFileName};
        this.mInitFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createSecurityPasswordsFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kSecurityPasswordsFileName};
        this.mSecurityPasswordsFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createRealmsKeyFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kRealmsKeyFileName};
        this.mRealmsKeyFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createBackupObjectFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kBackupDirName, kObjectFileName};
        this.mBackupObjectFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createBackupInitFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kBackupDirName, kInitFileName};
        this.mBackupInitFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createAclFilePath() {
        String string = this.kAclFilePrefix + "." + this.getName() + "." + this.kAclFileSuffix;
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, string};
        this.mAclFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createBackupAclFilePath() {
        String string = this.kBackupAclFilePrefix + "." + this.getName() + "." + this.kAclFileSuffix;
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, string};
        this.mBackupAclFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    private void createBackupRealmsKeyFilePath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kBackupDirName, kRealmsKeyFileName};
        this.mBackupRealmsKeyFilePath = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String getName() {
        return this.mLogicalName;
    }

    public String getInstanceDirPath() {
        return this.mInstanceDirPath;
    }

    public String getConfigDirPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName};
        String string = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
        return string;
    }

    public String getBackupConfigDirPath() {
        String[] stringArray = new String[]{this.mInstanceDirPath, kConfigDirName, kBackupDirName};
        String string = StringUtils.makeFilePath((String[])stringArray, (boolean)false);
        return string;
    }

    public String getConfigFilePath() {
        return this.mConfigFilePath;
    }

    public String getBackupConfigFilePath() {
        return this.mBackupConfigFilePath;
    }

    public String getApplicationRepositoryPath() {
        this.init();
        return this.mApplicationRepositoryPath;
    }

    public String getApplicationBackupRepositoryPath() {
        this.init();
        return this.mApplicationBackupRepositoryPath;
    }

    public String getModuleRepositoryPath() {
        this.init();
        return this.mModuleRepositoryPath;
    }

    public String getModuleBackupRepositoryPath() {
        this.init();
        return this.mModuleBackupRepositoryPath;
    }

    public String getApplicationStubPath() {
        this.init();
        return this.mApplicationStubRepositoryPath;
    }

    public String getModuleStubPath() {
        this.init();
        return this.mModuleStubRepositoryPath;
    }

    public String getLibPath() {
        this.init();
        return this.mLibPath;
    }

    public static String getTemplatesDirPath() {
        String string = System.getProperty("com.sun.aas.installRoot");
        String[] stringArray = new String[]{string, kLibDirName, kInstallDirName, kTemplatesDirName};
        return StringUtils.makeFilePath((String[])stringArray, (boolean)false);
    }

    public String getAutoDeployDirPath() {
        this.init();
        return this.mAutoDeployDirPath;
    }

    public String getLibClassesPath() {
        this.init();
        return this.mLibClassesPath;
    }

    public String getApplicationCompileJspPath() {
        this.init();
        return this.mApplicationCompiledJspPath;
    }

    public String getWebModuleCompileJspPath() {
        this.init();
        return this.mWebModuleCompiledJspPath;
    }

    public String getApplicationPassivatedEjbPath() {
        this.init();
        return this.mApplicationPassivatedEjbPath;
    }

    public String getModulePassivatedEjbPath() {
        this.init();
        return this.mModulePassivatedEjbPath;
    }

    public String getApplicationHttpSessionStorePath() {
        this.init();
        return this.mApplicationHttpSessionStorePath;
    }

    public String getModuleHttpSessionStorePath() {
        this.init();
        return this.mModuleHttpSessionStorePath;
    }

    public String getDocRootPath() {
        this.init();
        return this.mDocRootPath;
    }

    public String getStopCommandPath() {
        this.init();
        return this.mStopCommandPath;
    }

    public String getDefaultAccessLogPath() {
        this.init();
        return this.mDefaultAccessLogPath;
    }

    public String getInitFilePath() {
        this.init();
        return this.mInitFilePath;
    }

    public String getBackupInitFilePath() {
        this.init();
        return this.mBackupInitFilePath;
    }

    public String getSecurityPasswordsFilePath() {
        this.init();
        return this.mSecurityPasswordsFilePath;
    }

    public String getRealmsKeyFilePath() {
        this.init();
        return this.mRealmsKeyFilePath;
    }

    public String getBackupRealmsKeyFilePath() {
        this.init();
        return this.mBackupRealmsKeyFilePath;
    }

    public String getObjectFilePath() {
        this.init();
        return this.mObjectFilePath;
    }

    public String getBackupObjectFilePath() {
        this.init();
        return this.mBackupObjectFilePath;
    }

    public ApplicationEnvironment getApplicationEnvironment(String string) {
        this.init();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return new ApplicationEnvironment(this, string);
    }

    public ModuleEnvironment getModuleEnvironment(String string, DeployableObjectType deployableObjectType) {
        this.init();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return new ModuleEnvironment(this, string, deployableObjectType);
    }

    public String verify() {
        return null;
    }

    public String toString() {
        this.init();
        return ObjectAnalyzer.toString(this);
    }

    public final boolean isIASOwned(String string) {
        return this.isIASOwned(new File(string));
    }

    public final boolean isIASOwned(File file) {
        this.init();
        try {
            String string = this.getInstanceDirPath();
            if (!$assertionsDisabled && !StringUtils.ok((String)string)) {
                throw new AssertionError();
            }
            string = FileUtils.safeGetCanonicalPath(new File(string));
            String string2 = FileUtils.safeGetCanonicalPath(file);
            if (!StringUtils.ok((String)string)) {
                return false;
            }
            if (!StringUtils.ok((String)string2)) {
                return false;
            }
            return string2.startsWith(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartRequired() {
        this.init();
        Object object = lock;
        synchronized (object) {
            try {
                RMIClient rMIClient = AdminChannel.getRMIClient(this.mLogicalName);
                if (!rMIClient.isAlive()) {
                    return false;
                }
                return !rMIClient.hasRestartedSince(this.getManualChangeTime());
                {
                }
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private long getManualChangeTime() {
        long l = 0L;
        long l2 = 0L;
        try {
            ConfigContext configContext;
            l = this.getConfigFileTimeStamp(this.mInitFilePath);
            l2 = this.getConfigFileTimeStamp(this.mObjectFilePath);
            if (l < l2) {
                l = l2;
            }
            if (l < (l2 = this.getConfigFileTimeStamp(this.mConfigFilePath))) {
                l = l2;
            }
            if ((configContext = ConfigFactory.createConfigContext(this.mConfigFilePath, true, false, false)) == null) {
                throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML));
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            HttpService httpService = server.getHttpService();
            Mime[] mimeArray = httpService.getMime();
            int n = 0;
            while (n < mimeArray.length) {
                Mime mime = mimeArray[n];
                String string = mime.getFile();
                String string2 = this.getBackupConfigDirPath() + File.separator + string;
                String string3 = this.getConfigDirPath() + File.separator + string;
                l2 = this.getConfigFileTimeStamp(string3);
                if (l < l2) {
                    l = l2;
                }
                ++n;
            }
        }
        catch (Throwable throwable) {}
        return l;
    }

    private boolean hasBakMimeChanged() {
        try {
            ConfigContext configContext = ConfigFactory.createConfigContext(this.mBackupConfigFilePath);
            if (configContext == null) {
                throw new ConfigException(Localizer.getValue(ExceptionType.NO_XML_BU));
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            HttpService httpService = server.getHttpService();
            Mime[] mimeArray = httpService.getMime();
            int n = 0;
            while (n < mimeArray.length) {
                Mime mime = mimeArray[n];
                String string = mime.getFile();
                String string2 = this.getBackupConfigDirPath() + File.separator + string;
                String string3 = this.getConfigDirPath() + File.separator + string;
                long l = this.getConfigFileTimeStamp(string2);
                if (l > this.getConfigFileTimeStamp(string3)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public String getInstanceUser() throws IOException {
        this.init();
        return ServerManager.instance().getInstanceUser(this);
    }

    public boolean isChownNeeded(File file) {
        block3: {
            this.init();
            if (!OS.isUnix() && !OS.isLinux()) break block3;
            try {
                String string = ServerManager.instance().getInstanceUser(new InstanceEnvironment("admin-server"));
                String string2 = ServerManager.instance().getInstanceUser(this);
                if (string.equals("root") && !string2.equals(string)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                _logger.warning(iOException.getMessage());
            }
        }
        return false;
    }

    private void chownFile(String string) throws ConfigException {
        try {
            String string2 = new installConfig().chownFile(string, this.getInstanceUser());
            if (string2 != null) {
                throw new ConfigException(string2);
            }
        }
        catch (IOException iOException) {
            throw new ConfigException(iOException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$instance$InstanceEnvironment == null ? (class$com$iplanet$ias$instance$InstanceEnvironment = InstanceEnvironment.class$("com.iplanet.ias.instance.InstanceEnvironment")) : class$com$iplanet$ias$instance$InstanceEnvironment).desiredAssertionStatus();
        lock = new Object();
        _logger = LogDomains.getLogger("javax.enterprise.system.core");
    }
}

