/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment;

import com.iplanet.ias.deployment.AppClientXmlReader;
import com.iplanet.ias.deployment.AppConfigEnv;
import com.iplanet.ias.deployment.AppConfigException;
import com.iplanet.ias.deployment.ConnectorXmlReader;
import com.iplanet.ias.deployment.DOLDiagnostic;
import com.iplanet.ias.deployment.DescriptorConstants;
import com.iplanet.ias.deployment.EarConfigEnvImpl;
import com.iplanet.ias.deployment.EjbBundleXmlReader;
import com.iplanet.ias.deployment.WebBundleXmlReader;
import com.iplanet.ias.deployment.xml.IASApplicationRuntimeDescriptorNode;
import com.iplanet.ias.tools.common.dd.application.SunApplication;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFile;
import com.iplanet.ias.util.zip.ZipFileException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchivistFactory;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.netbeans.modules.schema2beans.BaseBean;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class ApplicationXmlReader
implements DescriptorConstants {
    private AppConfigEnv _appConfigEnv = null;
    private Application _application = null;
    private ApplicationNode _appNode = null;
    private static final String APP_CLIENT_PREFIX = "app-client";
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$ApplicationXmlReader == null ? (class$com$iplanet$ias$deployment$ApplicationXmlReader = ApplicationXmlReader.class$("com.iplanet.ias.deployment.ApplicationXmlReader")) : class$com$iplanet$ias$deployment$ApplicationXmlReader);
    static /* synthetic */ Class class$com$iplanet$ias$deployment$ApplicationXmlReader;
    static /* synthetic */ Class class$com$iplanet$ias$tools$common$dd$application$SunApplication;

    public ApplicationXmlReader(AppConfigEnv appConfigEnv) throws AppConfigException, IOException {
        this._appConfigEnv = appConfigEnv;
        InputStream inputStream = appConfigEnv.getApplicationXmlFile();
        try {
            this._appNode = ApplicationNode.read(inputStream, appConfigEnv.isValidating());
        }
        catch (ParseException parseException) {
            String string = localStrings.getString("enterprise.deployment.error_parsing_application_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string, parseException);
        }
        inputStream.close();
        try {
            String string = "app_" + appConfigEnv.getId();
            this._application = this._appNode.getApplication(null, string);
        }
        catch (ContentTransformationException contentTransformationException) {
            String string = localStrings.getString("enterprise.deployment.error_converting_application_xml", contentTransformationException.getMessage(), contentTransformationException.getXml(), "");
            throw new AppConfigException(string, contentTransformationException);
        }
    }

    public Application load(ClassLoader classLoader) throws AppConfigException {
        InputStream inputStream;
        File file = new File("temp");
        ApplicationArchivist applicationArchivist = ArchivistFactory.createApplicationArchivist(file, this._application);
        if (classLoader != null) {
            applicationArchivist.setClassLoader(classLoader);
        }
        this._application.setDummyArchivist(applicationArchivist);
        this._application.setRegistrationName(this._appConfigEnv.getId());
        this.addEjbModules(classLoader);
        if (!this._appConfigEnv.isEjbModulesOnly()) {
            this.addWebModules();
            this.addClientModules();
            this.addRarModules();
        }
        if ((inputStream = this._appConfigEnv.getApplicationIASXmlFile()) != null) {
            try {
                IASApplicationRuntimeDescriptorNode iASApplicationRuntimeDescriptorNode = IASApplicationRuntimeDescriptorNode.read(inputStream, this._appConfigEnv.isValidating());
                iASApplicationRuntimeDescriptorNode.updateIASApplicationRuntimeInformation(this._application);
            }
            catch (ParseException parseException) {
                SAXParseException sAXParseException = (SAXParseException)parseException.getSAXException();
                String string = localStrings.getString("enterprise.deployment.error_parsing_sun_application_dd", new Integer(sAXParseException.getLineNumber()), sAXParseException.getLocalizedMessage());
                throw new AppConfigException(string, sAXParseException);
            }
            catch (ContentTransformationException contentTransformationException) {
                String string = localStrings.getString("enterprise.deployment.error_converting_sun_application_xml", contentTransformationException.getMessage(), contentTransformationException.getXml(), "");
                throw new AppConfigException(string, contentTransformationException);
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string = localStrings.getString("enterprise.deployment.sun_application_dd_io_error");
                throw new AppConfigException(string, iOException);
            }
        }
        ApplicationNode.resolveInterJarEjbReferences(this._application);
        if (this._appConfigEnv.isVerifying()) {
            this._application.fillDocType(this._appConfigEnv.getApplicationXmlFile());
        }
        DOLDiagnostic.log(this._application);
        return this._application;
    }

    public static Application loadApplicationClients(File file, ClassLoader classLoader) throws AppConfigException, IOException, ZipFileException {
        Object object;
        Object object2;
        InputStream inputStream;
        Object object3;
        Serializable serializable;
        Object object4;
        String string;
        Object object5;
        JarFile jarFile = new JarFile(file);
        InputStream inputStream2 = ApplicationXmlReader.getZipInputStream(jarFile, "META-INF/application.xml");
        ApplicationNode applicationNode = null;
        try {
            applicationNode = ApplicationNode.read(inputStream2, false);
        }
        catch (ParseException parseException) {
            String string2 = localStrings.getString("enterprise.deployment.error_parsing_sun_application_dd", parseException.getSAXException().getMessage());
            throw new AppConfigException(string2, parseException);
        }
        inputStream2.close();
        Application application = null;
        try {
            application = applicationNode.getApplication(null, null);
        }
        catch (ContentTransformationException contentTransformationException) {
            String string3 = localStrings.getString("enterprise.deployment.error_converting_application_xml", file == null ? "" : file.getAbsolutePath(), contentTransformationException.getMessage(), contentTransformationException.getXml());
            throw new AppConfigException(string3, contentTransformationException);
        }
        ApplicationArchivist applicationArchivist = ArchivistFactory.createApplicationArchivist(file, application);
        application.setDummyArchivist(applicationArchivist);
        Enumeration enumeration = applicationNode.getEjbBundleArchiveMap().keys();
        while (enumeration.hasMoreElements()) {
            object5 = (String)enumeration.nextElement();
            string = (String)applicationNode.getEjbBundleArchiveMap().get(object5);
            object4 = null;
            serializable = File.createTempFile(APP_CLIENT_PREFIX, ".jar", FileUtil.getTempDirectory());
            ((File)serializable).deleteOnExit();
            ZipFile.extractJar((String)object5, jarFile, (File)serializable);
            object3 = new JarFile((File)serializable);
            inputStream = ApplicationXmlReader.getZipInputStream((JarFile)object3, "META-INF/MANIFEST.MF");
            if ("".equals(string)) {
                object2 = ApplicationXmlReader.getZipInputStream((JarFile)object3, "META-INF/ejb-jar.xml");
                object = ApplicationXmlReader.getZipInputStream((JarFile)object3, "META-INF/sun-ejb-jar.xml");
                object4 = EjbBundleXmlReader.load((InputStream)object2, (String)object5, classLoader, inputStream, (InputStream)object, application, false);
            } else {
                object2 = ApplicationXmlReader.getZipInputStream(jarFile, string);
                object = ApplicationXmlReader.getIasAltDDEntryName(string);
                InputStream inputStream3 = ApplicationXmlReader.getZipInputStream(jarFile, (String)object);
                object4 = EjbBundleXmlReader.load((InputStream)object2, (String)object5, classLoader, inputStream, inputStream3, application, false);
                ((BundleDescriptor)object4).getArchivist().setExternalDescriptorArchiveUri(string);
            }
            application.addEjbBundleDescriptor((EjbBundleDescriptor)object4);
        }
        object5 = applicationNode.getApplicationClientDescriptorArchiveMap().keys();
        while (object5.hasMoreElements()) {
            string = (String)object5.nextElement();
            object4 = (String)applicationNode.getApplicationClientDescriptorArchiveMap().get(string);
            serializable = null;
            object3 = File.createTempFile(APP_CLIENT_PREFIX, ".jar", FileUtil.getTempDirectory());
            ((File)object3).deleteOnExit();
            ZipFile.extractJar(string, jarFile, (File)object3);
            if ("".equals(object4)) {
                serializable = AppClientXmlReader.load((File)object3, string);
            } else {
                inputStream = ApplicationXmlReader.getZipInputStream(jarFile, (String)object4);
                object2 = ApplicationXmlReader.getIasAltDDEntryName((String)object4);
                object = ApplicationXmlReader.getZipInputStream(jarFile, (String)object2);
                serializable = AppClientXmlReader.load((File)object3, inputStream, (InputStream)object, string);
                ((BundleDescriptor)serializable).getArchivist().setExternalDescriptorArchiveUri((String)object4);
            }
            application.addApplicationClientDescriptor((ApplicationClientDescriptor)serializable);
        }
        ApplicationNode.resolveInterJarEjbReferences(application);
        return application;
    }

    private static InputStream getZipInputStream(JarFile jarFile, String string) throws AppConfigException {
        try {
            ZipEntry zipEntry = jarFile.getEntry(string);
            if (zipEntry == null) {
                String string2 = localStrings.getString("enterprise.deployment.application_entry_missing");
                throw new AppConfigException(string2);
            }
            return jarFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            String string3 = localStrings.getString("enterprise.deployment.zip_io_error", string, jarFile.toString());
            throw new AppConfigException(string3);
        }
    }

    public static String getIasAltDDEntryName(String string) {
        String string2 = null;
        int n = string.lastIndexOf("/");
        string2 = n != -1 ? string.substring(0, n + 1) + "sun-" + string.substring(n + 1) : "sun-" + string;
        return string2;
    }

    private void addEjbModules(ClassLoader classLoader) throws AppConfigException {
        try {
            Enumeration enumeration = this._appNode.getEjbBundleArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this._appNode.getEjbBundleArchiveMap().get(string);
                EjbBundleDescriptor ejbBundleDescriptor = null;
                if ("".equals(string2)) {
                    ejbBundleDescriptor = EjbBundleXmlReader.load(this._appConfigEnv, string, null, classLoader, this._application);
                } else {
                    ejbBundleDescriptor = EjbBundleXmlReader.load(this._appConfigEnv, string, string2, classLoader, this._application);
                    ejbBundleDescriptor.getArchivist().setExternalDescriptorArchiveUri(string2);
                }
                this._application.addEjbBundleDescriptor(ejbBundleDescriptor);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.error_reading_dd");
            throw new AppConfigException(string, throwable);
        }
    }

    private void addWebModules() throws AppConfigException {
        try {
            Enumeration enumeration = this._appNode.getWebBundleArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this._appNode.getWebBundleArchiveMap().get(string);
                WebBundleDescriptor webBundleDescriptor = null;
                if ("".equals(string2)) {
                    webBundleDescriptor = WebBundleXmlReader.load(this._appConfigEnv, string, null, this._application);
                } else {
                    webBundleDescriptor = WebBundleXmlReader.load(this._appConfigEnv, string, string2, this._application);
                    webBundleDescriptor.getArchivist().setExternalDescriptorArchiveUri(string2);
                }
                String string3 = this._appNode.getContextRootFor(string);
                webBundleDescriptor.setContextRoot(string3);
                this._application.addWebBundleDescriptor(webBundleDescriptor);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.web_xml_io_error");
            throw new AppConfigException(string, iOException);
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.error_reading_web_xml");
            throw new AppConfigException(string, throwable);
        }
    }

    private void addClientModules() throws AppConfigException {
        try {
            Enumeration enumeration = this._appNode.getApplicationClientDescriptorArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this._appNode.getApplicationClientDescriptorArchiveMap().get(string);
                ApplicationClientDescriptor applicationClientDescriptor = null;
                if ("".equals(string2)) {
                    applicationClientDescriptor = AppClientXmlReader.load(this._appConfigEnv, string, null);
                } else {
                    applicationClientDescriptor = AppClientXmlReader.load(this._appConfigEnv, string, string2);
                    applicationClientDescriptor.getArchivist().setExternalDescriptorArchiveUri(string2);
                }
                this._application.addApplicationClientDescriptor(applicationClientDescriptor);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.appclient_xml_io_error");
            throw new AppConfigException(string, iOException);
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.error_reading_appclient_xml");
            throw new AppConfigException(string, throwable);
        }
    }

    private void addRarModules() throws AppConfigException {
        try {
            Enumeration enumeration = this._appNode.getRarDescriptorArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this._appNode.getRarDescriptorArchiveMap().get(string);
                ConnectorDescriptor connectorDescriptor = null;
                if ("".equals(string2)) {
                    connectorDescriptor = ConnectorXmlReader.load(this._appConfigEnv, string, null);
                } else {
                    connectorDescriptor = ConnectorXmlReader.load(this._appConfigEnv, string, string2);
                    connectorDescriptor.getArchivist().setExternalDescriptorArchiveUri(string2);
                }
                this._application.addRarDescriptor(connectorDescriptor);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.rar_xml_io_error");
            throw new AppConfigException(string, iOException);
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.error_reading_rar_xml");
            throw new AppConfigException(string, throwable);
        }
    }

    public static Application openApplication(File file) throws AppConfigException {
        EarConfigEnvImpl earConfigEnvImpl = new EarConfigEnvImpl(file);
        File file2 = new File(earConfigEnvImpl.getAppDir());
        File[] fileArray = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return FileUtils.isJar(file);
            }
        });
        URLClassLoader uRLClassLoader = null;
        try {
            Object object;
            if (fileArray != null) {
                object = new URL[fileArray.length];
                int n = 0;
                while (n < ((URL[])object).length) {
                    object[n] = fileArray[n].toURL();
                    ++n;
                }
                uRLClassLoader = new URLClassLoader((URL[])object);
            } else {
                uRLClassLoader = new URLClassLoader(new URL[]{file2.toURL()});
            }
            object = new ApplicationXmlReader(earConfigEnvImpl);
            return ((ApplicationXmlReader)object).open(uRLClassLoader);
        }
        catch (MalformedURLException malformedURLException) {
            throw new AppConfigException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new AppConfigException(iOException);
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
    }

    public Application open(ClassLoader classLoader) throws AppConfigException {
        InputStream inputStream;
        File file = new File("temp");
        ApplicationArchivist applicationArchivist = ArchivistFactory.createApplicationArchivist(file, this._application);
        if (classLoader != null) {
            applicationArchivist.setClassLoader(classLoader);
        }
        this._application.setDummyArchivist(applicationArchivist);
        this._application.setRegistrationName(this._appConfigEnv.getId());
        this.openEjbModules(classLoader);
        if (!this._appConfigEnv.isEjbModulesOnly()) {
            this.openWebModules();
            this.openClientModules();
            this.openRarModules();
        }
        if ((inputStream = this._appConfigEnv.getApplicationIASXmlFile()) != null) {
            SunApplication sunApplication = ApplicationXmlReader.createSunApplicationDescriptorObj(inputStream, this._appConfigEnv.isValidating());
            this._application.setSunDescriptor(sunApplication);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string = localStrings.getString("enterprise.deployment.sun_application_dd_io_error");
                throw new AppConfigException(string, iOException);
            }
        }
        if (this._appConfigEnv.isVerifying()) {
            this._application.fillDocType(this._appConfigEnv.getApplicationXmlFile());
        }
        DOLDiagnostic.log(this._application);
        return this._application;
    }

    private void openEjbModules(ClassLoader classLoader) throws AppConfigException {
        try {
            Enumeration enumeration = this._appNode.getEjbBundleArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this._appNode.getEjbBundleArchiveMap().get(string);
                EjbBundleDescriptor ejbBundleDescriptor = null;
                if ("".equals(string2)) {
                    ejbBundleDescriptor = EjbBundleXmlReader.open(this._appConfigEnv, string, null, classLoader, this._application);
                } else {
                    ejbBundleDescriptor = EjbBundleXmlReader.open(this._appConfigEnv, string, string2, classLoader, this._application);
                    ejbBundleDescriptor.getArchivist().setExternalDescriptorArchiveUri(string2);
                }
                this._application.addEjbBundleDescriptor(ejbBundleDescriptor);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.error_reading_dd");
            throw new AppConfigException(string, throwable);
        }
    }

    private void openWebModules() throws AppConfigException {
        this.addWebModules();
    }

    private void openClientModules() throws AppConfigException {
        try {
            Enumeration enumeration = this._appNode.getApplicationClientDescriptorArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this._appNode.getApplicationClientDescriptorArchiveMap().get(string);
                ApplicationClientDescriptor applicationClientDescriptor = null;
                if ("".equals(string2)) {
                    applicationClientDescriptor = AppClientXmlReader.open(this._appConfigEnv, string, null);
                } else {
                    applicationClientDescriptor = AppClientXmlReader.open(this._appConfigEnv, string, string2);
                    applicationClientDescriptor.getArchivist().setExternalDescriptorArchiveUri(string2);
                }
                this._application.addApplicationClientDescriptor(applicationClientDescriptor);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.appclient_xml_io_error");
            throw new AppConfigException(string, iOException);
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.error_reading_appclient_xml");
            throw new AppConfigException(string, throwable);
        }
    }

    private void openRarModules() throws AppConfigException {
        try {
            Enumeration enumeration = this._appNode.getRarDescriptorArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this._appNode.getRarDescriptorArchiveMap().get(string);
                ConnectorDescriptor connectorDescriptor = null;
                if ("".equals(string2)) {
                    connectorDescriptor = ConnectorXmlReader.open(this._appConfigEnv, string, null);
                } else {
                    connectorDescriptor = ConnectorXmlReader.open(this._appConfigEnv, string, string2);
                    connectorDescriptor.getArchivist().setExternalDescriptorArchiveUri(string2);
                }
                this._application.addRarDescriptor(connectorDescriptor);
            }
        }
        catch (AppConfigException appConfigException) {
            throw appConfigException;
        }
        catch (IOException iOException) {
            String string = localStrings.getString("enterprise.deployment.rar_xml_io_error");
            throw new AppConfigException(string, iOException);
        }
        catch (Throwable throwable) {
            String string = localStrings.getString("enterprise.deployment.error_reading_rar_xml");
            throw new AppConfigException(string, throwable);
        }
    }

    public static SunApplication createSunApplicationDescriptorObj(InputStream inputStream, boolean bl) throws AppConfigException {
        try {
            XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(bl);
            SunApplication sunApplication = (SunApplication)BaseBean.createGraph((Class)(class$com$iplanet$ias$tools$common$dd$application$SunApplication == null ? (class$com$iplanet$ias$tools$common$dd$application$SunApplication = ApplicationXmlReader.class$("com.iplanet.ias.tools.common.dd.application.SunApplication")) : class$com$iplanet$ias$tools$common$dd$application$SunApplication), (InputStream)inputStream, (boolean)bl, (EntityResolver)xMLValidationHandler, (ErrorHandler)xMLValidationHandler);
            return sunApplication;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = localStrings.getString("enterprise.deployment.error_creating_application_xml_graph");
            throw new AppConfigException(string, exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

