/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.connectors.tools.security;

import com.iplanet.ias.connectors.deployment.IASDeploymentException;
import com.iplanet.ias.connectors.deployment.IASMCFFactory;
import com.iplanet.ias.connectors.tools.security.SecurityAdminToolMessages;
import com.iplanet.ias.connectors.tools.security.SecurityException;
import com.sun.enterprise.security.PrincipalImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public class PrincipalsTable
extends HashMap {
    private final String securityMappingLine = "<role-map>";
    private final String principalLine = "     <principal>";
    private final String backEndPrincipalLine = "       <backend-principal>";
    private final String userNameLine = "           <user-name>%%%%</user-name>";
    private final String passwordLine = "           <password>%%%%%%</password>";
    private final String backEndPrincipalEndLine = "       </backend-principal>";
    private final String principalEndLine = "     </principal>";
    private final String securityMappingEndLine = "</role-map>";
    private IASMCFFactory mcfFactory = null;
    private String jndiName;

    public PrincipalsTable() {
    }

    public PrincipalsTable(String string) {
        this.jndiName = string;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
    }

    public boolean isPrincipalExists(PrincipalImpl principalImpl) throws SecurityException {
        return this.containsKey(principalImpl);
    }

    public boolean isPrincipalExists(String string) throws SecurityException {
        return this.isPrincipalExists(new PrincipalImpl(string));
    }

    public PasswordCredential getPrincipalPasswordCredential(PrincipalImpl principalImpl) throws SecurityException {
        if (!this.isPrincipalExists(principalImpl)) {
            Object[] objectArray = new Object[]{principalImpl.toString()};
            throw new SecurityException(SecurityAdminToolMessages.PRINCIPAL_DOES_NOT_EXIST, objectArray);
        }
        Subject subject = (Subject)this.get(principalImpl);
        return this.getPasswordCredential(subject);
    }

    public PasswordCredential getPrincipalPasswordCredential(String string) throws SecurityException {
        return this.getPrincipalPasswordCredential(new PrincipalImpl(string));
    }

    public String getUserName(String string) throws SecurityException {
        return this.getPrincipalPasswordCredential(string).getUserName();
    }

    public String getPassword(String string) throws SecurityException {
        char[] cArray = this.getPrincipalPasswordCredential(string).getPassword();
        return new String(cArray);
    }

    public void addPrincipal(PrincipalImpl principalImpl, Subject subject) throws SecurityException {
        if (this.isPrincipalExists(principalImpl)) {
            Object[] objectArray = new Object[]{principalImpl.toString()};
            throw new SecurityException(SecurityAdminToolMessages.PRINCIPAL_ALREADY_EXISTS, objectArray);
        }
        this.put(principalImpl, subject);
    }

    public boolean removePrincipal(PrincipalImpl principalImpl) throws SecurityException {
        if (!this.isPrincipalExists(principalImpl)) {
            Object[] objectArray = new Object[]{principalImpl.toString()};
            throw new SecurityException(SecurityAdminToolMessages.PRINCIPAL_DOES_NOT_EXIST, objectArray);
        }
        Subject subject = (Subject)this.remove(principalImpl);
        return true;
    }

    public boolean removePrincipal(String string) throws SecurityException {
        return this.removePrincipal(new PrincipalImpl(string));
    }

    public void addPrincipal(String string, String string2, String string3) throws SecurityException {
        if (this.isPrincipalExists(string)) {
            Object[] objectArray = new Object[]{string};
            throw new SecurityException(SecurityAdminToolMessages.PRINCIPAL_ALREADY_EXISTS, objectArray);
        }
        char[] cArray = new char[string3.length()];
        string3.getChars(0, string3.length(), cArray, 0);
        PasswordCredential passwordCredential = new PasswordCredential(string2, cArray);
        this.addPrincipalToTable(new PrincipalImpl(string), passwordCredential);
    }

    public void addPrincipalToTable(PrincipalImpl principalImpl, final PasswordCredential passwordCredential) {
        final Subject subject = new Subject();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrincipalImpl principalImpl = new PrincipalImpl(passwordCredential.getUserName());
                subject.getPrincipals().add(principalImpl);
                subject.getPrivateCredentials().add(passwordCredential);
                return null;
            }
        });
        this.put(principalImpl, subject);
    }

    private PasswordCredential getPasswordCredential(final Subject subject) {
        PasswordCredential passwordCredential = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<Object> set = subject.getPrivateCredentials();
                Iterator<Object> iterator = set.iterator();
                PasswordCredential passwordCredential = (PasswordCredential)iterator.next();
                return passwordCredential;
            }
        });
        return passwordCredential;
    }

    public String getPrincipalBackEndUser(PrincipalImpl principalImpl) {
        Subject subject = (Subject)this.get(principalImpl);
        PasswordCredential passwordCredential = this.getPasswordCredential(subject);
        return passwordCredential.getUserName();
    }

    public String getPrincipalBackEndPassword(PrincipalImpl principalImpl) {
        Subject subject = (Subject)this.get(principalImpl);
        PasswordCredential passwordCredential = this.getPasswordCredential(subject);
        return new String(passwordCredential.getPassword());
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory managedConnectionFactory) {
        Set set = this.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Subject subject = (Subject)entry.getValue();
            PasswordCredential passwordCredential = this.getPasswordCredential(subject);
            passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
        }
    }

    private void writeTableToXMLFile() throws SecurityException {
        String string;
        try {
            PrincipalsTable principalsTable = this;
            this.mcfFactory = principalsTable.mcfFactory.getMCFFactory();
            string = this.mcfFactory.getInstanceByJndiName(this.jndiName).getXmlLocation();
        }
        catch (IASDeploymentException iASDeploymentException) {
            Object[] objectArray = new Object[]{"getMCFFactory" + iASDeploymentException.getMessage()};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_INVOCATION_METHOD, objectArray);
        }
        String string2 = string + "-new";
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            FileWriter fileWriter = new FileWriter(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.readHeaderOfXMLFile(bufferedReader, bufferedWriter);
            this.writeTableToXmlFile(bufferedWriter);
            this.readTailOfXMLFile(bufferedReader, bufferedWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{string};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_OPEN_FILE, objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{string};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_READ_FILE, objectArray);
        }
    }

    private void readHeaderOfXMLFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws SecurityException {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("     <principal>") == -1) {
                    bufferedWriter.write(string, 0, string.length());
                    bufferedWriter.newLine();
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{bufferedReader};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_OPEN_FILE, objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{bufferedReader};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_READ_FILE, objectArray);
        }
    }

    public void writeTableToXmlFile(BufferedWriter bufferedWriter) throws SecurityException {
        Object object;
        Object object2;
        Set set = null;
        if (this.isEmpty()) {
            return;
        }
        set = this.entrySet();
        Iterator iterator = set.iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            object2 = (PrincipalImpl)entry.getKey();
            object = this.getPrincipalBackEndUser((PrincipalImpl)object2);
            String string = this.getPrincipalBackEndPassword((PrincipalImpl)object2);
            this.writePrincipalToFile(((PrincipalImpl)object2).toString(), (String)object, string, bufferedWriter);
        }
        try {
            object2 = "</role-map>";
            bufferedWriter.write((String)object2, 0, ((String)object2).length());
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            object = new Object[]{bufferedWriter};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_WRITE_TO_FILE, (Object[])object);
        }
    }

    private void writePrincipalToFile(String string, String string2, String string3, BufferedWriter bufferedWriter) throws SecurityException {
        String string4 = "";
        try {
            string4 = "     <principal>";
            bufferedWriter.write(string4, 0, string4.length());
            bufferedWriter.newLine();
            string4 = "           <user-name>%%%%</user-name>";
            string4 = this.replaceString(string4, "%%%%", string);
            bufferedWriter.write(string4, 0, string4.length());
            bufferedWriter.newLine();
            string4 = "       <backend-principal>";
            bufferedWriter.write(string4, 0, string4.length());
            bufferedWriter.newLine();
            string4 = "           <user-name>%%%%</user-name>";
            string4 = this.replaceString(string4, "%%%%", string2);
            bufferedWriter.write(string4, 0, string4.length());
            bufferedWriter.newLine();
            string4 = "           <password>%%%%%%</password>";
            string4 = this.replaceString(string4, "%%%%%%", string3);
            bufferedWriter.write(string4, 0, string4.length());
            bufferedWriter.newLine();
            string4 = "       </backend-principal>";
            bufferedWriter.write(string4, 0, string4.length());
            bufferedWriter.newLine();
            string4 = "     </principal>";
            bufferedWriter.write(string4, 0, string4.length());
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{bufferedWriter};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_WRITE_TO_FILE, objectArray);
        }
    }

    private void readTailOfXMLFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws SecurityException {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("</role-map>") == -1) break;
            }
            while ((string = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Object[] objectArray = new Object[]{bufferedReader};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_OPEN_FILE, objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{bufferedReader};
            throw new SecurityException(SecurityAdminToolMessages.ERROR_DURING_READ_FILE, objectArray);
        }
    }

    private String replaceString(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        String string4 = "";
        while ((n2 = string.indexOf(string2, n)) != -1) {
            string4 = string4 + string.substring(n, n2) + string3;
            n = n2 + string2.length();
        }
        string4 = string4 + string.substring(n);
        return string4;
    }

    public String toString() {
        Set set = null;
        String string = "";
        set = this.entrySet();
        Iterator iterator = set.iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            PrincipalImpl principalImpl = (PrincipalImpl)entry.getKey();
            String string2 = this.getPrincipalBackEndUser(principalImpl);
            String string3 = this.getPrincipalBackEndPassword(principalImpl);
            string = string + " " + principalImpl.toString() + " " + string2 + " " + string3 + "\n";
        }
        return string;
    }
}

