/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.server.core.mbean.config;

import com.iplanet.ias.admin.common.EntityStatus;
import com.iplanet.ias.admin.common.constant.ConfigAttributeName;
import com.iplanet.ias.admin.common.exception.J2EEApplicationException;
import com.iplanet.ias.admin.common.exception.MBeanConfigException;
import com.iplanet.ias.admin.server.core.mbean.config.ConfigMBeanBase;
import com.iplanet.ias.admin.server.core.mbean.config.ModulesXMLHelper;
import com.iplanet.ias.config.serverbeans.ServerTags;
import javax.management.Attribute;

public class ManagedJ2EEApplication
extends ConfigMBeanBase
implements ConfigAttributeName.J2EEApplication {
    private static final String[][] MAPLIST = new String[][]{{"name", "@" + ServerTags.NAME}, {"location", "@" + ServerTags.LOCATION}, {"virtualServers", "@" + ServerTags.VIRTUAL_SERVERS}, {"enabled", "@" + ServerTags.ENABLED}, {"description", "@" + ConfigMBeanBase.PSEUDO_ATTR_DESCRIPTION}};
    private static final String[] ATTRIBUTES = new String[]{"name, String,     R", "location, String,     RW", "virtualServers, String,     RW", "enabled, boolean,    RW", "description, String,     RW"};
    private static final String[] OPERATIONS = new String[]{"getModules(), INFO", "getEjbModules(), INFO", "getWebModules(), INFO", "getStatus(), INFO", "enable(), ACTION", "disable(), ACTION"};

    public ManagedJ2EEApplication() throws MBeanConfigException {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedJ2EEApplication(String string, String string2) throws MBeanConfigException {
        this();
        this.initialize("application", new String[]{string, string2});
    }

    public String[] getModules() throws J2EEApplicationException {
        return this.getModulesByType(255);
    }

    public String[] getEjbModules() throws J2EEApplicationException {
        return this.getModulesByType(1);
    }

    public String[] getWebModules() throws J2EEApplicationException {
        return this.getModulesByType(2);
    }

    private String[] getModulesByType(int n) throws J2EEApplicationException {
        try {
            String string = (String)this.getAttribute("location");
            return ModulesXMLHelper.getModulesFromApplicationLocation(string, n);
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "getModulesByType", exception);
            throw new J2EEApplicationException(exception.getMessage());
        }
    }

    public EntityStatus getStatus() throws J2EEApplicationException {
        EntityStatus entityStatus = null;
        try {
            boolean bl = (Boolean)this.getAttribute("enabled");
            entityStatus = new EntityStatus();
            if (bl) {
                entityStatus.setEnabled();
            } else {
                entityStatus.setDisabled();
            }
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "getStatus", exception);
            throw new J2EEApplicationException(exception.getMessage());
        }
        return entityStatus;
    }

    public void disable() throws J2EEApplicationException {
        try {
            this.setAttribute(new Attribute("enabled", new Boolean(false)));
            super.getConfigContext().flush();
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "disable", exception);
            throw new J2EEApplicationException(exception.getMessage());
        }
    }

    public void enable() throws J2EEApplicationException {
        try {
            this.setAttribute(new Attribute("enabled", new Boolean(true)));
            super.getConfigContext().flush();
        }
        catch (Exception exception) {
            ConfigMBeanBase.sLogger.throwing(this.getClass().getName(), "enable", exception);
            throw new J2EEApplicationException(exception.getMessage());
        }
    }

    public static final void main(String[] stringArray) throws Exception {
        System.setProperty("com.sun.aas.instanceRoot", "e:\\tmp");
        ManagedJ2EEApplication managedJ2EEApplication = new ManagedJ2EEApplication("adminapp", "admserv");
        EntityStatus entityStatus = managedJ2EEApplication.getStatus();
        ConfigMBeanBase.sLogger.info("======== Status = " + entityStatus.getStatusString());
        if (entityStatus.isDisabled()) {
            ConfigMBeanBase.sLogger.info("======== Enabling app");
            managedJ2EEApplication.enable();
            entityStatus = managedJ2EEApplication.getStatus();
            ConfigMBeanBase.sLogger.info("======== Status = " + entityStatus.getStatusString());
        } else {
            ConfigMBeanBase.sLogger.info("======== Disabling app");
            managedJ2EEApplication.disable();
            entityStatus = managedJ2EEApplication.getStatus();
            ConfigMBeanBase.sLogger.info("======== Status = " + entityStatus.getStatusString());
        }
    }
}

