/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.server;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.tools.forte.server.AdminInstanceBean;
import com.iplanet.ias.tools.forte.server.PropChanger;
import com.iplanet.ias.tools.forte.util.NotifyUtil;
import java.beans.IntrospectionException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DeployedModulesNodeChildren
extends Children.Keys {
    protected List myKeys;
    private ChangeListener listener;
    AppServerInstance serv_inst;
    ServerInstanceManager serv_manager;
    AdminInstanceBean adminbn;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$actions$UndeployAction;

    public DeployedModulesNodeChildren(AppServerInstance si, AdminInstanceBean bn) {
        this.serv_inst = si;
        this.adminbn = bn;
    }

    protected void addNotify() {
        this.refreshList();
        this.listener = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                DeployedModulesNodeChildren.this.refreshList();
            }
        };
        PropChanger.getDefault().addChangeListener(this.listener);
    }

    protected void removeNotify() {
        if (this.listener != null) {
            PropChanger.getDefault().removeChangeListener(this.listener);
            this.listener = null;
        }
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        try {
            if (this.adminbn.adminRunning()) {
                return new Node[]{new DeployedModuleNode((String)key)};
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void refreshList() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.adminbn.adminRunning()) {
            this.serv_manager = ServerInstanceManagerFactory.getFactory().getServerInstanceManager(new HostAndPort(this.adminbn.getHost(), this.adminbn.getPort()), this.adminbn.getUserName(), this.adminbn.getPassword());
            try {
                AppServerInstance si = this.serv_manager.getServerInstance(this.serv_inst.getName());
                ServerModelIterator deployedMods = si.getDeployedModules();
                while (deployedMods.hasNext()) {
                    keys.add(deployedMods.next().toString());
                }
            }
            catch (AFTargetNotFoundException te) {
                NotifyUtil.showError(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren == null ? (class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren = DeployedModulesNodeChildren.class$("com.iplanet.ias.tools.forte.server.DeployedModulesNodeChildren")) : class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren), (String)"Err_NoTarget"), NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren == null ? (class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren = DeployedModulesNodeChildren.class$("com.iplanet.ias.tools.forte.server.DeployedModulesNodeChildren")) : class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren), (String)"Msg_ServError"));
            }
            catch (AFException ex) {
                NotifyUtil.showError(ex.getMessage(), NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren == null ? (class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren = DeployedModulesNodeChildren.class$("com.iplanet.ias.tools.forte.server.DeployedModulesNodeChildren")) : class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren), (String)"Msg_ServError"));
            }
            Collections.sort(keys);
            this.setKeys(keys);
        } else {
            this.removeNotify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DeployedModuleNode
    extends AbstractNode {
        private String key;
        private ChangeListener listener;
        private SystemAction[] adminUpactions = null;

        public DeployedModuleNode(String key) throws IntrospectionException {
            super(Children.LEAF);
            this.key = key;
            super.setName(key);
            String type = key.substring(key.indexOf("."), key.length());
            if (type.equals(".war")) {
                this.setIconBase("/com/iplanet/ias/tools/forte/resources/DeployedModuleWarIcon");
            } else {
                this.setIconBase("/com/iplanet/ias/tools/forte/resources/DeployedModuleEJBIcon");
            }
            String k_name = key.substring(0, key.indexOf("."));
            super.setDisplayName(k_name);
            this.adminUpactions = new SystemAction[]{SystemAction.get((Class)(class$com$iplanet$ias$tools$forte$actions$UndeployAction == null ? (class$com$iplanet$ias$tools$forte$actions$UndeployAction = DeployedModulesNodeChildren.class$("com.iplanet.ias.tools.forte.actions.UndeployAction")) : class$com$iplanet$ias$tools$forte$actions$UndeployAction))};
        }

        protected SystemAction[] createActions() {
            if (DeployedModulesNodeChildren.this.adminbn.adminRunning()) {
                return this.adminUpactions;
            }
            String mess = MessageFormat.format(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren == null ? (class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren = DeployedModulesNodeChildren.class$("com.iplanet.ias.tools.forte.server.DeployedModulesNodeChildren")) : class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren), (String)"Msg_ErrorConnect"), DeployedModulesNodeChildren.this.adminbn.getName());
            NotifyUtil.showError(mess, NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren == null ? (class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren = DeployedModulesNodeChildren.class$("com.iplanet.ias.tools.forte.server.DeployedModulesNodeChildren")) : class$com$iplanet$ias$tools$forte$server$DeployedModulesNodeChildren), (String)"Msg_ServError"));
            DeployedModulesNodeChildren.this.removeNotify();
            return null;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("S1_server.html");
        }

        public void setName(String nue) {
        }
    }
}

