/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.compile;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.compile.InternalCompiler;
import com.iplanet.ias.tools.forte.compile.InternalCompilerContext;
import com.iplanet.ias.tools.forte.compile.NullWriter;
import com.iplanet.ias.tools.forte.compile.TomcatOptionsImpl;
import com.iplanet.ias.tools.forte.compile.TomcatSourceMapper;
import com.iplanet.ias.tools.forte.compile.WDCompilationDescriptor;
import com.iplanet.ias.tools.forte.ejb.IASServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Date;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.Logger;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.JspSourceMapper;
import org.netbeans.modules.java.environment.Utilities;
import org.netbeans.modules.web.core.jsploader.CompilationClassLoader;
import org.netbeans.modules.web.core.jsploader.ErrorCompiler;
import org.netbeans.modules.web.core.jsploader.ExCompileContext;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class TomcatCompileContext
implements FfjJspCompileContext,
ExCompileContext {
    private static final boolean debug = false;
    private IASServer virtualHost;
    private static boolean loggerInitialized = false;

    static synchronized void initializeLogger() {
        if (!loggerInitialized) {
            DefaultLogger l = new DefaultLogger(null);
            Logger.setDefaultSink((Writer)new NullWriter());
            l.setName("JASPER_LOG");
            loggerInitialized = true;
        }
    }

    public TomcatCompileContext(IASServer virtualHost) {
        this.virtualHost = virtualHost;
    }

    public JspSourceMapper createSourceMapper(WebStandardData.WebJsp jspPage) throws IOException {
        return this.createTomcatSourceMapper(jspPage);
    }

    public InputStream getServletSource(WebStandardData.WebJsp jspPage) {
        String source = this.getDevelopmentCompilation(jspPage).getServletFileName();
        if (source != null) {
            try {
                return new FileInputStream(source);
            }
            catch (FileNotFoundException e) {
            }
        }
        return null;
    }

    public String getServletClassName(WebStandardData.WebJsp jspPage) {
        return ((TomcatDevelopmentCompilation)this.getDevelopmentCompilation(jspPage)).getFullClassName();
    }

    public String getRealClassName(WebStandardData.WebJsp jspPage) {
        return ((TomcatDevelopmentCompilation)this.getDevelopmentCompilation(jspPage)).getRealClassName();
    }

    public FfjJspCompileContext.DevelopmentCompilation getDevelopmentCompilation(WebStandardData.WebJsp jspPage) {
        return new TomcatDevelopmentCompilation(jspPage, this.virtualHost);
    }

    public static FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor constructJakartaErrorDescriptor(WebStandardData.WebModule wmRoot, WebStandardData.WebJsp jspPage, Throwable ex) {
        FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor ed = TomcatCompileContext.constructJakartaErrorDescriptor0(wmRoot, jspPage, ex);
        if (ed == null) {
            ed = new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor((WebStandardData.WebResource)jspPage, -1, -1, ErrorCompiler.getThrowableMessage((Throwable)ex, (boolean)true), "");
        }
        return ed;
    }

    public JspSourceMapper createTomcatSourceMapper(final WebStandardData.WebJsp jspPage) throws IOException {
        InputStream servletIs = this.getServletSource(jspPage);
        if (servletIs == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(servletIs));
        TomcatSourceMapper mapper = new TomcatSourceMapper(reader, new JspSourceMapper.NameConverter(){

            public String convert(String jspFileName) throws IOException {
                String result = jspFileName;
                FileObject ff = JspCompileUtil.findFileObjectForFile((FileSystem)JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)jspPage).getFileSystem(), (String)jspFileName);
                if (null != ff) {
                    result = ff.toString();
                }
                return result;
            }
        });
        if (mapper.isEmpty()) {
            mapper.setPrimaryJspFileName(JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)jspPage).getPackageNameExt('/', '.'));
        }
        if (mapper.size() == 0) {
            throw new IllegalArgumentException(" sourceMangler.size() == 0");
        }
        return mapper;
    }

    private static FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor constructJakartaErrorDescriptor0(WebStandardData.WebModule wmRoot, WebStandardData.WebJsp jspPage, Throwable ex) {
        while (!(ex instanceof ParseException) && !(ex instanceof CompileException)) {
            if (!(ex instanceof JasperException)) {
                return null;
            }
            ex = ((JasperException)ex).getRootCause();
        }
        String m1 = ex.getMessage();
        int lpar = m1.indexOf(40);
        if (lpar == -1) {
            return null;
        }
        int comma = m1.indexOf(44, lpar);
        if (comma == -1) {
            return null;
        }
        int rpar = m1.indexOf(41, comma);
        if (rpar == -1) {
            return null;
        }
        String line = m1.substring(lpar + 1, comma);
        String col = m1.substring(comma + 1, rpar);
        String fileName = m1.substring(0, lpar);
        File file = wmRoot.getDocumentBase();
        String wmFileName = file.getAbsolutePath();
        WebStandardData.WebJsp errorResource = jspPage;
        if (fileName.startsWith(wmFileName)) {
            WebStandardData.WebResource resTemp;
            String errorRes = fileName.substring(wmFileName.length());
            if ((errorRes = errorRes.replace(File.separatorChar, '/')).startsWith("/")) {
                errorRes = errorRes.substring(1);
            }
            if ((resTemp = wmRoot.findResource(errorRes)) != null) {
                errorResource = resTemp;
            }
        }
        try {
            return new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor((WebStandardData.WebResource)errorResource, Integer.parseInt(line) + 1, Integer.parseInt(col), m1.substring(rpar + 1).trim(), "");
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class TomcatDevelopmentCompilation
    implements FfjJspCompileContext.DevelopmentCompilation {
        private transient String additionalClassPath;
        protected WebStandardData.WebJsp jspPage;
        protected IASServer virtualHost;
        String className;
        String javaFileName;
        String classFileName;
        String realClassName;
        String currentServletFileName;
        String currentServletClassName;
        String currentClassFileName;
        private boolean outDated;

        TomcatDevelopmentCompilation(WebStandardData.WebJsp jspPage, IASServer virtualHost) {
            this.jspPage = jspPage;
            this.virtualHost = virtualHost;
            this.initialize();
        }

        private void initialize() {
            Reporter.verbose("resource URI is " + this.jspPage.getResourceURI());
            String jspResource = "/" + this.jspPage.getResourceURI();
            boolean isErrorPage = false;
            this.outDated = true;
            try {
                TomcatOptionsImpl options = new TomcatOptionsImpl(this.jspPage, this.virtualHost);
                WDCompilationDescriptor cd = new WDCompilationDescriptor(this.jspPage.getWebModule(), jspResource);
                InternalCompilerContext clctxt = new InternalCompilerContext((ClassLoader)new CompilationClassLoader(this.getClass().getClassLoader()), jspResource, cd, isErrorPage, options);
                InternalCompiler comp = (InternalCompiler)clctxt.createCompiler();
                this.className = comp.getMangler().getClassName();
                this.javaFileName = comp.getMangler().getJavaFileName();
                this.classFileName = comp.getMangler().getClassFileName();
                this.realClassName = clctxt.getRealClassName();
                Reporter.verbose("TomcatCompileContext1: className = " + this.className);
                Reporter.verbose("TomcatCompileContext1: javaFileName = " + this.javaFileName);
                Reporter.verbose("TomcatCompileContext1: classFileName = " + this.classFileName);
                Reporter.verbose("TomcatCompileContext1: JspCompiler.outdated() = " + comp.isOutDated());
                File f1 = new File(this.javaFileName);
                this.currentServletFileName = f1.exists() ? this.javaFileName : null;
                this.currentServletClassName = f1.exists() ? this.className : null;
                File f2 = new File(this.classFileName);
                this.currentClassFileName = f2.exists() ? this.classFileName : null;
                File classFile = new File(this.classFileName);
                if (!classFile.exists()) {
                    this.outDated = true;
                    Reporter.verbose("TomcatCompileContext2: classFileDoesNotExist");
                } else {
                    FileObject fo = JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)this.jspPage);
                    if (fo == null) {
                        throw new IOException();
                    }
                    File jspReal = NbClassPath.toFile((FileObject)fo);
                    this.outDated = classFile.lastModified() < jspReal.lastModified();
                    Reporter.verbose("TomcatCompileContext2: jspReal = " + jspReal + " lastMod = " + new Date(jspReal.lastModified()));
                    Reporter.verbose("TomcatCompileContext2: classFile = " + classFile + " lastMod = " + new Date(classFile.lastModified()));
                }
                Reporter.verbose("TomcatCompileContext3: outDated = " + this.outDated);
            }
            catch (IOException e) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)e);
            }
            catch (JasperException e) {
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)e);
            }
        }

        public boolean isOutDated() {
            return this.outDated;
        }

        public void cleanJSP() throws IOException {
            FileObject fo;
            if (this.currentServletFileName != null) {
                Reporter.verbose("cleaning " + this.currentServletFileName);
                fo = JspCompileUtil.findFileObjectForFile((String)this.currentServletFileName);
                if (fo == null) {
                    new File(this.currentServletFileName).delete();
                } else {
                    fo.delete();
                }
            }
            if (this.currentClassFileName != null) {
                Reporter.verbose("cleaning " + this.currentClassFileName);
                fo = JspCompileUtil.findFileObjectForFile((String)this.currentClassFileName);
                if (fo == null) {
                    new File(this.currentClassFileName).delete();
                } else {
                    fo.delete();
                }
            }
        }

        public String getAdditionalClassPath() {
            if (this.additionalClassPath == null) {
                StringBuffer cp = new StringBuffer();
                cp.append(this.getClassPathItem("tomcat401/common/lib/xerces.jar"));
                cp.append(File.pathSeparatorChar);
                cp.append(this.getClassPathItem("tomcat401/lib/jasper-runtime.jar"));
                this.additionalClassPath = cp.toString();
            }
            return this.additionalClassPath;
        }

        private String getClassPathItem(String relativeResource) {
            String file = relativeResource.replace('/', File.separatorChar);
            return Utilities.findInstalledFile((String)file).getAbsolutePath();
        }

        public void compilePreDeploy() throws IOException {
        }

        public String getServletFileName() {
            return this.currentServletFileName;
        }

        String getFullClassName() {
            return this.currentServletClassName;
        }

        String getRealClassName() {
            return this.realClassName;
        }

        public String getServletEncoding() {
            return "UTF8";
        }

        public FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[] compileJspToServlet(boolean isErrorPage, String compilationURI, String encoding, ClassLoader cl) throws IOException {
            TomcatCompileContext.initializeLogger();
            TomcatOptionsImpl options = new TomcatOptionsImpl(this.jspPage, this.virtualHost);
            try {
                WDCompilationDescriptor cd = new WDCompilationDescriptor(this.jspPage.getWebModule(), compilationURI);
                String jspResource = "/" + this.jspPage.getResourceURI();
                InternalCompilerContext clctxt = new InternalCompilerContext((ClassLoader)new CompilationClassLoader(this.getClass().getClassLoader()), jspResource, cd, isErrorPage, options);
                Compiler comp = clctxt.createCompiler();
                boolean wasOutDated = comp.compile();
                Reporter.verbose("compileJspToServlet:wasOutDated " + wasOutDated);
                return null;
            }
            catch (Exception e) {
                FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor ed = TomcatCompileContext.constructJakartaErrorDescriptor(this.jspPage.getWebModule(), this.jspPage, e);
                return new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[]{ed};
            }
        }
    }
}

