/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.common.ui;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;

public class GenericTableInfo {
    private int numCols = 0;
    private int numRows = 0;
    private String[][] data = null;
    private String[] columnNames = null;
    private boolean[] isEditable = null;

    public GenericTableInfo(int nc) {
        this.numCols = nc;
        Reporter.assertIt(nc > 0);
        this.columnNames = new String[this.numCols];
        this.isEditable = new boolean[this.numCols];
        int i = 0;
        while (i < this.numCols) {
            this.columnNames[i] = "Column " + i;
            this.isEditable[i] = true;
            ++i;
        }
    }

    public GenericTableInfo(int nr, int nc) {
        this.numCols = nc;
        this.numRows = nr;
        Reporter.assertIt(nc > 0);
        Reporter.assertIt(nr >= 0);
        this.data = new String[this.numCols][this.numRows];
        this.columnNames = new String[this.numCols];
        this.isEditable = new boolean[this.numCols];
        int i = 0;
        while (i < this.numCols) {
            this.columnNames[i] = "Column " + i;
            this.isEditable[i] = true;
            ++i;
        }
    }

    public void setColumnName(int col, String name) {
        this.checkColumnNumber(col);
        this.columnNames[col] = name;
    }

    public String getColumnName(int col) {
        this.checkColumnNumber(col);
        return this.columnNames[col];
    }

    public void setString(int row, int col, String name) {
        this.checkColumnNumber(col);
        this.checkRowNumber(row);
        this.data[col][row] = name;
    }

    public String getString(int row, int col) {
        this.checkColumnNumber(col);
        this.checkRowNumber(row);
        return this.data[col][row];
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public void setColumnReadOnly(int c) {
        this.checkColumnNumber(c);
        this.isEditable[c] = false;
    }

    public boolean isColumnEditable(int c) {
        this.checkColumnNumber(c);
        return this.isEditable[c];
    }

    public String toString() {
        String s = "";
        int c = 0;
        while (c < this.numCols) {
            s = s + "Column Name " + c + ":  " + this.columnNames[c] + "\n";
            ++c;
        }
        int r = 0;
        while (r < this.numRows) {
            int c2 = 0;
            while (c2 < this.numCols) {
                s = s + "row " + r + ", col " + c2 + ":  " + this.data[c2][r] + "\n";
                ++c2;
            }
            ++r;
        }
        return s;
    }

    private void checkColumnNumber(int col) {
        if (col < 0 || col >= this.numCols) {
            throw new IllegalArgumentException("column number must be between 0 and " + (this.numCols - 1) + " -- attempted to use non-existant column # " + col);
        }
    }

    private void checkRowNumber(int row) {
        if (row < 0 || row >= this.numRows) {
            throw new IllegalArgumentException("Row number must be between 0 and " + (this.numRows - 1) + " -- attempted to use non-existant row # " + row);
        }
    }

    public static void main(String[] args) {
        GenericTableInfo gti = new GenericTableInfo(2, 3);
        gti.setColumnName(0, "Col 0 here!");
        gti.setColumnName(1, "Col 1 here!");
        int r = 0;
        while (r < 2) {
            int c = 0;
            while (c < 3) {
                gti.setString(r, c, "c" + c + "r" + r);
                ++c;
            }
            ++r;
        }
        System.out.println("" + gti);
    }
}

