/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.util;

import com.iplanet.ias.admin.util.Assert;

public class Logger {
    private static final int LOG_BASE = 13;
    public static final int LOG_OFF = 13;
    public static final int LOG_ERRORS = 14;
    public static final int LOG_DEBUG = 15;
    private static Logger mInstance = new Logger();
    protected static int sLogLevel = 15;

    Logger() {
    }

    protected void _log(String msg) {
        System.out.println(msg);
    }

    public static int setLogLevel(int logLevel) {
        int oldLevel = Logger.getLogLevel();
        Assert.assertit(logLevel != 13 && logLevel != 14 && logLevel != 15, "illegal log level");
        sLogLevel = logLevel;
        return oldLevel;
    }

    Logger getInstance() {
        return mInstance;
    }

    public static int getLogLevel() {
        return sLogLevel;
    }

    public static void log(String msg) {
        if (sLogLevel >= 15) {
            System.out.println(msg);
        }
    }

    public static void log(Object object) {
        if (sLogLevel >= 15 && object != null) {
            Logger.log(object.toString());
        }
    }

    public static void logError(String msg) {
        if (sLogLevel >= 14 && msg != null) {
            Logger.log(msg);
        }
    }

    public static void logFatal(String msg) {
        Logger.log(msg);
    }
}

