/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import java.io.ObjectStreamException;
import java.sql.Timestamp;

public class SqlTimestamp
extends Timestamp
implements SCODate {
    private transient PersistenceCapable owner;
    private transient String fieldName;

    public SqlTimestamp(Object object, String string) {
        super(0L);
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
    }

    public SqlTimestamp(Object object, String string, long l) {
        super(l);
        if (object instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)object;
            this.fieldName = string;
        }
    }

    public void setTime(long l) {
        this.makeDirty();
        super.setTime(l);
    }

    public void setNanos(int n) {
        this.makeDirty();
        super.setNanos(n);
    }

    public Object clone() {
        SqlTimestamp sqlTimestamp = (SqlTimestamp)super.clone();
        sqlTimestamp.owner = null;
        sqlTimestamp.fieldName = null;
        return sqlTimestamp;
    }

    public void setYear(int n) {
        this.makeDirty();
        super.setYear(n);
    }

    public void setMonth(int n) {
        this.makeDirty();
        super.setMonth(n);
    }

    public void setDate(int n) {
        this.makeDirty();
        super.setDate(n);
    }

    public void setHours(int n) {
        this.makeDirty();
        super.setHours(n);
    }

    public void setMinutes(int n) {
        this.makeDirty();
        super.setMinutes(n);
    }

    public void setSeconds(int n) {
        this.makeDirty();
        super.setSeconds(n);
    }

    public Object cloneInternal() {
        return super.clone();
    }

    public void setTimeInternal(long l) {
        super.setTime(l);
    }

    public void setNanosInternal(int n) {
        super.setNanos(n);
    }

    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
    }

    public Object getOwner() {
        return this.owner;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StateManager makeDirty() {
        if (this.owner == null) return null;
        StateManager stateManager = this.owner.jdoGetStateManager();
        if (stateManager == null) return null;
        PersistenceManager persistenceManager = (PersistenceManager)stateManager.getPersistenceManagerInternal();
        persistenceManager.acquireShareLock();
        try {
            StateManager stateManager2 = stateManager;
            synchronized (stateManager2) {
                if (this.owner != null) {
                    stateManager.makeDirty(this.fieldName);
                    StateManager stateManager3 = stateManager;
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                    Object var7_5 = null;
                    persistenceManager.releaseShareLock();
                    return stateManager3;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            persistenceManager.releaseShareLock();
            throw throwable;
        }
        Object var7_6 = null;
        persistenceManager.releaseShareLock();
        return null;
    }

    public void applyUpdates(StateManager stateManager, boolean bl) {
    }

    Object writeReplace() throws ObjectStreamException {
        Timestamp timestamp = new Timestamp(this.getTime());
        timestamp.setNanos(this.getNanos());
        return timestamp;
    }
}

