/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ANTLRException;
import antlr.TokenBuffer;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOQueryException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.support.sqlstore.ExtentCollection;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.CodeGeneration;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLLexer;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLParser;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.LogHelperQueryCompilerJDO;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.Optimizer;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.Semantic;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

public class JQLC {
    protected TypeTable typetab;
    protected ErrorMsg errorMsg;
    protected Class candidateClass;
    protected JQLAST filterAST = null;
    protected JQLAST importsAST = null;
    protected JQLAST varsAST = null;
    protected JQLAST paramsAST = null;
    protected JQLAST orderingAST = null;
    protected JQLAST resultAST = null;
    protected JQLAST queryAST = null;
    protected Map retrieveDescCache = new WeakHashMap();
    protected static final ResourceBundle messages = I18NHelper.loadBundle(class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$JQLC == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$JQLC = JQLC.class$("com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLC")) : class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$JQLC);
    private static Logger logger = LogHelperQueryCompilerJDO.getLogger();
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$query$jqlc$JQLC;

    public JQLC() {
        this.errorMsg = new ErrorMsg();
    }

    public void setClass(Class clazz) {
        if (clazz == null) {
            JDOQueryException jDOQueryException = new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.jqlc.generic.nocandidateclass"));
            logger.throwing("jqlc.JQLC", "setClass", jDOQueryException);
            throw jDOQueryException;
        }
        this.candidateClass = clazz;
    }

    public void declareImports(String string) {
        if (string == null) {
            this.importsAST = null;
            return;
        }
        try {
            JQLParser jQLParser = this.createStringParser(string);
            jQLParser.parseImports();
            this.importsAST = (JQLAST)jQLParser.getAST();
        }
        catch (ANTLRException aNTLRException) {
            JQLParser.handleANTLRException(aNTLRException, this.errorMsg);
        }
    }

    public void declareParameters(String string) {
        if (string == null) {
            this.paramsAST = null;
            return;
        }
        try {
            JQLParser jQLParser = this.createStringParser(string);
            jQLParser.parseParameters();
            this.paramsAST = (JQLAST)jQLParser.getAST();
        }
        catch (ANTLRException aNTLRException) {
            JQLParser.handleANTLRException(aNTLRException, this.errorMsg);
        }
    }

    public void declareVariables(String string) {
        if (string == null) {
            this.varsAST = null;
            return;
        }
        try {
            JQLParser jQLParser = this.createStringParser(string);
            jQLParser.parseVariables();
            this.varsAST = (JQLAST)jQLParser.getAST();
        }
        catch (ANTLRException aNTLRException) {
            JQLParser.handleANTLRException(aNTLRException, this.errorMsg);
        }
    }

    public void setOrdering(String string) {
        if (string == null) {
            this.orderingAST = null;
            return;
        }
        try {
            JQLParser jQLParser = this.createStringParser(string);
            jQLParser.parseOrdering();
            this.orderingAST = (JQLAST)jQLParser.getAST();
        }
        catch (ANTLRException aNTLRException) {
            JQLParser.handleANTLRException(aNTLRException, this.errorMsg);
        }
    }

    public void setResult(String string) {
        if (string == null) {
            this.resultAST = null;
            return;
        }
        try {
            JQLParser jQLParser = this.createStringParser(string);
            jQLParser.parseResult();
            this.resultAST = (JQLAST)jQLParser.getAST();
        }
        catch (ANTLRException aNTLRException) {
            JQLParser.handleANTLRException(aNTLRException, this.errorMsg);
        }
    }

    public void setFilter(String string) {
        if (StringHelper.isEmpty(string)) {
            string = "true";
        }
        try {
            JQLParser jQLParser = this.createStringParser(string);
            jQLParser.parseFilter();
            this.filterAST = (JQLAST)jQLParser.getAST();
        }
        catch (ANTLRException aNTLRException) {
            JQLParser.handleANTLRException(aNTLRException, this.errorMsg);
        }
    }

    public void semanticCheck(ParameterTable parameterTable) {
        boolean bl = logger.isLoggable(400);
        boolean bl2 = logger.isLoggable(300);
        this.typetab = TypeTable.getInstance(this.candidateClass.getClassLoader());
        parameterTable.init();
        Semantic semantic = new Semantic();
        semantic.init(this.typetab, parameterTable, this.errorMsg);
        semantic.setASTFactory(JQLAST.Factory.getInstance());
        JQLAST jQLAST = semantic.checkCandidateClass(this.candidateClass);
        this.queryAST = semantic.createQueryAST(jQLAST, this.importsAST, this.paramsAST, this.varsAST, this.orderingAST, this.resultAST, this.filterAST);
        if (bl2) {
            logger.finest("LOG_JQLCDumpTree", this.queryAST.getTreeRepr("(AST)"));
        }
        try {
            if (bl) {
                logger.finer("LOG_JQLCStartPass", "semantic analysis");
            }
            semantic.query(this.queryAST);
            this.queryAST = (JQLAST)semantic.getAST();
            if (bl2) {
                logger.finest("LOG_JQLCDumpTree", this.queryAST.getTreeRepr("(typed AST)"));
            }
        }
        catch (ANTLRException aNTLRException) {
            this.errorMsg.fatal("JQLC.semanticCheck unexpected exception", aNTLRException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetrieveDesc codeGen(PersistenceManager persistenceManager, ParameterTable parameterTable) {
        boolean bl = logger.isLoggable(400);
        boolean bl2 = logger.isLoggable(300);
        RetrieveDesc retrieveDesc = null;
        String string = parameterTable.getKeyForRetrieveDescCache();
        Map map = this.retrieveDescCache;
        synchronized (map) {
            if (string != null) {
                retrieveDesc = (RetrieveDesc)this.retrieveDescCache.get(string);
            }
            if (retrieveDesc == null) {
                Optimizer optimizer = new Optimizer();
                optimizer.init(this.typetab, parameterTable, this.errorMsg);
                optimizer.setASTFactory(JQLAST.Factory.getInstance());
                CodeGeneration codeGeneration = new CodeGeneration();
                codeGeneration.init(persistenceManager, this.typetab, parameterTable, this.errorMsg);
                codeGeneration.setASTFactory(JQLAST.Factory.getInstance());
                try {
                    JQLAST jQLAST = this.queryAST;
                    if (bl) {
                        logger.finer("LOG_JQLCStartPass", "optimizer");
                    }
                    optimizer.query(jQLAST);
                    jQLAST = (JQLAST)optimizer.getAST();
                    if (bl2) {
                        logger.finest("LOG_JQLCDumpTree", jQLAST.getTreeRepr("(optimized AST)"));
                    }
                    if (bl) {
                        logger.finer("LOG_JQLCStartPass", "code generation");
                    }
                    codeGeneration.query(jQLAST);
                    retrieveDesc = codeGeneration.getRetrieveDesc();
                    if (string != null) {
                        this.retrieveDescCache.put(string, retrieveDesc);
                    }
                }
                catch (ANTLRException aNTLRException) {
                    this.errorMsg.fatal("JQLC.codeGen unexpected exception", aNTLRException);
                }
            } else if (bl) {
                logger.finest("LOG_JQLCReuseRetrieveDesc");
            }
        }
        return retrieveDesc;
    }

    public void checkCandidates(Class clazz, Collection collection) {
        if (clazz == null) {
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.jqlc.generic.nocandidateclass"));
        }
        if (!(collection instanceof ExtentCollection)) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jqlc.jqlc.checkcandidates.memorycollection"));
        }
        Class clazz2 = ((ExtentCollection)collection).getPersistenceCapableClass();
        if (clazz2 == null) {
            throw new JDOFatalInternalException("persistence capable class of extent collection is null");
        }
        if (!clazz.getName().equals(clazz2.getName())) {
            throw new JDOQueryException(I18NHelper.getMessage(messages, "jqlc.jqlc.checkcandidates.mismatch", clazz.getName()));
        }
    }

    private JQLParser createStringParser(String string) {
        return JQLC.createStringParser(string, this.errorMsg);
    }

    public static JQLParser createStringParser(String string, ErrorMsg errorMsg) {
        StringReader stringReader = new StringReader(string);
        JQLLexer jQLLexer = new JQLLexer(stringReader);
        jQLLexer.init(errorMsg);
        jQLLexer.setTokenObjectClass("com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLLexer$JQLToken");
        TokenBuffer tokenBuffer = new TokenBuffer(jQLLexer);
        JQLParser jQLParser = new JQLParser(tokenBuffer);
        jQLParser.init(errorMsg);
        jQLParser.setASTFactory(JQLAST.Factory.getInstance());
        return jQLParser;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

