/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingFieldElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingReferenceKeyElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingTableElementImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MappingClassElementImpl
extends MappingElementImpl
implements MappingClassElement {
    public static final int CLONE_FIELDS = 1;
    public static final int CLONE_DEEP = 2;
    public static final int CLONE_MASK = 3;
    public static final int NAVIGABLE = 4;
    PersistenceClassElement _persistenceElement;
    private boolean _isModified;
    private int _properties;
    private ArrayList _tables;
    private ArrayList _fields;
    private static final int CURRENT_VERSION_NO = 4;
    private int versionNo = 4;
    private String _databaseRoot;
    private int _consistencyLevel = 0;

    public MappingClassElementImpl() {
        this((String)null);
    }

    public MappingClassElementImpl(String string) {
        super(string);
        this._properties |= 4;
    }

    public MappingClassElementImpl(PersistenceClassElement persistenceClassElement) {
        this(persistenceClassElement != null ? persistenceClassElement.getName() : null);
        this.setPersistenceElement(persistenceClassElement);
    }

    public int getVersionNumber() {
        return this.versionNo;
    }

    private void setVersionNumber(int n) {
        this.versionNo = n;
    }

    public boolean hasOldVersionNumber() {
        return this.getVersionNumber() < 4;
    }

    public static MappingClassElement forName(String string, Model model) {
        return model.getMappingClass(string);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        boolean bl = object != null && object2 != null && object.equals(object2);
        super.firePropertyChange(string, object, object2);
        if (!"modified".equals(string) && !bl) {
            this.setModified(true);
        }
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        boolean bl = object != null && object2 != null && object.equals(object2);
        super.fireVetoableChange(string, object, object2);
        if (!"modified".equals(string) && !bl) {
            this.fireVetoableChange("modified", Boolean.FALSE, Boolean.TRUE);
        }
    }

    public final PersistenceClassElement getPersistenceElement() {
        return this._persistenceElement;
    }

    public void setPersistenceElement(PersistenceClassElement persistenceClassElement) {
        this._persistenceElement = persistenceClassElement;
    }

    public boolean isModified() {
        return this._isModified;
    }

    public void setModified(boolean bl) {
        boolean bl2 = this.isModified();
        if (bl != bl2) {
            this._isModified = bl;
            this.firePropertyChange("modified", new Boolean(bl2), new Boolean(bl));
        }
    }

    public int getConsistencyLevel() {
        return this._consistencyLevel;
    }

    public void setConsistencyLevel(int n) throws ModelException {
        Integer n2 = new Integer(this.getConsistencyLevel());
        Integer n3 = new Integer(n);
        try {
            this.fireVetoableChange("consistencyLevel", n2, n3);
            this._consistencyLevel = n;
            this.firePropertyChange("consistencyLevel", n2, n3);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public String getDatabaseRoot() {
        return this._databaseRoot;
    }

    public void setDatabaseRoot(SchemaElement schemaElement) throws ModelException {
        String string = this.getDatabaseRoot();
        String string2 = schemaElement != null ? schemaElement.getName().getFullName() : null;
        try {
            this.fireVetoableChange("schema", string, string2);
            this._databaseRoot = string2;
            this.firePropertyChange("schema", string, string2);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public ArrayList getTables() {
        if (this._tables == null) {
            this._tables = new ArrayList();
        }
        return this._tables;
    }

    public MappingTableElement getTable(String string) {
        Iterator iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            MappingTableElement mappingTableElement = (MappingTableElement)iterator.next();
            if (!mappingTableElement.getName().equals(string)) continue;
            return mappingTableElement;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addTable(TableElement tableElement) throws ModelException {
        if (tableElement == null) throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.table.null_argument"));
        ArrayList arrayList = this.getTables();
        if (arrayList.isEmpty()) {
            this.setPrimaryTable(tableElement);
            return;
        } else {
            Object object;
            MappingTableElement mappingTableElement;
            HashMap<MappingTableElement, ForeignKeyElement> hashMap = new HashMap<MappingTableElement, ForeignKeyElement>();
            Iterator<Object> iterator = arrayList.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (!((MappingTableElement)iterator.next()).isEqual(tableElement)) continue;
                return;
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                mappingTableElement = (MappingTableElement)iterator.next();
                object = NameUtil.getAbsoluteTableName(this._databaseRoot, mappingTableElement.getTable());
                ForeignKeyElement[] foreignKeyElementArray = TableElement.forName((String)object).getForeignKeys();
                int n = foreignKeyElementArray != null ? foreignKeyElementArray.length : 0;
                int n2 = 0;
                while (n2 < n) {
                    ForeignKeyElement foreignKeyElement = foreignKeyElementArray[n2];
                    if (tableElement == foreignKeyElement.getReferencedTable()) {
                        hashMap.put(mappingTableElement, foreignKeyElement);
                        bl = true;
                    }
                    ++n2;
                }
            }
            if (!bl) throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.table.foreign_key_not_found", tableElement));
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                mappingTableElement = (MappingTableElement)iterator.next();
                object = this.addSecondaryTable(mappingTableElement, tableElement);
                object.addColumnPairs(((ForeignKeyElement)hashMap.get(mappingTableElement)).getColumnPairs());
            }
        }
    }

    public void setPrimaryTable(TableElement tableElement) throws ModelException {
        DBMemberElement[] dBMemberElementArray;
        ArrayList arrayList = this.getTables();
        if (!arrayList.isEmpty()) {
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.table.primary_table_defined", tableElement));
        }
        DBMemberElement dBMemberElement = tableElement.getPrimaryKey();
        MappingTableElementImpl mappingTableElementImpl = new MappingTableElementImpl(tableElement, (MappingClassElement)this);
        SchemaElement schemaElement = tableElement.getDeclaringSchema();
        String string = this.getDatabaseRoot();
        if (string == null) {
            this.setDatabaseRoot(schemaElement);
        } else if (!string.equals(schemaElement.getName().getFullName())) {
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.table.schema_mismatch", tableElement.toString(), string));
        }
        try {
            this.fireVetoableChange("tables", null, null);
            arrayList.add(mappingTableElementImpl);
            this.firePropertyChange("tables", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
        if (dBMemberElement == null && (dBMemberElementArray = tableElement.getUniqueKeys()) != null && dBMemberElementArray.length > 0) {
            dBMemberElement = dBMemberElementArray[0];
        }
        if (dBMemberElement != null) {
            dBMemberElementArray = dBMemberElement.getColumns();
            int n = dBMemberElementArray != null ? dBMemberElementArray.length : 0;
            int n2 = 0;
            while (n2 < n) {
                mappingTableElementImpl.addKeyColumn((ColumnElement)dBMemberElementArray[n2]);
                ++n2;
            }
        }
    }

    public MappingReferenceKeyElement addSecondaryTable(MappingTableElement mappingTableElement, TableElement tableElement) throws ModelException {
        ArrayList arrayList = this.getTables();
        if (mappingTableElement == null || tableElement == null) {
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.null_argument"));
        }
        if (!arrayList.contains(mappingTableElement)) {
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.table.parent_table_not_found", mappingTableElement.getTable()));
        }
        Iterator iterator = mappingTableElement.getReferencingKeys().iterator();
        MappingTableElementImpl mappingTableElementImpl = new MappingTableElementImpl(tableElement, (MappingClassElement)this);
        MappingReferenceKeyElementImpl mappingReferenceKeyElementImpl = new MappingReferenceKeyElementImpl(mappingTableElementImpl);
        while (iterator.hasNext()) {
            MappingTableElement mappingTableElement2 = ((MappingReferenceKeyElement)iterator.next()).getTable();
            if (!mappingTableElement2.isEqual(tableElement)) continue;
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.table.secondary_table_defined", new Object[]{tableElement, mappingTableElement.getTable()}));
        }
        try {
            this.fireVetoableChange("tables", null, null);
            mappingTableElement.addReferencingKey(mappingReferenceKeyElementImpl);
            arrayList.add(mappingTableElementImpl);
            this.firePropertyChange("tables", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
        return mappingReferenceKeyElementImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeTable(MappingTableElement mappingTableElement) throws ModelException {
        Object object;
        if (mappingTableElement == null) throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.null_argument"));
        ArrayList arrayList = this.getTables();
        Iterator iterator = null;
        boolean bl = false;
        try {
            this.fireVetoableChange("tables", null, null);
            bl = arrayList.remove(mappingTableElement);
            this.firePropertyChange("tables", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (MappingTableElement)iterator.next();
            object.removeReference(mappingTableElement);
        }
        if (!bl) throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.element_not_removed", mappingTableElement));
        object = new ArrayList();
        iterator = this.getFields().iterator();
        while (iterator.hasNext()) {
            MappingFieldElementImpl mappingFieldElementImpl = (MappingFieldElementImpl)iterator.next();
            if (!mappingFieldElementImpl.isMappedToTable(mappingTableElement)) continue;
            ((ArrayList)object).add(mappingFieldElementImpl);
        }
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            this.removeField((MappingFieldElement)iterator.next());
        }
    }

    public ArrayList getFields() {
        if (this._fields == null) {
            this._fields = new ArrayList();
        }
        return this._fields;
    }

    public MappingFieldElement getField(String string) {
        Iterator iterator = this.getFields().iterator();
        while (iterator.hasNext()) {
            MappingFieldElement mappingFieldElement = (MappingFieldElement)iterator.next();
            if (!string.equals(mappingFieldElement.getName())) continue;
            return mappingFieldElement;
        }
        return null;
    }

    public void addField(MappingFieldElement mappingFieldElement) throws ModelException {
        ArrayList arrayList = this.getFields();
        if (!arrayList.contains(mappingFieldElement)) {
            try {
                this.fireVetoableChange("fields", null, null);
                arrayList.add(mappingFieldElement);
                this.firePropertyChange("fields", null, null);
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new ModelVetoException(propertyVetoException);
            }
        }
    }

    public void removeField(MappingFieldElement mappingFieldElement) throws ModelException {
        try {
            this.fireVetoableChange("fields", null, null);
            if (!this.getFields().remove(mappingFieldElement)) {
                throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.element_not_removed", mappingFieldElement));
            }
            this.firePropertyChange("fields", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public boolean isNavigable() {
        return (this._properties & 4) > 0;
    }

    public void setNavigable(boolean bl) throws ModelException {
        Boolean bl2 = new Boolean(this.isNavigable());
        Boolean bl3 = new Boolean(bl);
        try {
            this.fireVetoableChange("navigable", bl2, bl3);
            this._properties = bl ? this._properties | 4 : this._properties & 0xFFFFFFFB;
            this.firePropertyChange("navigable", bl2, bl3);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    protected static ArrayList toColumnObjects(String string, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        ArrayList<DBMemberElement> arrayList2 = new ArrayList<DBMemberElement>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = NameUtil.getAbsoluteMemberName(string, string2);
            TableElement tableElement = TableElement.forName(NameUtil.getTableName(string3));
            arrayList2.add(tableElement.getMember(DBIdentifier.create(string3)));
        }
        return arrayList2;
    }

    public String getKeyClass() {
        return this.getPersistenceElement().getKeyClass();
    }

    public void setFields(ArrayList arrayList) {
        this._fields = arrayList;
    }

    public int getProperties() {
        return this._properties;
    }

    public void postUnarchive() throws ModelException {
        switch (this.versionNo) {
            case 0: 
            case 1: {
                throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "file.incompatible_version", this.getName()));
            }
            case 2: {
                this.stripSchemaName();
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "file.incompatible_version", this.getName()));
            }
        }
    }

    public void preArchive() {
        this.setVersionNumber(4);
    }

    protected void stripSchemaName() {
        Iterator iterator;
        String string = null;
        if (this._tables != null && !this._tables.isEmpty()) {
            string = NameUtil.getSchemaName(((MappingTableElement)this._tables.get(0)).getTable());
        }
        this._databaseRoot = string;
        if (this._tables != null) {
            iterator = this._tables.iterator();
            while (iterator.hasNext()) {
                ((MappingTableElementImpl)iterator.next()).stripSchemaName();
            }
        }
        if (this._fields != null) {
            iterator = this._fields.iterator();
            while (iterator.hasNext()) {
                ((MappingFieldElementImpl)iterator.next()).stripSchemaName();
            }
        }
    }
}

