/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassField;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassFile;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassMethod;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.GenericAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.SyntheticAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.impl.FieldAction;
import com.sun.jdo.api.persistence.enhancer.impl.MethodAction;
import com.sun.jdo.api.persistence.enhancer.impl.MethodBuilder;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.Assertion;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ClassAction
extends Support
implements VMConstants {
    private static final String AnnotatedAttribute = "com.sun.jdo.api.persistence.enhancer.annotated";
    private static final short AnnotatedVersion = 1;
    private static final String jdoGetStateManagerName = "jdoGetStateManager";
    private static final String jdoSetStateManagerName = "jdoSetStateManager";
    private static final String jdoGetFlagsName = "jdoGetFlags";
    private static final String jdoSetFlagsName = "jdoSetFlags";
    private static final String jdoMakeDirtyName = "jdoMakeDirty";
    private static final String jdoIsDirtyName = "jdoIsDirty";
    private static final String jdoIsTransactionalName = "jdoIsTransactional";
    private static final String jdoIsPersistentName = "jdoIsPersistent";
    private static final String jdoIsNewName = "jdoIsNew";
    private static final String jdoIsDeletedName = "jdoIsDeleted";
    private static final String jdoGetPersistenceManagerName = "jdoGetPersistenceManager";
    private static final String jdoGetObjectIdName = "jdoGetObjectId";
    private static final String jdoConstructorName = "<init>";
    private static final String jdoNewInstanceName = "jdoNewInstance";
    private static final String jdoClearName = "jdoClear";
    private static final String jdoCopyName = "jdoCopy";
    private static final String jdoGetFieldName = "jdoGetField";
    private static final String jdoSetFieldName = "jdoSetField";
    private static final String jdoCloneName = "clone";
    private final ClassControl control;
    private final Environment env;
    private final MethodBuilder methodBuilder;
    private final Map methodActionTable = new HashMap(11);
    private final List fieldActionTable = new ArrayList();
    private boolean previouslyAnnotated = false;
    private boolean implementsPersistence = false;
    private boolean sawImplementsPersistenceCapable = false;
    private boolean sawFieldJDOStateManager = false;
    private boolean sawFieldJDOFlags = false;
    private boolean sawMethodJDOGetStateManager = false;
    private boolean sawMethodJDOSetStateManager = false;
    private boolean sawMethodJDOGetFlags = false;
    private boolean sawMethodJDOSetFlags = false;
    private boolean sawMethodJDOMakeDirty = false;
    private boolean sawMethodJDOIsDirty = false;
    private boolean sawMethodJDOIsTransactional = false;
    private boolean sawMethodJDOIsPersistent = false;
    private boolean sawMethodJDOIsNew = false;
    private boolean sawMethodJDOIsDeleted = false;
    private boolean sawMethodJDOGetPersistenceManager = false;
    private boolean sawMethodJDOGetObjectId = false;
    private boolean sawMethodJDOConstructor = false;
    private boolean sawMethodJDONewInstance = false;
    private boolean sawMethodJDOGetField = false;
    private boolean sawMethodJDOSetField = false;
    private boolean sawMethodJDOClear = false;
    private boolean sawMethodJDOCopy = false;
    private boolean sawMethodJDOClone = false;

    public ClassAction(ClassControl classControl, Environment environment) {
        this.control = classControl;
        this.env = environment;
        this.methodBuilder = new MethodBuilder(environment);
    }

    public void scan1() {
        boolean bl;
        this.env.message("scanning class " + this.control.userClassName());
        Assertion.affirm(!this.classFile().isInterface());
        Assertion.affirm(this.control.persistType() > -1);
        this.scanAttributes();
        if (this.previouslyAnnotated) {
            return;
        }
        String string = this.className();
        this.implementsPersistence = this.env.getJDOMetaData().isPersistenceCapableRootClass(string);
        boolean bl2 = bl = this.control.persistType() == 2;
        if (bl) {
            this.scanForImplementsPC();
            this.scanFields();
        }
        this.scanMethods();
    }

    public void augment() {
        if (this.previouslyAnnotated) {
            return;
        }
        if (this.implementsPersistence) {
            this.env.message("augmenting class " + this.control.userClassName());
            if (!this.sawImplementsPersistenceCapable) {
                this.env.message("adding implements " + ClassControl.userClassFromVMClass(JDOMetaData.JDOPersistenceCapableType));
                this.augmentClassInterface("com/sun/jdo/spi/persistence/support/sqlstore/PersistenceCapable");
            }
            this.insertPersistenceCapableFields("jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;", JDOMetaData.JDOStateManagerFieldType, 129);
            this.insertPersistenceCapableFields("jdoFlags", "B", "byte", 129);
            this.insertPersistenceCapableMethods();
        }
    }

    public void annotate() {
        Object object;
        if (this.previouslyAnnotated) {
            return;
        }
        this.env.message("annotating class " + this.control.userClassName());
        boolean bl = false;
        Iterator iterator = this.methodActions();
        while (iterator.hasNext()) {
            object = (MethodAction)iterator.next();
            if (!((MethodAction)object).needsAnnotation()) continue;
            ((MethodAction)object).annotate();
            bl = true;
        }
        if (bl || this.env.updateInPlace()) {
            this.control.noteUpdate();
            object = new byte[2];
            object[0] = false;
            object[1] = true;
            GenericAttribute genericAttribute = new GenericAttribute(this.classFile().pool().addUtf8(AnnotatedAttribute), (byte[])object);
            this.classFile().attributes().addElement(genericAttribute);
        }
    }

    ClassControl classControl() {
        return this.control;
    }

    ClassFile classFile() {
        return this.control.classFile();
    }

    Iterator fieldActions() {
        return this.fieldActionTable.iterator();
    }

    Iterator methodActions() {
        return this.methodActionTable.values().iterator();
    }

    public String className() {
        return this.control.className();
    }

    public String userClassName() {
        return this.control.userClassName();
    }

    public boolean getImplementsPersistence() {
        return this.implementsPersistence;
    }

    public boolean hasCloneMethod() {
        return this.sawMethodJDOClone;
    }

    public boolean hasAnnotatedAttribute() {
        if (this.previouslyAnnotated) {
            return true;
        }
        Enumeration enumeration = this.classFile().attributes().elements();
        while (enumeration.hasMoreElements()) {
            ClassAttribute classAttribute = (ClassAttribute)enumeration.nextElement();
            if (!classAttribute.attrName().asString().equals(AnnotatedAttribute)) continue;
            return true;
        }
        return false;
    }

    private void scanAttributes() {
        Enumeration enumeration = this.classFile().attributes().elements();
        while (enumeration.hasMoreElements()) {
            ClassAttribute classAttribute = (ClassAttribute)enumeration.nextElement();
            if (!classAttribute.attrName().asString().equals(AnnotatedAttribute)) continue;
            this.previouslyAnnotated = true;
            this.env.message("ignoring previously enhanced class " + this.control.userClassName());
            break;
        }
    }

    private void scanForImplementsPC() {
        Iterator iterator = this.classFile().interfaces().iterator();
        while (iterator.hasNext()) {
            ConstClass constClass = (ConstClass)iterator.next();
            if (!constClass.asString().equals("com/sun/jdo/spi/persistence/support/sqlstore/PersistenceCapable")) continue;
            this.sawImplementsPersistenceCapable = true;
            this.env.warning(Support.getI18N("enhancer.class_implements_jdo_pc", new Object[]{this.userClassName(), JDOMetaData.JDOPersistenceCapableType}));
            return;
        }
    }

    private void scanFields() {
        Enumeration enumeration = this.classFile().fields().elements();
        while (enumeration.hasMoreElements()) {
            ClassField classField = (ClassField)enumeration.nextElement();
            String string = classField.name().asString();
            String string2 = classField.signature().asString();
            this.scanForJDOFields(string, string2);
            FieldAction fieldAction = new FieldAction(this, classField, this.env);
            fieldAction.check();
            this.fieldActionTable.add(fieldAction);
        }
    }

    private void scanForJDOFields(String string, String string2) {
        if (string.equals("jdoStateManager")) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_field", this.userClassName(), "jdoStateManager"));
            this.sawFieldJDOStateManager = true;
            return;
        }
        if (string.equals("jdoFlags")) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_field", this.userClassName(), "jdoFlags"));
            this.sawFieldJDOFlags = true;
            return;
        }
        if (string.startsWith("jdo")) {
            this.env.warning(Support.getI18N("enhancer.class_has_jdo_like_member", this.userClassName(), string));
            return;
        }
    }

    private void scanMethods() {
        boolean bl = this.control.persistType() == 2;
        Enumeration enumeration = this.classFile().methods().elements();
        while (enumeration.hasMoreElements()) {
            ClassMethod classMethod = (ClassMethod)enumeration.nextElement();
            String string = classMethod.name().asString();
            String string2 = classMethod.signature().asString();
            if (bl) {
                this.scanForJDOMethods(string, string2);
            }
            MethodAction methodAction = new MethodAction(this, classMethod, this.env);
            methodAction.check();
            this.methodActionTable.put(classMethod, methodAction);
        }
    }

    private void scanForJDOMethods(String string, String string2) {
        if (string.equals(jdoGetStateManagerName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOGetStateManager = true;
            return;
        }
        if (string.equals(jdoSetStateManagerName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOSetStateManager = true;
            return;
        }
        if (string.equals(jdoGetFlagsName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOGetFlags = true;
            return;
        }
        if (string.equals(jdoSetFlagsName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOSetFlags = true;
            return;
        }
        if (string.equals(jdoMakeDirtyName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOMakeDirty = true;
            return;
        }
        if (string.equals(jdoIsDirtyName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOIsDirty = true;
            return;
        }
        if (string.equals(jdoIsTransactionalName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOIsTransactional = true;
            return;
        }
        if (string.equals(jdoIsPersistentName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOIsPersistent = true;
            return;
        }
        if (string.equals(jdoIsNewName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOIsNew = true;
            return;
        }
        if (string.equals(jdoIsDeletedName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOIsDeleted = true;
            return;
        }
        if (string.equals(jdoGetPersistenceManagerName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOGetPersistenceManager = true;
            return;
        }
        if (string.equals(jdoGetObjectIdName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOGetObjectId = true;
            return;
        }
        if (string.equals(jdoConstructorName) && string2.equals("(Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;)V")) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOConstructor = true;
            return;
        }
        if (string.equals(jdoNewInstanceName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDONewInstance = true;
            return;
        }
        if (string.equals(jdoClearName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOClear = true;
            return;
        }
        if (string.equals(jdoCopyName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOCopy = true;
            return;
        }
        if (string.equals(jdoGetFieldName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOGetField = true;
            return;
        }
        if (string.equals(jdoSetFieldName)) {
            this.env.error(Support.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), string));
            this.sawMethodJDOSetField = true;
            return;
        }
        if (string.equals(jdoCloneName) && string2.equals("()Ljava/lang/Object;")) {
            this.sawMethodJDOClone = true;
            return;
        }
        if (string.startsWith("jdo")) {
            this.env.warning(Support.getI18N("enhancer.class_has_jdo_like_member", this.userClassName(), string));
            return;
        }
    }

    private void insertPersistenceCapableFields(String string, String string2, String string3, int n) {
        Assertion.affirm(this.implementsPersistence);
        this.control.noteUpdate();
        this.env.message("adding " + this.control.userClassName() + "." + string + " " + string3);
        ClassFile classFile = this.classFile();
        ConstantPool constantPool = classFile.pool();
        AttributeVector attributeVector = new AttributeVector();
        attributeVector.addElement(new SyntheticAttribute(constantPool.addUtf8("Synthetic")));
        ClassField classField = new ClassField(n, constantPool.addUtf8(string), constantPool.addUtf8(string2), attributeVector);
        classFile.addField(classField);
    }

    private void insertPersistenceCapableMethods() {
        Assertion.affirm(this.implementsPersistence);
        this.control.noteUpdate();
        Assertion.affirm(!this.sawMethodJDOGetStateManager);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetStateManager(this, jdoGetStateManagerName));
        Assertion.affirm(!this.sawMethodJDOSetStateManager);
        this.classFile().addMethod(this.methodBuilder.makeJDOSetStateManager(this, jdoSetStateManagerName));
        Assertion.affirm(!this.sawMethodJDOGetFlags);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetFlags(this, jdoGetFlagsName));
        Assertion.affirm(!this.sawMethodJDOSetFlags);
        this.classFile().addMethod(this.methodBuilder.makeJDOSetFlags(this, jdoSetFlagsName));
        Assertion.affirm(!this.sawMethodJDOMakeDirty);
        this.classFile().addMethod(this.methodBuilder.makeJDOMakeDirtyMethod(this, jdoMakeDirtyName));
        Assertion.affirm(!this.sawMethodJDOIsDirty);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsDirtyName));
        Assertion.affirm(!this.sawMethodJDOIsTransactional);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsTransactionalName));
        Assertion.affirm(!this.sawMethodJDOIsPersistent);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsPersistentName));
        Assertion.affirm(!this.sawMethodJDOIsNew);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsNewName));
        Assertion.affirm(!this.sawMethodJDOIsDeleted);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsDeletedName));
        Assertion.affirm(!this.sawMethodJDOGetPersistenceManager);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetPersistenceManagerMethod(this, jdoGetPersistenceManagerName));
        Assertion.affirm(!this.sawMethodJDOGetObjectId);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetObjectIdMethod(this, jdoGetObjectIdName));
        Assertion.affirm(!this.sawMethodJDOConstructor);
        this.classFile().addMethod(this.methodBuilder.makeJDOConstructor(this, jdoConstructorName));
        Assertion.affirm(!this.sawMethodJDONewInstance);
        this.classFile().addMethod(this.methodBuilder.makeJDONewInstanceMethod(this, jdoNewInstanceName));
        Assertion.affirm(!this.sawMethodJDOGetField);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetFieldMethod(this, jdoGetFieldName));
        Assertion.affirm(!this.sawMethodJDOSetField);
        this.classFile().addMethod(this.methodBuilder.makeJDOSetFieldMethod(this, jdoSetFieldName));
        Assertion.affirm(!this.sawMethodJDOClear);
        this.classFile().addMethod(this.methodBuilder.makeJDOClearMethod(this, jdoClearName));
        if (!this.sawMethodJDOClone) {
            this.classFile().addMethod(this.methodBuilder.makeJDOClone(this, jdoCloneName));
        }
    }

    private void augmentClassInterface(String string) {
        this.control.noteUpdate();
        ClassFile classFile = this.classFile();
        ConstClass constClass = classFile.pool().addClass(string);
        classFile.addInterface(constClass);
    }
}

