/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;

public class InsnUtils
implements VMConstants {
    public static Insn integerConstant(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(3);
        }
        if (n == 1) {
            return Insn.create(4);
        }
        if (n == 2) {
            return Insn.create(5);
        }
        if (n == 3) {
            return Insn.create(6);
        }
        if (n == 4) {
            return Insn.create(7);
        }
        if (n == 5) {
            return Insn.create(8);
        }
        if (n >= -128 && n < 128) {
            return Insn.create(16, n);
        }
        return Insn.create(18, constantPool.addInteger(n));
    }

    public static Insn longConstant(long l, ConstantPool constantPool) {
        if (l == 0L) {
            return Insn.create(9);
        }
        if (l == 1L) {
            return Insn.create(10);
        }
        return Insn.create(20, constantPool.addLong(l));
    }

    public static Insn floatConstant(float f, ConstantPool constantPool) {
        if (f == 0.0f) {
            return Insn.create(11);
        }
        if (f == 1.0f) {
            return Insn.create(12);
        }
        if (f == 2.0f) {
            return Insn.create(13);
        }
        return Insn.create(18, constantPool.addFloat(f));
    }

    public static Insn doubleConstant(double d, ConstantPool constantPool) {
        if (d == 0.0) {
            return Insn.create(14);
        }
        if (d == 1.0) {
            return Insn.create(15);
        }
        return Insn.create(20, constantPool.addDouble(d));
    }

    public static Insn aStore(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(75);
        }
        if (n == 1) {
            return Insn.create(76);
        }
        if (n == 2) {
            return Insn.create(77);
        }
        if (n == 3) {
            return Insn.create(78);
        }
        return Insn.create(58, n);
    }

    public static Insn iStore(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(59);
        }
        if (n == 1) {
            return Insn.create(60);
        }
        if (n == 2) {
            return Insn.create(61);
        }
        if (n == 3) {
            return Insn.create(62);
        }
        return Insn.create(54, n);
    }

    public static Insn fStore(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(67);
        }
        if (n == 1) {
            return Insn.create(68);
        }
        if (n == 2) {
            return Insn.create(69);
        }
        if (n == 3) {
            return Insn.create(70);
        }
        return Insn.create(56, n);
    }

    public static Insn lStore(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(63);
        }
        if (n == 1) {
            return Insn.create(64);
        }
        if (n == 2) {
            return Insn.create(65);
        }
        if (n == 3) {
            return Insn.create(66);
        }
        return Insn.create(55, n);
    }

    public static Insn dStore(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(71);
        }
        if (n == 1) {
            return Insn.create(72);
        }
        if (n == 2) {
            return Insn.create(73);
        }
        if (n == 3) {
            return Insn.create(74);
        }
        return Insn.create(57, n);
    }

    public static Insn aLoad(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(42);
        }
        if (n == 1) {
            return Insn.create(43);
        }
        if (n == 2) {
            return Insn.create(44);
        }
        if (n == 3) {
            return Insn.create(45);
        }
        return Insn.create(25, n);
    }

    public static Insn iLoad(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(26);
        }
        if (n == 1) {
            return Insn.create(27);
        }
        if (n == 2) {
            return Insn.create(28);
        }
        if (n == 3) {
            return Insn.create(29);
        }
        return Insn.create(21, n);
    }

    public static Insn fLoad(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(34);
        }
        if (n == 1) {
            return Insn.create(35);
        }
        if (n == 2) {
            return Insn.create(36);
        }
        if (n == 3) {
            return Insn.create(37);
        }
        return Insn.create(23, n);
    }

    public static Insn lLoad(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(30);
        }
        if (n == 1) {
            return Insn.create(31);
        }
        if (n == 2) {
            return Insn.create(32);
        }
        if (n == 3) {
            return Insn.create(33);
        }
        return Insn.create(22, n);
    }

    public static Insn dLoad(int n, ConstantPool constantPool) {
        if (n == 0) {
            return Insn.create(38);
        }
        if (n == 1) {
            return Insn.create(39);
        }
        if (n == 2) {
            return Insn.create(40);
        }
        if (n == 3) {
            return Insn.create(41);
        }
        return Insn.create(24, n);
    }

    public static Insn load(int n, int n2, ConstantPool constantPool) {
        switch (n) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InsnUtils.iLoad(n2, constantPool);
            }
            case 6: {
                return InsnUtils.fLoad(n2, constantPool);
            }
            case 7: {
                return InsnUtils.dLoad(n2, constantPool);
            }
            case 11: {
                return InsnUtils.lLoad(n2, constantPool);
            }
            case 12: {
                return InsnUtils.aLoad(n2, constantPool);
            }
        }
        throw new InsnError("bad load type");
    }

    public static Insn store(int n, int n2, ConstantPool constantPool) {
        switch (n) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InsnUtils.iStore(n2, constantPool);
            }
            case 6: {
                return InsnUtils.fStore(n2, constantPool);
            }
            case 7: {
                return InsnUtils.dStore(n2, constantPool);
            }
            case 11: {
                return InsnUtils.lStore(n2, constantPool);
            }
            case 12: {
                return InsnUtils.aStore(n2, constantPool);
            }
        }
        throw new InsnError("bad store type");
    }
}

