/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import com.sun.jdo.api.persistence.enhancer.classfile.VMOp;
import java.io.PrintStream;

public class InsnTargetOp
extends Insn {
    InsnTarget targetOp;

    public int nStackArgs() {
        return VMOp.ops[this.opcode()].nStackArgs();
    }

    public int nStackResults() {
        return VMOp.ops[this.opcode()].nStackResults();
    }

    public String argTypes() {
        return VMOp.ops[this.opcode()].argTypes();
    }

    public String resultTypes() {
        return VMOp.ops[this.opcode()].resultTypes();
    }

    public boolean branches() {
        return true;
    }

    public void markTargets() {
        this.targetOp.setBranchTarget();
    }

    public InsnTarget target() {
        return this.targetOp;
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println(this.offset() + "  " + Insn.opName(this.opcode()) + "  " + this.targetOp.offset());
    }

    int store(byte[] byArray, int n) {
        byArray[n++] = (byte)this.opcode();
        int n2 = this.targetOp.offset() - this.offset();
        if (this.opcode() == 200 || this.opcode() == 201) {
            return Insn.storeInt(byArray, n, n2);
        }
        return Insn.storeShort(byArray, n, (short)n2);
    }

    int size() {
        if (this.opcode() == 200 || this.opcode() == 201) {
            return 5;
        }
        return 3;
    }

    InsnTargetOp(int n, InsnTarget insnTarget, int n2) {
        super(n, n2);
        this.targetOp = insnTarget;
    }

    InsnTargetOp(int n, InsnTarget insnTarget) {
        super(n, -1);
        this.targetOp = insnTarget;
        switch (n) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 200: 
            case 201: {
                if (insnTarget != null) break;
                throw new InsnError("attempt to create an " + Insn.opName(n) + " with a null Target operand");
            }
            default: {
                throw new InsnError("attempt to create an " + Insn.opName(n) + " with an InsnTarget operand");
            }
        }
    }
}

