/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;

class InsnReadEnv {
    private CodeEnv codeEnv;
    private byte[] byteCodes;
    private int currPc;

    InsnReadEnv(byte[] byArray, CodeEnv codeEnv) {
        this.byteCodes = byArray;
        this.currPc = 0;
        this.codeEnv = codeEnv;
    }

    int currentPC() {
        return this.currPc;
    }

    boolean more() {
        return this.currPc < this.byteCodes.length;
    }

    byte getByte() {
        if (!this.more()) {
            throw new InsnError("out of byte codes");
        }
        return this.byteCodes[this.currPc++];
    }

    int getUByte() {
        return this.getByte() & 0xFF;
    }

    int getShort() {
        byte by = this.byteCodes[this.currPc++];
        byte by2 = this.byteCodes[this.currPc++];
        return by << 8 | by2 & 0xFF;
    }

    int getUShort() {
        return this.getShort() & 0xFFFF;
    }

    int getInt() {
        byte by = this.byteCodes[this.currPc++];
        byte by2 = this.byteCodes[this.currPc++];
        byte by3 = this.byteCodes[this.currPc++];
        byte by4 = this.byteCodes[this.currPc++];
        return by << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | by4 & 0xFF;
    }

    ConstantPool pool() {
        return this.codeEnv.pool();
    }

    InsnTarget getTarget(int n) {
        return this.codeEnv.getTarget(n);
    }
}

