/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasic;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnConstOp;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnIInc;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnIntOp;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnInterfaceInvoke;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnLookupSwitch;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnMultiDimArrayNew;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnReadEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnSingle;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTableSwitch;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTargetOp;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import com.sun.jdo.api.persistence.enhancer.classfile.VMOp;
import java.io.PrintStream;

public abstract class Insn
implements VMConstants {
    static final int NO_OFFSET = -1;
    public static final int opc_target = -1;
    private int insnOpcode;
    private int insnOffset = -1;
    private Insn nextInsn = null;
    private Insn prevInsn = null;

    public Insn next() {
        return this.nextInsn;
    }

    public Insn prev() {
        return this.prevInsn;
    }

    public void remove() {
        if (this.nextInsn != null) {
            this.nextInsn.prevInsn = this.prevInsn;
        }
        if (this.prevInsn != null) {
            this.prevInsn.nextInsn = this.nextInsn;
        }
        this.prevInsn = null;
        this.nextInsn = null;
    }

    public Insn setNext(Insn insn) {
        if (this.nextInsn != null) {
            this.nextInsn.prevInsn = insn;
        }
        if (insn != null) {
            insn.nextInsn = this.nextInsn;
            insn.prevInsn = this;
        }
        this.nextInsn = insn;
        return insn;
    }

    public Insn insert(Insn insn) {
        if (insn == null) {
            return this;
        }
        Insn insn2 = this.nextInsn;
        this.nextInsn = insn;
        insn.prevInsn = this;
        while (insn.nextInsn != null) {
            insn = insn.nextInsn;
        }
        insn.nextInsn = insn2;
        if (insn2 != null) {
            insn2.prevInsn = insn;
        }
        return insn;
    }

    public Insn append(Insn insn) {
        Insn insn2 = this;
        while (insn2.nextInsn != null) {
            insn2 = insn2.nextInsn;
        }
        return insn2.insert(insn);
    }

    public int opcode() {
        return this.insnOpcode;
    }

    public int offset() {
        return this.insnOffset;
    }

    public abstract int nStackArgs();

    public abstract int nStackResults();

    public abstract String argTypes();

    public abstract String resultTypes();

    public abstract boolean branches();

    public void markTargets() {
    }

    public static String opName(int n) {
        if (n == -1) {
            return "target:";
        }
        if (n >= 0 && n <= VMOp.ops.length) {
            return VMOp.ops[n].name();
        }
        throw new InsnError("invalid opcode for opName: " + n);
    }

    public static Insn create(int n) {
        return new InsnSingle(n);
    }

    public static Insn create(int n, ConstBasic constBasic) {
        return new InsnConstOp(n, constBasic);
    }

    public static Insn create(int n, int n2) {
        return new InsnIntOp(n, n2);
    }

    public static Insn create(int n, InsnTarget insnTarget) {
        return new InsnTargetOp(n, insnTarget);
    }

    public void printList(PrintStream printStream) {
        Insn insn = this;
        while (insn != null) {
            insn.print(printStream, 0);
            insn = insn.next();
        }
    }

    public void printInsn(PrintStream printStream) {
        this.print(printStream, 0);
    }

    abstract void print(PrintStream var1, int var2);

    abstract int store(byte[] var1, int var2);

    abstract int size();

    final int resolveOffset(int n) {
        this.insnOffset = n;
        return n + this.size();
    }

    Insn(int n, int n2) {
        this.insnOpcode = n;
        this.insnOffset = n2;
    }

    static int storeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        return n;
    }

    static int storeShort(byte[] byArray, int n, short s) {
        byArray[n++] = (byte)(s >> 8 & 0xFF);
        byArray[n++] = (byte)(s & 0xFF);
        return n;
    }

    static Insn read(InsnReadEnv insnReadEnv) {
        boolean bl = false;
        int n = insnReadEnv.currentPC();
        int n2 = insnReadEnv.getUByte();
        if (n2 == 196) {
            bl = true;
            n2 = insnReadEnv.getUByte();
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 186: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return new InsnSingle(n2, n);
            }
            case 18: {
                return new InsnConstOp(n2, insnReadEnv.pool().constantAt(insnReadEnv.getUByte()), n);
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                return new InsnConstOp(n2, insnReadEnv.pool().constantAt(insnReadEnv.getUShort()), n);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                if (bl) {
                    return new InsnIntOp(n2, insnReadEnv.getShort(), n);
                }
                return new InsnIntOp(n2, insnReadEnv.getByte(), n);
            }
            case 16: 
            case 188: {
                return new InsnIntOp(n2, insnReadEnv.getByte(), n);
            }
            case 17: {
                return new InsnIntOp(n2, insnReadEnv.getShort(), n);
            }
            case 132: {
                if (bl) {
                    return new InsnIInc(insnReadEnv.getUShort(), insnReadEnv.getShort(), n);
                }
                return new InsnIInc(insnReadEnv.getUByte(), insnReadEnv.getByte(), n);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                return new InsnTargetOp(n2, insnReadEnv.getTarget(insnReadEnv.getShort() + n), n);
            }
            case 200: 
            case 201: {
                return new InsnTargetOp(n2, insnReadEnv.getTarget(insnReadEnv.getInt() + n), n);
            }
            case 170: {
                return InsnTableSwitch.read(insnReadEnv, n);
            }
            case 171: {
                return InsnLookupSwitch.read(insnReadEnv, n);
            }
            case 185: {
                return InsnInterfaceInvoke.read(insnReadEnv, n);
            }
            case 197: {
                return InsnMultiDimArrayNew.read(insnReadEnv, n);
            }
        }
        throw new InsnError("Invalid byte code (" + n2 + ")");
    }

    public static final int loadStoreDataType(int n) {
        switch (n) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 79: 
            case 84: 
            case 85: 
            case 86: {
                return 10;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 47: 
            case 55: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 80: {
                return 11;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 48: 
            case 56: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 81: {
                return 6;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 49: 
            case 57: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 82: {
                return 7;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 50: 
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 83: {
                return 12;
            }
        }
        throw new InsnError("not a load/store");
    }
}

