/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasic;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasicMemberRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstDouble;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFieldRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFloat;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstInteger;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstInterfaceMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstLong;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstNameAndType;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstString;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUnicode;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public class ConstantPool
implements VMConstants {
    private Vector pool = new Vector();
    private boolean hashed = false;
    private Hashtable utfTable = new Hashtable(11);
    private Hashtable unicodeTable = new Hashtable(3);
    private Hashtable stringTable = new Hashtable(11);
    private Hashtable classTable = new Hashtable(11);
    private Hashtable intTable = new Hashtable(3);
    private Hashtable floatTable = new Hashtable(3);
    private Hashtable longTable = new Hashtable(3);
    private Hashtable doubleTable = new Hashtable(3);
    private Vector methodRefTable = new Vector();
    private Vector fieldRefTable = new Vector();
    private Vector ifaceMethodRefTable = new Vector();
    private Vector nameAndTypeTable = new Vector();

    public int nEntries() {
        return this.pool.size();
    }

    public ConstBasic constantAt(int n) {
        return (ConstBasic)this.pool.elementAt(n);
    }

    public ConstClass addClass(String string) {
        this.hashConstants();
        ConstClass constClass = (ConstClass)this.classTable.get(string);
        if (constClass == null) {
            constClass = new ConstClass(this.addUtf8(string));
            this.internConstant(constClass);
        }
        return constClass;
    }

    public ConstFieldRef addFieldRef(String string, String string2, String string3) {
        this.hashConstants();
        ConstFieldRef constFieldRef = (ConstFieldRef)this.searchTable(this.fieldRefTable, string, string2, string3);
        if (constFieldRef == null) {
            constFieldRef = new ConstFieldRef(this.addClass(string), this.addNameAndType(string2, string3));
            this.internConstant(constFieldRef);
        }
        return constFieldRef;
    }

    public ConstMethodRef addMethodRef(String string, String string2, String string3) {
        this.hashConstants();
        ConstMethodRef constMethodRef = (ConstMethodRef)this.searchTable(this.methodRefTable, string, string2, string3);
        if (constMethodRef == null) {
            constMethodRef = new ConstMethodRef(this.addClass(string), this.addNameAndType(string2, string3));
            this.internConstant(constMethodRef);
        }
        return constMethodRef;
    }

    public ConstInterfaceMethodRef addInterfaceMethodRef(String string, String string2, String string3) {
        this.hashConstants();
        ConstInterfaceMethodRef constInterfaceMethodRef = (ConstInterfaceMethodRef)this.searchTable(this.ifaceMethodRefTable, string, string2, string3);
        if (constInterfaceMethodRef == null) {
            constInterfaceMethodRef = new ConstInterfaceMethodRef(this.addClass(string), this.addNameAndType(string2, string3));
            this.internConstant(constInterfaceMethodRef);
        }
        return constInterfaceMethodRef;
    }

    public ConstString addString(String string) {
        this.hashConstants();
        ConstString constString = (ConstString)this.stringTable.get(string);
        if (constString == null) {
            constString = new ConstString(this.addUtf8(string));
            this.internConstant(constString);
        }
        return constString;
    }

    public ConstInteger addInteger(int n) {
        this.hashConstants();
        Integer n2 = new Integer(n);
        ConstInteger constInteger = (ConstInteger)this.intTable.get(n2);
        if (constInteger == null) {
            constInteger = new ConstInteger(n);
            this.internConstant(constInteger);
        }
        return constInteger;
    }

    public ConstFloat addFloat(float f) {
        this.hashConstants();
        Float f2 = new Float(f);
        ConstFloat constFloat = (ConstFloat)this.floatTable.get(f2);
        if (constFloat == null) {
            constFloat = new ConstFloat(f);
            this.internConstant(constFloat);
        }
        return constFloat;
    }

    public ConstLong addLong(long l) {
        this.hashConstants();
        Long l2 = new Long(l);
        ConstLong constLong = (ConstLong)this.longTable.get(l2);
        if (constLong == null) {
            constLong = new ConstLong(l);
            this.internConstant(constLong);
            this.internConstant(null);
        }
        return constLong;
    }

    public ConstDouble addDouble(double d) {
        this.hashConstants();
        Double d2 = new Double(d);
        ConstDouble constDouble = (ConstDouble)this.doubleTable.get(d2);
        if (constDouble == null) {
            constDouble = new ConstDouble(d);
            this.internConstant(constDouble);
            this.internConstant(null);
        }
        return constDouble;
    }

    public ConstNameAndType addNameAndType(String string, String string2) {
        ConstNameAndType constNameAndType;
        this.hashConstants();
        int n = 0;
        while (n < this.nameAndTypeTable.size()) {
            constNameAndType = (ConstNameAndType)this.nameAndTypeTable.elementAt(n);
            if (constNameAndType.name().asString().equals(string) && constNameAndType.signature().asString().equals(string2)) {
                return constNameAndType;
            }
            ++n;
        }
        constNameAndType = new ConstNameAndType(this.addUtf8(string), this.addUtf8(string2));
        this.internConstant(constNameAndType);
        return constNameAndType;
    }

    public ConstUtf8 addUtf8(String string) {
        this.hashConstants();
        ConstUtf8 constUtf8 = (ConstUtf8)this.utfTable.get(string);
        if (constUtf8 == null) {
            constUtf8 = new ConstUtf8(string);
            this.internConstant(constUtf8);
        }
        return constUtf8;
    }

    public ConstUnicode addUnicode(String string) {
        this.hashConstants();
        ConstUnicode constUnicode = (ConstUnicode)this.unicodeTable.get(string);
        if (constUnicode == null) {
            constUnicode = new ConstUnicode(string);
            this.internConstant(constUnicode);
        }
        return constUnicode;
    }

    ConstantPool() {
        this.pool.addElement(null);
    }

    ConstantPool(DataInputStream dataInputStream) throws IOException {
        this.pool.addElement(null);
        int n = dataInputStream.readUnsignedShort() - 1;
        while (n > 0) {
            n -= this.readConstant(dataInputStream);
        }
        this.resolvePool();
    }

    void print(PrintStream printStream) {
        int n = 0;
        while (n < this.pool.size()) {
            ConstBasic constBasic = this.constantAt(n);
            if (constBasic != null) {
                printStream.print(n);
                printStream.print(": ");
                printStream.println(constBasic.toString());
            }
            ++n;
        }
    }

    void summarize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.pool.size()) {
            ConstBasic constBasic = this.constantAt(n3);
            if (constBasic != null && constBasic.tag() == 1) {
                ConstUtf8 constUtf8 = (ConstUtf8)constBasic;
                n += constUtf8.asString().length();
                ++n2;
            }
            ++n3;
        }
        System.out.println("  " + n2 + " strings totalling " + n + " bytes");
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.pool.size());
        int n = 1;
        while (n < this.pool.size()) {
            ConstBasic constBasic = (ConstBasic)this.pool.elementAt(n);
            if (constBasic != null) {
                dataOutputStream.writeByte((byte)constBasic.tag());
                constBasic.formatData(dataOutputStream);
            }
            ++n;
        }
    }

    private void resolvePool() {
        int n = 0;
        while (n < this.pool.size()) {
            ConstBasic constBasic = this.constantAt(n);
            if (constBasic != null) {
                constBasic.setIndex(n);
                constBasic.resolve(this);
            }
            ++n;
        }
    }

    private void hashConstants() {
        if (this.hashed) {
            return;
        }
        int n = 0;
        while (n < this.pool.size()) {
            ConstBasic constBasic = this.constantAt(n);
            if (constBasic != null) {
                this.recordConstant(constBasic);
            }
            ++n;
        }
        this.hashed = true;
    }

    private int readConstant(DataInputStream dataInputStream) throws IOException {
        ConstBasic constBasic;
        byte by = dataInputStream.readByte();
        int n = 1;
        switch (by) {
            case 1: {
                constBasic = ConstUtf8.read(dataInputStream);
                break;
            }
            case 2: {
                constBasic = ConstUnicode.read(dataInputStream);
                break;
            }
            case 3: {
                constBasic = ConstInteger.read(dataInputStream);
                break;
            }
            case 4: {
                constBasic = ConstFloat.read(dataInputStream);
                break;
            }
            case 5: {
                constBasic = ConstLong.read(dataInputStream);
                n = 2;
                break;
            }
            case 6: {
                constBasic = ConstDouble.read(dataInputStream);
                n = 2;
                break;
            }
            case 7: {
                constBasic = ConstClass.read(dataInputStream);
                break;
            }
            case 8: {
                constBasic = ConstString.read(dataInputStream);
                break;
            }
            case 9: {
                constBasic = ConstFieldRef.read(dataInputStream);
                break;
            }
            case 10: {
                constBasic = ConstMethodRef.read(dataInputStream);
                break;
            }
            case 11: {
                constBasic = ConstInterfaceMethodRef.read(dataInputStream);
                break;
            }
            case 12: {
                constBasic = ConstNameAndType.read(dataInputStream);
                break;
            }
            default: {
                throw new ClassFormatError("Don't know this constant type: " + Integer.toString(by));
            }
        }
        this.pool.addElement(constBasic);
        if (n > 1) {
            this.pool.addElement(null);
        }
        return n;
    }

    private void internConstant(ConstBasic constBasic) {
        if (constBasic != null) {
            constBasic.setIndex(this.pool.size());
            this.recordConstant(constBasic);
        }
        this.pool.addElement(constBasic);
    }

    private void recordConstant(ConstBasic constBasic) {
        if (constBasic != null) {
            switch (constBasic.tag()) {
                case 1: {
                    this.utfTable.put(((ConstUtf8)constBasic).asString(), constBasic);
                    break;
                }
                case 2: {
                    this.unicodeTable.put(((ConstUnicode)constBasic).asString(), constBasic);
                    break;
                }
                case 3: {
                    this.intTable.put(new Integer(((ConstInteger)constBasic).value()), constBasic);
                    break;
                }
                case 4: {
                    this.floatTable.put(new Float(((ConstFloat)constBasic).value()), constBasic);
                    break;
                }
                case 5: {
                    this.longTable.put(new Long(((ConstLong)constBasic).value()), constBasic);
                    break;
                }
                case 6: {
                    this.doubleTable.put(new Double(((ConstDouble)constBasic).value()), constBasic);
                    break;
                }
                case 7: {
                    this.classTable.put(((ConstClass)constBasic).asString(), constBasic);
                    break;
                }
                case 8: {
                    this.stringTable.put(((ConstString)constBasic).value().asString(), constBasic);
                    break;
                }
                case 9: {
                    this.fieldRefTable.addElement(constBasic);
                    break;
                }
                case 10: {
                    this.methodRefTable.addElement(constBasic);
                    break;
                }
                case 11: {
                    this.ifaceMethodRefTable.addElement(constBasic);
                    break;
                }
                case 12: {
                    this.nameAndTypeTable.addElement(constBasic);
                }
            }
        }
    }

    private ConstBasicMemberRef searchTable(Vector vector, String string, String string2, String string3) {
        int n = 0;
        while (n < vector.size()) {
            ConstBasicMemberRef constBasicMemberRef = (ConstBasicMemberRef)vector.elementAt(n);
            if (constBasicMemberRef.className().asString().equals(string) && constBasicMemberRef.nameAndType().name().asString().equals(string2) && constBasicMemberRef.nameAndType().signature().asString().equals(string3)) {
                return constBasicMemberRef;
            }
            ++n;
        }
        return null;
    }
}

