/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class AnnotatedMethodAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "filter.annotatedMethod";
    public static final short expectedAttrVersion = 1;
    public static final short generatedFlag = 1;
    public static final short annotatedFlag = 2;
    public static final short modifiedFlag = 4;
    private short attrVersion;
    private short annotationFlags;
    private InsnTarget[] annotationRanges;

    public short getVersion() {
        return this.attrVersion;
    }

    public void setVersion(short s) {
        this.attrVersion = s;
    }

    public short getFlags() {
        return this.annotationFlags;
    }

    public void setFlags(short s) {
        this.annotationFlags = s;
    }

    public InsnTarget[] getAnnotationRanges() {
        return this.annotationRanges;
    }

    public void setAnnotationRanges(InsnTarget[] insnTargetArray) {
        this.annotationRanges = insnTargetArray;
    }

    public AnnotatedMethodAttribute(ConstUtf8 constUtf8, short s, short s2, InsnTarget[] insnTargetArray) {
        super(constUtf8);
        this.attrVersion = s;
        this.annotationFlags = s2;
        this.annotationRanges = insnTargetArray;
    }

    static AnnotatedMethodAttribute read(ConstUtf8 constUtf8, DataInputStream dataInputStream, CodeEnv codeEnv) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        int n = dataInputStream.readShort();
        InsnTarget[] insnTargetArray = new InsnTarget[n * 2];
        int n2 = 0;
        while (n2 < n) {
            insnTargetArray[n2 * 2] = codeEnv.getTarget(dataInputStream.readShort());
            insnTargetArray[n2 * 2 + 1] = codeEnv.getTarget(dataInputStream.readShort());
            ++n2;
        }
        return new AnnotatedMethodAttribute(constUtf8, s, s2, insnTargetArray);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attrName().getIndex());
        if (this.annotationRanges == null) {
            dataOutputStream.writeShort(2);
        } else {
            dataOutputStream.writeShort(4 + 2 * this.annotationRanges.length);
        }
        dataOutputStream.writeShort(this.attrVersion);
        dataOutputStream.writeShort(this.annotationFlags);
        if (this.annotationRanges == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(this.annotationRanges.length / 2);
            int n = 0;
            while (n < this.annotationRanges.length) {
                dataOutputStream.writeShort(this.annotationRanges[n].offset());
                ++n;
            }
        }
    }

    void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.println("version: " + this.attrVersion);
        printStream.println(" flags: " + this.annotationFlags);
        if (this.annotationRanges != null) {
            printStream.println("Annotations: ");
            int n2 = 0;
            while (n2 < this.annotationRanges.length / 2) {
                ClassPrint.spaces(printStream, n + 2);
                printStream.println(this.annotationRanges[n2 * 2] + " to " + this.annotationRanges[n2 * 2 + 1]);
                ++n2;
            }
        }
    }
}

