/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.jdbcimpl;

import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.DBElementProperties;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.DBMemberElement;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.IndexElement;
import com.sun.forte4j.modules.dbmodel.KeyElement;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.UniqueKeyElement;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.ConnectionProvider;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.DBElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.DBElementsCollection;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.DDLBridge;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.IndexElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.MetaDataUtil;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.TableElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.UniqueKeyElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.ViewDependency;
import com.sun.forte4j.modules.dbmodel.util.IDEUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class SchemaElementImpl
extends DBElementImpl
implements SchemaElement.Impl {
    private DBElementsCollection tables;
    private DBIdentifier _schema;
    private DBIdentifier _catalog;
    private String _url;
    private String _username;
    private String _driver;
    private String _databaseProductName;
    private String _databaseProductVersion;
    private String _driverName;
    private String _driverVersion;
    private transient DatabaseMetaData dmd;
    private transient String catalog;
    private transient boolean stop;
    public transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private transient int progress;

    public SchemaElementImpl() {
        this((ConnectionProvider)null);
    }

    public SchemaElementImpl(ConnectionProvider connectionProvider) {
        this.tables = new DBElementsCollection(this, new TableElement[0]);
        String string = String.valueOf(this.tables.hashCode());
        while (DBElementsCollection.instances.contains(string)) {
            this.tables = new DBElementsCollection(this, new TableElement[0]);
            string = String.valueOf(this.tables.hashCode());
        }
        DBElementsCollection.instances.add(string);
        if (connectionProvider != null) {
            try {
                this.dmd = connectionProvider.getDatabaseMetaData();
                this._url = this.dmd.getURL();
                this._username = this.dmd.getUserName();
                String string2 = connectionProvider.getSchema();
                this._schema = string2 == null ? DBIdentifier.create("") : DBIdentifier.create(string2);
                this.catalog = connectionProvider.getConnection().getCatalog();
                this._catalog = this.catalog == null ? DBIdentifier.create("") : DBIdentifier.create(this.catalog);
                this._driver = connectionProvider.getDriver();
                this._databaseProductName = this.dmd.getDatabaseProductName().trim();
                this._databaseProductVersion = this.dmd.getDatabaseProductVersion();
                this._driverName = this.dmd.getDriverName();
                this._driverVersion = this.dmd.getDriverVersion();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.stop = false;
    }

    public void setName(DBIdentifier dBIdentifier) throws DBException {
        int n;
        String string = dBIdentifier.getFullName();
        if (string == null) {
            string = dBIdentifier.getName();
            dBIdentifier.setFullName(string);
        }
        if ((n = string.lastIndexOf("/")) != -1) {
            dBIdentifier.setName(string.substring(n + 1));
        } else if (string.indexOf(".") != -1) {
            dBIdentifier.setName(string);
        }
        this._name = dBIdentifier;
    }

    public DBIdentifier getName() {
        return this._name;
    }

    public int getStatus() {
        return 3;
    }

    public void setSchema(DBIdentifier dBIdentifier) throws DBException {
        this._schema = dBIdentifier;
    }

    public DBIdentifier getSchema() {
        return this._schema;
    }

    public void setCatalog(DBIdentifier dBIdentifier) throws DBException {
        this._catalog = dBIdentifier;
    }

    public DBIdentifier getCatalog() {
        return this._catalog;
    }

    public void changeTables(TableElement[] tableElementArray, int n) throws DBException {
        this.tables.changeElements(tableElementArray, n);
    }

    public TableElement[] getTables() {
        DBElement[] dBElementArray = this.tables.getElements();
        return Arrays.asList(dBElementArray).toArray(new TableElement[dBElementArray.length]);
    }

    public TableElement getTable(DBIdentifier dBIdentifier) {
        return (TableElement)this.tables.find(dBIdentifier);
    }

    public void initTables(ConnectionProvider connectionProvider) {
        this.initTables(connectionProvider, null, null, false);
    }

    public void initTables(ConnectionProvider connectionProvider, LinkedList linkedList, LinkedList linkedList2) {
        this.initTables(connectionProvider, linkedList, linkedList2, false);
    }

    public void initTables(ConnectionProvider connectionProvider, LinkedList linkedList, LinkedList linkedList2, boolean bl) {
        block20: {
            if (connectionProvider != null) {
                try {
                    this.progress = 0;
                    LinkedList linkedList3 = new LinkedList();
                    LinkedList linkedList4 = new LinkedList();
                    String string = connectionProvider.getSchema();
                    DDLBridge dDLBridge = null;
                    if (IDEUtil.isIDERunning()) {
                        dDLBridge = new DDLBridge(connectionProvider.getConnection(), connectionProvider.getSchema(), this.dmd);
                    }
                    if (linkedList == null && linkedList2 == null) {
                        ResultSet resultSet;
                        if (dDLBridge != null) {
                            dDLBridge.getDriverSpecification().getTables("%", new String[]{"TABLE"});
                            resultSet = dDLBridge.getDriverSpecification().getResultSet();
                        } else {
                            resultSet = this.dmd.getTables(this.catalog, string, "%", new String[]{"TABLE"});
                        }
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                if (this.isStop()) {
                                    resultSet.close();
                                    return;
                                }
                                if (dDLBridge != null) {
                                    linkedList3.add((String)dDLBridge.getDriverSpecification().getRow().get(new Integer(3)));
                                    continue;
                                }
                                linkedList3.add(resultSet.getString("TABLE_NAME").trim());
                            }
                            resultSet.close();
                        }
                        resultSet = null;
                        if (dDLBridge != null) {
                            if (dDLBridge.getDriverSpecification().areViewsSupported()) {
                                dDLBridge.getDriverSpecification().getTables("%", new String[]{"VIEW"});
                                resultSet = dDLBridge.getDriverSpecification().getResultSet();
                            } else if (MetaDataUtil.areViewsSupported(this.dmd.getDatabaseProductName())) {
                                resultSet = this.dmd.getTables(this.catalog, string, "%", new String[]{"VIEW"});
                            }
                        }
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                if (this.isStop()) {
                                    resultSet.close();
                                    return;
                                }
                                if (dDLBridge != null) {
                                    linkedList4.add((String)dDLBridge.getDriverSpecification().getRow().get(new Integer(3)));
                                    continue;
                                }
                                linkedList4.add(resultSet.getString("TABLE_NAME").trim());
                            }
                            resultSet.close();
                        }
                    } else {
                        linkedList3 = bl ? linkedList : this.checkReferences(linkedList, dDLBridge, string);
                        linkedList4 = linkedList2;
                    }
                    this.propertySupport.firePropertyChange("totalCount", null, new Integer(linkedList3.size() + linkedList4.size()));
                    this.initTables(connectionProvider, linkedList3);
                    this.initViews(connectionProvider, linkedList4, dDLBridge);
                }
                catch (Exception exception) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block20;
                    exception.printStackTrace();
                }
            }
        }
    }

    private LinkedList checkReferences(LinkedList linkedList, DDLBridge dDLBridge, String string) throws SQLException {
        int n = 0;
        while (n < linkedList.size()) {
            ResultSet resultSet;
            if (dDLBridge != null) {
                dDLBridge.getDriverSpecification().getImportedKeys(linkedList.get(n).toString());
                resultSet = dDLBridge.getDriverSpecification().getResultSet();
            } else {
                resultSet = this.dmd.getImportedKeys(this.catalog, string, linkedList.get(n).toString());
            }
            if (resultSet != null) {
                HashMap hashMap = new HashMap();
                while (resultSet.next()) {
                    String string2;
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    String string7;
                    String string8;
                    if (dDLBridge != null) {
                        hashMap = dDLBridge.getDriverSpecification().getRow();
                        string8 = (String)hashMap.get(new Integer(1));
                        string7 = (String)hashMap.get(new Integer(2));
                        string6 = (String)hashMap.get(new Integer(5));
                        string5 = (String)hashMap.get(new Integer(6));
                        if (!this.comp(string8, string6) || !this.comp(string7, string5)) continue;
                        string4 = (String)hashMap.get(new Integer(2));
                        if ((string4 == (string3 = (String)hashMap.get(new Integer(6))) || string4.equals(string3)) && !linkedList.contains(string2 = (String)hashMap.get(new Integer(3)))) {
                            linkedList.add(string2);
                        }
                        hashMap.clear();
                        continue;
                    }
                    string8 = resultSet.getString("PKTABLE_CAT");
                    string7 = resultSet.getString("PKTABLE_SCHEM");
                    string6 = resultSet.getString("FKTABLE_CAT");
                    string5 = resultSet.getString("FKTABLE_SCHEM");
                    if (!this.comp(string8, string6) || !this.comp(string7, string5) || (string4 = resultSet.getString("PKTABLE_SCHEM").trim()) != (string3 = resultSet.getString("FKTABLE_SCHEM").trim()) && !string4.equals(string3) || linkedList.contains(string2 = resultSet.getString("PKTABLE_NAME").trim())) continue;
                    linkedList.add(string2);
                }
                resultSet.close();
            }
            ++n;
        }
        return linkedList;
    }

    private void initTables(ConnectionProvider connectionProvider, LinkedList linkedList) throws DBException {
        TableElement[] tableElementArray;
        DBElementProperties dBElementProperties;
        int n = 0;
        while (n < linkedList.size()) {
            if (this.isStop()) {
                return;
            }
            String string = linkedList.get(n).toString();
            this.propertySupport.firePropertyChange("tableName", null, string);
            dBElementProperties = new TableElementImpl(string);
            ((TableElementImpl)dBElementProperties).setTableOrView(true);
            tableElementArray = new TableElement[]{new TableElement((TableElement.Impl)((Object)dBElementProperties), (SchemaElement)this.element)};
            ((TableElementImpl)dBElementProperties).initColumns(connectionProvider);
            ((TableElementImpl)dBElementProperties).initIndexes(connectionProvider);
            this.changeTables(tableElementArray, 1);
            ++this.progress;
            this.propertySupport.firePropertyChange("progress", null, new Integer(this.progress));
            ++n;
        }
        int n2 = 0;
        while (n2 < linkedList.size()) {
            if (this.isStop()) {
                return;
            }
            tableElementArray = linkedList.get(n2).toString();
            dBElementProperties = this.getTable(DBIdentifier.create((String)tableElementArray));
            if (dBElementProperties != null) {
                this.propertySupport.firePropertyChange("FKt", null, tableElementArray);
                ((TableElementImpl)((DBElement)dBElementProperties).getElementImpl()).initKeys(connectionProvider, 0, (String)tableElementArray);
            }
            ++n2;
        }
    }

    private void initViews(ConnectionProvider connectionProvider, LinkedList linkedList, DDLBridge dDLBridge) throws DBException, SQLException {
        int n = 0;
        while (n < linkedList.size()) {
            if (this.isStop()) {
                return;
            }
            String string = linkedList.get(n).toString();
            this.propertySupport.firePropertyChange("viewName", null, string);
            TableElementImpl tableElementImpl = new TableElementImpl(string);
            tableElementImpl.setTableOrView(false);
            TableElement tableElement = new TableElement(tableElementImpl, (SchemaElement)this.element);
            tableElementImpl.initColumns(connectionProvider);
            String string2 = this.dmd.getDatabaseProductName().trim();
            if (string2.equalsIgnoreCase("Oracle") || string2.equalsIgnoreCase("Microsoft SQL Server")) {
                this.propertySupport.firePropertyChange("FKv", null, string);
                ViewDependency viewDependency = new ViewDependency(connectionProvider, connectionProvider.getSchema(), string);
                LinkedList linkedList2 = new LinkedList();
                LinkedList linkedList3 = new LinkedList();
                linkedList2.clear();
                linkedList3.clear();
                viewDependency.constructPK();
                linkedList2 = viewDependency.getTables();
                linkedList3 = viewDependency.getColumns();
                if (!linkedList3.isEmpty()) {
                    KeyElement[] keyElementArray;
                    Object object;
                    Object object2;
                    Object object3;
                    int n2;
                    LinkedList<Object> linkedList4;
                    Object object4;
                    ResultSet resultSet;
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < linkedList3.size()) {
                        if (((String)linkedList3.get(n3)).trim().endsWith("*")) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    boolean bl2 = true;
                    LinkedList<String> linkedList5 = new LinkedList<String>();
                    int n4 = 0;
                    while (n4 < linkedList2.size()) {
                        if (this.isStop()) {
                            return;
                        }
                        if (dDLBridge != null) {
                            dDLBridge.getDriverSpecification().getPrimaryKeys(linkedList2.get(n4).toString());
                            resultSet = dDLBridge.getDriverSpecification().getResultSet();
                        } else {
                            resultSet = connectionProvider.getDatabaseMetaData().getPrimaryKeys(connectionProvider.getConnection().getCatalog(), connectionProvider.getSchema(), linkedList2.get(n4).toString());
                        }
                        if (resultSet != null) {
                            if (!bl) {
                                object4 = new HashMap();
                                while (resultSet.next()) {
                                    String string3;
                                    if (dDLBridge != null) {
                                        object4 = dDLBridge.getDriverSpecification().getRow();
                                        string3 = (String)((HashMap)object4).get(new Integer(4));
                                        ((HashMap)object4).clear();
                                    } else {
                                        string3 = resultSet.getString("COLUMN_NAME").trim();
                                    }
                                    if (linkedList3.contains(string3.toLowerCase()) || linkedList3.contains(linkedList2.get(n4).toString().toLowerCase() + "." + string3.toLowerCase())) continue;
                                    bl2 = false;
                                    break;
                                }
                            }
                            if (bl2) {
                                linkedList5.add(linkedList2.get(n4).toString());
                            }
                            resultSet.close();
                        }
                        ++n4;
                    }
                    if (bl2) {
                        int n5 = 0;
                        while (n5 < linkedList5.size()) {
                            tableElementImpl.initIndexes(connectionProvider, linkedList5.get(n5).toString());
                            tableElementImpl.initKeys(connectionProvider, 1, linkedList5.get(n5).toString());
                            linkedList4 = new LinkedList<Object>();
                            object4 = tableElement.getUniqueKeys();
                            int n6 = 0;
                            while (n6 < ((DBMemberElement[])object4).length) {
                                if (((UniqueKeyElement)object4[n6]).isPrimaryKey()) {
                                    linkedList4.add(object4[n6]);
                                }
                                ++n6;
                            }
                            object4 = new UniqueKeyElement[linkedList4.size()];
                            n2 = 0;
                            while (n2 < linkedList4.size()) {
                                object4[n2] = (UniqueKeyElement)linkedList4.get(n2);
                                ++n2;
                            }
                            tableElement.setKeys((KeyElement[])object4);
                            object3 = new IndexElement[((Object)object4).length];
                            int n7 = 0;
                            while (n7 < ((Object)object4).length) {
                                object3[n7] = ((UniqueKeyElement)object4[n7]).getAssociatedIndex();
                                ++n7;
                            }
                            tableElement.setIndexes((IndexElement[])object3);
                            ++n5;
                        }
                    }
                    if (tableElement.getUniqueKeys().length > 1) {
                        linkedList4 = new IndexElementImpl(tableElementImpl, "GENERATED_PK_" + tableElementImpl.getName().getName(), true);
                        object4 = new IndexElement[]{new IndexElement((IndexElement.Impl)((Object)linkedList4), tableElement)};
                        IndexElement[] indexElementArray = tableElement.getIndexes();
                        n2 = 0;
                        while (n2 < indexElementArray.length) {
                            ((IndexElementImpl)((Object)linkedList4)).changeColumns(indexElementArray[n2].getColumns(), 1);
                            ++n2;
                        }
                        tableElement.setIndexes((IndexElement[])object4);
                        object3 = tableElement.getIndexes()[0];
                        UniqueKeyElementImpl uniqueKeyElementImpl = new UniqueKeyElementImpl(((DBElement)object3).getName().getName(), true);
                        object2 = new UniqueKeyElement(uniqueKeyElementImpl, tableElement, (IndexElement)object3);
                        ((KeyElement)object2).setColumns(((IndexElement)object3).getColumns());
                        tableElementImpl.changeKeys(new UniqueKeyElement[]{object2}, 0);
                    }
                    linkedList4 = new LinkedList();
                    object4 = new LinkedList();
                    LinkedList<String> linkedList6 = new LinkedList<String>();
                    n2 = 0;
                    while (n2 < linkedList2.size()) {
                        if (this.isStop()) {
                            return;
                        }
                        if (dDLBridge != null) {
                            dDLBridge.getDriverSpecification().getImportedKeys(linkedList2.get(n2).toString());
                            resultSet = dDLBridge.getDriverSpecification().getResultSet();
                        } else {
                            resultSet = connectionProvider.getDatabaseMetaData().getImportedKeys(connectionProvider.getConnection().getCatalog(), connectionProvider.getSchema(), linkedList2.get(n2).toString());
                        }
                        if (resultSet != null) {
                            int n8;
                            String string4;
                            object3 = new HashMap();
                            LinkedList<String> linkedList7 = new LinkedList<String>();
                            object2 = new LinkedList();
                            object = new LinkedList();
                            while (resultSet.next()) {
                                String string5;
                                String string6;
                                String string7;
                                if (dDLBridge != null) {
                                    object3 = dDLBridge.getDriverSpecification().getRow();
                                    keyElementArray = (String)((HashMap)object3).get(new Integer(1));
                                    string7 = (String)((HashMap)object3).get(new Integer(2));
                                    string6 = (String)((HashMap)object3).get(new Integer(5));
                                    string5 = (String)((HashMap)object3).get(new Integer(6));
                                    if (!this.comp(keyElementArray, string6) || !this.comp(string7, string5) || (string4 = (String)((HashMap)object3).get(new Integer(12))) == null) continue;
                                    string4 = string4.trim();
                                    linkedList7.add(string4 + "." + (String)((HashMap)object3).get(new Integer(7)) + "." + (String)((HashMap)object3).get(new Integer(8)));
                                    ((LinkedList)object2).add(string4 + "." + (String)((HashMap)object3).get(new Integer(3)) + "." + (String)((HashMap)object3).get(new Integer(4)));
                                    if (!((LinkedList)object).contains(string4)) {
                                        ((LinkedList)object).add(string4);
                                    }
                                    ((HashMap)object3).clear();
                                    continue;
                                }
                                keyElementArray = resultSet.getString("PKTABLE_CAT");
                                string7 = resultSet.getString("PKTABLE_SCHEM");
                                string6 = resultSet.getString("FKTABLE_CAT");
                                string5 = resultSet.getString("FKTABLE_SCHEM");
                                if (!this.comp(keyElementArray, string6) || !this.comp(string7, string5) || (string4 = resultSet.getString("FK_NAME")) == null) continue;
                                string4 = string4.trim();
                                linkedList7.add(string4 + "." + resultSet.getString("FKTABLE_NAME").trim() + "." + resultSet.getString("FKCOLUMN_NAME").trim());
                                ((LinkedList)object2).add(string4 + "." + resultSet.getString("PKTABLE_NAME").trim() + "." + resultSet.getString("PKCOLUMN_NAME").trim());
                                if (((LinkedList)object).contains(string4)) continue;
                                ((LinkedList)object).add(string4);
                            }
                            resultSet.close();
                            int n9 = 0;
                            while (n9 < ((LinkedList)object).size()) {
                                String string8;
                                string4 = ((LinkedList)object).get(n9).toString();
                                int n10 = 0;
                                while (n10 < linkedList7.size()) {
                                    string8 = linkedList7.get(n10).toString();
                                    if (string8.startsWith(string4)) {
                                        string8 = string8.substring(string8.lastIndexOf(".") + 1).toLowerCase();
                                        if (!(bl || linkedList3.contains(string8) || linkedList3.contains(linkedList2.get(n2).toString().toLowerCase() + "." + string8))) {
                                            ((LinkedList)object).set(n9, null);
                                            break;
                                        }
                                    }
                                    ++n10;
                                }
                                if (((LinkedList)object).get(n9) != null) {
                                    n8 = 0;
                                    while (n8 < ((LinkedList)object2).size()) {
                                        string8 = ((LinkedList)object2).get(n8).toString();
                                        if (string8.startsWith(string4)) {
                                            if (this.getTable(DBIdentifier.create(string8 = string8.substring(string8.indexOf(".") + 1, string8.lastIndexOf(".")))) != null) break;
                                            linkedList4.add(string8);
                                            break;
                                        }
                                        ++n8;
                                    }
                                }
                                ++n9;
                            }
                            String string9 = linkedList2.get(n2).toString();
                            n8 = 0;
                            while (n8 < ((LinkedList)object).size()) {
                                Object e = ((LinkedList)object).get(n8);
                                if (e != null) {
                                    ((LinkedList)object4).add(e);
                                    if (!linkedList6.contains(string9)) {
                                        linkedList6.add(string9);
                                    }
                                }
                                ++n8;
                            }
                        }
                        ++n2;
                    }
                    this.initTables(connectionProvider, this.checkReferences(linkedList4, dDLBridge, connectionProvider.getSchema()));
                    int n11 = 0;
                    while (n11 < linkedList6.size()) {
                        tableElementImpl.initKeys(connectionProvider, 2, linkedList6.get(n11).toString());
                        ++n11;
                    }
                    LinkedList<Object> linkedList8 = new LinkedList<Object>();
                    object2 = tableElement.getForeignKeys();
                    object = tableElement.getUniqueKeys();
                    int n12 = 0;
                    while (n12 < ((ForeignKeyElement[])object2).length) {
                        if (((LinkedList)object4).contains(object2[n12].getName().getName())) {
                            linkedList8.add(object2[n12]);
                        }
                        ++n12;
                    }
                    keyElementArray = new KeyElement[((UniqueKeyElement[])object).length + linkedList8.size()];
                    int n13 = 0;
                    while (n13 < ((UniqueKeyElement[])object).length) {
                        keyElementArray[n13] = object[n13];
                        ++n13;
                    }
                    int n14 = ((Object)object).length;
                    int n15 = 0;
                    while (n15 < linkedList8.size()) {
                        keyElementArray[n15 + n14] = (ForeignKeyElement)linkedList8.get(n15);
                        ++n15;
                    }
                    tableElement.setKeys(keyElementArray);
                }
            }
            this.changeTables(new TableElement[]{tableElement}, 1);
            ++this.progress;
            this.propertySupport.firePropertyChange("progress", null, new Integer(this.progress));
            ++n;
        }
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String string) throws DBException {
        this._url = string;
    }

    public String getUsername() {
        return this._username;
    }

    public void setUsername(String string) throws DBException {
        this._username = string;
    }

    public String getDriver() {
        return this._driver;
    }

    public void setDriver(String string) {
        this._driver = string;
    }

    public String getDatabaseProductName() {
        return this._databaseProductName;
    }

    public void setDatabaseProductName(String string) throws DBException {
        this._databaseProductName = string;
    }

    public String getDatabaseProductVersion() {
        return this._databaseProductVersion;
    }

    public void setDatabaseProductVersion(String string) throws DBException {
        this._databaseProductVersion = string;
    }

    public String getDriverName() {
        return this._driverName;
    }

    public void setDriverName(String string) throws DBException {
        this._driverName = string;
    }

    public String getDriverVersion() {
        return this._driverVersion;
    }

    public void setDriverVersion(String string) throws DBException {
        this._driverVersion = string;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean bl) {
        this.stop = bl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public DBElementsCollection getTableCollection() {
        return this.tables;
    }

    public void setTableCollection(DBElementsCollection dBElementsCollection) {
        this.tables = dBElementsCollection;
    }
}

