/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.util;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.forte.util.DirManagerException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.openide.TopManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;

public class DirManager {
    private String dirName = null;
    private LocalFileSystem lfs = null;
    private Repository repo = null;
    private File dir = null;
    private static int nesting = 0;

    public DirManager() {
    }

    public DirManager(String aDirName) throws DirManagerException {
        this.init(aDirName);
    }

    public DirManager(File aDir) throws DirManagerException {
        this.init(aDir);
    }

    public String getDirName() {
        return this.dirName;
    }

    public FileSystem getFileSystem() {
        return this.lfs;
    }

    public FileObject getRoot() {
        return this.lfs.getRoot();
    }

    public void refresh() {
        this.getRoot().refresh();
    }

    public void whack() {
        this.refresh();
        this.whackKids(this.getRoot());
    }

    public void whackKids(FileObject parent) {
        Enumeration kids = parent.getChildren(false);
        while (kids.hasMoreElements()) {
            FileObject fo = null;
            try {
                Object o = kids.nextElement();
                Reporter.assertIt(o instanceof FileObject);
                fo = (FileObject)o;
                if (fo.isFolder()) {
                    this.whackKids(fo);
                }
                FileLock lock = fo.lock();
                fo.delete(lock);
            }
            catch (FileAlreadyLockedException e) {
                Reporter.error("Can't lock " + (fo != null ? fo.getName() : "") + " -- " + (Object)((Object)e));
            }
            catch (IOException e) {
                Reporter.error("Can't delete " + (fo != null ? fo.getName() : "") + " -- " + e);
            }
        }
    }

    public String toString() {
        nesting = 0;
        FileObject fo = this.lfs.getRoot();
        return this.dumpFolder(fo);
    }

    public void release(boolean delete) {
        block5: {
            try {
                if (this.lfs == null) break block5;
                if (delete) {
                    this.whack();
                }
                if (this.isMounted()) {
                    this.repo.removeFileSystem((FileSystem)this.lfs);
                }
                if (delete) {
                    this.dir.delete();
                }
            }
            catch (Throwable t) {
                Reporter.info(new StackTrace(t));
            }
        }
    }

    protected void init(String aDirName) throws DirManagerException {
        Reporter.assertIt(aDirName);
        this.init(new File(aDirName));
    }

    protected void init(File aDir) throws DirManagerException {
        Reporter.assertIt(aDir);
        try {
            this.setupDirName(aDir);
            this.getRepo();
            this.mount();
        }
        catch (Throwable t) {
            throw new DirManagerException(t);
        }
    }

    protected void setHidden() {
        Reporter.assertIt(this.lfs);
        this.lfs.setHidden(true);
    }

    private void setupDirName(File aDir) {
        this.dir = aDir;
        Reporter.assertIt(this.dir);
        Reporter.assertIt(this.dir.exists());
        Reporter.assertIt(this.dir.isDirectory());
        try {
            this.dirName = this.dir.getCanonicalPath();
        }
        catch (IOException e) {
            this.dirName = this.dir.getPath();
        }
        Reporter.assertIt(this.dirName);
    }

    private void getRepo() {
        this.repo = TopManager.getDefault().getRepository();
        Reporter.assertIt(this.repo);
    }

    private void mount() {
        if (this.isMounted()) {
            return;
        }
        this.doMount();
    }

    private boolean isMounted() {
        Reporter.assertIt(this.repo);
        Reporter.assertIt(this.dirName);
        this.lfs = null;
        Enumeration all = this.repo.getFileSystems();
        while (all.hasMoreElements()) {
            LocalFileSystem alfs;
            Object o = all.nextElement();
            if (!(o instanceof LocalFileSystem) || !(alfs = (LocalFileSystem)o).getRootDirectory().equals(this.dir)) continue;
            this.lfs = alfs;
            Reporter.verbose("FS already Mounted..." + alfs);
            return true;
        }
        return false;
    }

    private void doMount() {
        Reporter.assertIt(this.repo);
        this.lfs = new LocalFileSystem();
        try {
            this.lfs.setRootDirectory(this.dir);
            this.repo.addFileSystem((FileSystem)this.lfs);
            Reporter.info("Mounted new FileSystem!");
        }
        catch (PropertyVetoException e) {
            this.lfs = null;
            Reporter.crit("Can't mount FileSystem!" + e);
        }
        catch (IOException e) {
            this.lfs = null;
            Reporter.crit("Can't mount FileSystem!" + e);
        }
    }

    private String dumpFolder(FileObject fo) {
        String prepend = "";
        int j = 0;
        while (j < nesting) {
            prepend = prepend + "  ";
            ++j;
        }
        ++nesting;
        String s = prepend + "<" + fo.getName() + ">" + '\n';
        prepend = prepend + "  ";
        FileObject[] fos = fo.getChildren();
        int i = 0;
        while (i < fos.length) {
            s = fos[i].isFolder() ? s + this.dumpFolder(fos[i]) : s + prepend + fos[i].getName() + '\n';
            ++i;
        }
        --nesting;
        return s;
    }
}

