/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.server;

import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFRuntimeStoreException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.ServerInstanceManagerFactory;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.datasource.DSBean;
import com.iplanet.ias.tools.forte.datasource.DataSourceUtil;
import com.iplanet.ias.tools.forte.server.AdminInstanceBean;
import com.iplanet.ias.tools.forte.server.ConfigXml;
import com.iplanet.ias.tools.forte.server.PropChanger;
import com.iplanet.ias.tools.forte.util.NotifyUtil;
import java.awt.Dialog;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class RegDSNodeChildren
extends Children.Keys {
    protected List myKeys;
    private ChangeListener listener;
    private AppServerInstance serv_inst;
    private ServerInstanceManager serv_manager;
    private AdminInstanceBean adminbn;
    private Hashtable beanToResource;
    String si_name;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$actions$DeleteRegJDBCAction;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$datasource$DSBean;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$server$RegDSNodeChildren;

    public RegDSNodeChildren(AppServerInstance si, AdminInstanceBean bn) {
        this.serv_inst = si;
        this.adminbn = bn;
        this.si_name = this.serv_inst.getName() + "(" + this.adminbn.getHost() + ":" + this.adminbn.getPort() + ")";
    }

    protected void addNotify() {
        try {
            this.refreshList();
        }
        catch (AFRuntimeStoreException afre) {
            new ConfigXml((Dialog)new JDialog(), false, this.si_name);
        }
        this.listener = new ChangeListener(){

            public void stateChanged(ChangeEvent ev) throws AFRuntimeStoreException {
                RegDSNodeChildren.this.refreshList();
            }
        };
        PropChanger.getDefault().addChangeListener(this.listener);
    }

    protected void removeNotify() {
        if (this.listener != null) {
            PropChanger.getDefault().removeChangeListener(this.listener);
            this.listener = null;
        }
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        Reporter.info(key);
        try {
            if (this.adminbn.adminRunning()) {
                return new Node[]{new RegDSNode((DSBean)key)};
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void refreshList() throws AFRuntimeStoreException {
        ArrayList<DSBean> keys = new ArrayList<DSBean>();
        if (this.adminbn.adminRunning()) {
            this.serv_manager = ServerInstanceManagerFactory.getFactory().getServerInstanceManager(new HostAndPort(this.adminbn.getHost(), this.adminbn.getPort()), this.adminbn.getUserName(), this.adminbn.getPassword());
            try {
                AppServerInstance si = this.serv_manager.getServerInstance(this.serv_inst.getName());
                ServerModelIterator deployedJdbc = si.getJDBCResources();
                this.beanToResource = new Hashtable();
                while (deployedJdbc.hasNext()) {
                    ServerComponent regres = (ServerComponent)deployedJdbc.next();
                    DSBean bn = DataSourceUtil.getResourceBean(regres);
                    if (bn == null) continue;
                    keys.add(bn);
                    Reporter.info(bn);
                    this.beanToResource.put(bn, regres);
                }
            }
            catch (AFTargetNotFoundException te) {
                te.printStackTrace();
            }
            catch (AFException ex) {
                ex.printStackTrace();
            }
            catch (AFRuntimeStoreException afre) {
                throw new AFRuntimeStoreException(afre.getLocalizedMessage());
            }
            Collections.sort(keys);
            this.setKeys(keys);
        } else {
            this.removeNotify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RegDSNode
    extends AbstractNode
    implements PropertyChangeListener {
        private DSBean resource;
        private ServerComponent regResource;
        private ChangeListener listener;
        private SystemAction[] adminUpactions = null;

        public RegDSNode(DSBean key) throws IntrospectionException {
            super(Children.LEAF);
            this.resource = key;
            super.setName(key.getJndiName());
            this.setIconBase("/com/iplanet/ias/tools/forte/resources/ResNodeNodeIcon");
            this.adminUpactions = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RegDSNodeChildren.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)), null, SystemAction.get((Class)(class$com$iplanet$ias$tools$forte$actions$DeleteRegJDBCAction == null ? (class$com$iplanet$ias$tools$forte$actions$DeleteRegJDBCAction = RegDSNodeChildren.class$("com.iplanet.ias.tools.forte.actions.DeleteRegJDBCAction")) : class$com$iplanet$ias$tools$forte$actions$DeleteRegJDBCAction))};
            try {
                this.createProperties(key, Utilities.getBeanInfo((Class)(class$com$iplanet$ias$tools$forte$datasource$DSBean == null ? (class$com$iplanet$ias$tools$forte$datasource$DSBean = RegDSNodeChildren.class$("com.iplanet.ias.tools.forte.datasource.DSBean")) : class$com$iplanet$ias$tools$forte$datasource$DSBean)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            key.addPropertyChangeListener(this);
        }

        public SystemAction getDefaultAction() {
            return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = RegDSNodeChildren.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
        }

        protected SystemAction[] createActions() {
            if (RegDSNodeChildren.this.adminbn.adminRunning()) {
                return this.adminUpactions;
            }
            String mess = MessageFormat.format(NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$RegDSNodeChildren == null ? (class$com$iplanet$ias$tools$forte$server$RegDSNodeChildren = RegDSNodeChildren.class$("com.iplanet.ias.tools.forte.server.RegDSNodeChildren")) : class$com$iplanet$ias$tools$forte$server$RegDSNodeChildren), (String)"Msg_ErrorConnect"), RegDSNodeChildren.this.adminbn.getName());
            NotifyUtil.showError(mess, NbBundle.getMessage((Class)(class$com$iplanet$ias$tools$forte$server$RegDSNodeChildren == null ? (class$com$iplanet$ias$tools$forte$server$RegDSNodeChildren = RegDSNodeChildren.class$("com.iplanet.ias.tools.forte.server.RegDSNodeChildren")) : class$com$iplanet$ias$tools$forte$server$RegDSNodeChildren), (String)"Msg_ServError"));
            RegDSNodeChildren.this.removeNotify();
            return null;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("S1_data_prop.html");
        }

        public void setName(String nue) {
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set props = sheet.get("properties");
            if (props == null) {
                props = Sheet.createPropertiesSet();
                sheet.put(props);
            }
            return sheet;
        }

        protected void createProperties(Object bean, BeanInfo info) {
            BeanNode.Descriptor d = BeanNode.computeProperties((Object)bean, (BeanInfo)info);
            Sheet sets = this.getSheet();
            Sheet.Set pset = Sheet.createPropertiesSet();
            pset.put(d.property);
            pset.setValue("helpID", (Object)"S1_data_prop.html");
            sets.put(pset);
        }

        private ServerComponent getRegResource() {
            if (this.regResource == null) {
                this.regResource = (ServerComponent)RegDSNodeChildren.this.beanToResource.get(this.resource);
                Reporter.info(this.regResource);
            }
            return this.regResource;
        }

        public void propertyChange(PropertyChangeEvent event) {
            try {
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                if (oldValue == null && newValue == null) {
                    return;
                }
                boolean attributeChanged = true;
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                if (event.getPropertyName().equals("name")) {
                    return;
                }
                if (event.getPropertyName().equals("JndiName")) {
                    Reporter.info(event.getSource().getClass().getName());
                    DSBean sourceBean = (DSBean)event.getSource();
                    sourceBean.simpleSetJndiName((String)oldValue);
                    return;
                }
                attributeChanged = DataSourceUtil.setAttribute(this.getRegResource(), event.getPropertyName(), newValue);
                try {
                    Reporter.info(RegDSNodeChildren.this.serv_inst.getName());
                    if (attributeChanged) {
                        RegDSNodeChildren.this.serv_inst.applyChanges();
                    } else {
                        RegDSNodeChildren.this.refreshList();
                    }
                }
                catch (AFException ex) {
                    ex.printStackTrace();
                }
            }
            catch (AFRuntimeStoreException ex) {
                new ConfigXml((Dialog)new JDialog(), true, RegDSNodeChildren.this.si_name);
                try {
                    RegDSNodeChildren.this.refreshList();
                }
                catch (AFRuntimeStoreException e) {
                    Reporter.info("Got AFRuntimeStoreException again during refreshList");
                }
            }
        }
    }
}

