/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.security;

import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.ejb.IASAppAsmItem;
import com.iplanet.ias.tools.forte.ejb.IASEJBModuleItem;
import com.iplanet.ias.tools.forte.ejb.security.RoleMapperModel;
import com.iplanet.ias.tools.forte.ejb.security.RoleMapperView;
import com.iplanet.ias.tools.forte.ejb.security.RoleMappingDataHolder;
import com.iplanet.ias.tools.forte.ejb.security.Utils;
import com.iplanet.ias.tools.forte.web.IASWebConfigurator;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import org.openide.explorer.propertysheet.PropertySheetSettings;
import org.openide.util.NbBundle;

public class SecurityRoleEditor
extends PropertyEditorSupport {
    private ResourceBundle bundle = NbBundle.getBundle((Class)(class$com$iplanet$ias$tools$forte$ejb$security$SecurityRoleEditor == null ? (class$com$iplanet$ias$tools$forte$ejb$security$SecurityRoleEditor = SecurityRoleEditor.class$("com.iplanet.ias.tools.forte.ejb.security.SecurityRoleEditor")) : class$com$iplanet$ias$tools$forte$ejb$security$SecurityRoleEditor));
    private IASEJBModuleItem moduleItem = null;
    private IASAppAsmItem iASAppAsmItem = null;
    private IASWebConfigurator iASWebConfigurator = null;
    private int securityRoleEditorFor = 0;
    private static int EJBJAR = 1;
    private static int APP = 2;
    private static int WEBAPP = 3;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheetSettings;
    static /* synthetic */ Class class$com$iplanet$ias$tools$forte$ejb$security$SecurityRoleEditor;

    public SecurityRoleEditor(IASEJBModuleItem theModuleItem) {
        Reporter.assertIt(theModuleItem);
        this.moduleItem = theModuleItem;
        this.securityRoleEditorFor = EJBJAR;
    }

    public SecurityRoleEditor(IASAppAsmItem iASAppAsmItem) {
        Reporter.assertIt(iASAppAsmItem);
        this.iASAppAsmItem = iASAppAsmItem;
        this.securityRoleEditorFor = APP;
    }

    public SecurityRoleEditor(IASWebConfigurator iASWebConfigurator) {
        Reporter.assertIt(iASWebConfigurator);
        this.iASWebConfigurator = iASWebConfigurator;
        this.securityRoleEditorFor = WEBAPP;
    }

    public String getAsText() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        int num;
        if (this.securityRoleEditorFor == EJBJAR) {
            num = this.moduleItem.getNumSecurityRoles();
        } else if (this.securityRoleEditorFor == APP) {
            num = this.iASAppAsmItem.getNumSecurityRoles();
        } else {
            Reporter.assertIt(this.securityRoleEditorFor == WEBAPP, "InValidObject");
            num = this.iASWebConfigurator.getNumSecurityRoles();
        }
        String s = "" + num + " ";
        s = num == 1 ? s + Utils.getString("Role_Singular") : s + Utils.getString("Role_Plural");
        FontMetrics fm = gfx.getFontMetrics();
        PropertySheetSettings pss = (PropertySheetSettings)PropertySheetSettings.findObject((Class)(class$org$openide$explorer$propertysheet$PropertySheetSettings == null ? (class$org$openide$explorer$propertysheet$PropertySheetSettings = SecurityRoleEditor.class$("org.openide.explorer.propertysheet.PropertySheetSettings")) : class$org$openide$explorer$propertysheet$PropertySheetSettings), (boolean)true);
        gfx.setColor(pss.getValueColor());
        gfx.drawString(s, 4, (box.height - fm.getHeight()) / 2 + 1 + fm.getMaxAscent());
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        RoleMappingDataHolder data = null;
        if (this.securityRoleEditorFor == EJBJAR) {
            data = new RoleMappingDataHolder(this.moduleItem.getSunEjbJar(), this.moduleItem.getSecurityRoleNames());
        } else if (this.securityRoleEditorFor == APP) {
            data = new RoleMappingDataHolder(this.iASAppAsmItem.getSunApplication(), this.iASAppAsmItem.getSecurityRoleNames());
        } else {
            Reporter.assertIt(this.securityRoleEditorFor == WEBAPP, "InValidObject");
            data = new RoleMappingDataHolder(this.iASWebConfigurator.getSunWebApp(), this.iASWebConfigurator.getSecurityRoleNames());
        }
        RoleMapperModel model = new RoleMapperModel(data);
        RoleMapperView view = new RoleMapperView(model);
        return view;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

