/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ByteChunk;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.ParamInfo;
import com.iplanet.ias.admin.common.domains.registry.DomainEntry;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyExistsException;
import com.iplanet.ias.admin.common.exception.NoSuchInstanceException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.HostAndPort;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AdminController
implements Controller {
    public static final String CREATE_INSTANCE = "createServerInstance";
    public static final String DELETE_INSTANCE = "deleteServerInstance";
    public static final String GET_ALL_SERVER_INSTANCES = "listServerInstances";
    public static final String GET_INSTANCE_HOSTPORT = "getHostAndPort";
    public static final String LIST_GENERIC_NAMES = "listGenericDottedNameContinuiations";
    public static final String GET_GENERIC_ATTRIBUTES = "getGenericAttributes";
    public static final String GET_GENERIC_DEFAULT_VALUES = "getGenericAttributeDefaultValues";
    public static final String SET_GENERIC_ATTRIBUTES = "setGenericAttributes";
    public static final String LIST_MONITORABLE_COMPONENTS = "listMonitor";
    public static final String GET_MONITOR_ATTRIBUTES = "getMonitor";
    public static final String SET_MONITOR_ATTRIBUTES = "setMonitor";
    public static final String GET_VERSION = "getVersion";
    public static final String GET_FULL_VERSION = "getFullVersion";
    public static final String STOP_SERVER = "shutdown";
    public static final String LIST_DOMAINS = "listDomains";
    public static final String STOP_DOMAIN = "stopDomain";
    public static final String GET_LICENSE_INFO = "getLicenseInfo";
    private final ServerInstanceManager adminServerComponent;

    public AdminController(ServerInstanceManager sim) {
        this.adminServerComponent = sim;
    }

    public AppServerInstance getServerInstance(String name) throws AFTargetNotFoundException {
        AppServerInstance si = null;
        if (name.equals("admin-server")) {
            throw new AFTargetNotFoundException(name);
        }
        try {
            HostAndPort hostAndPort = this.getInstanceHostPort(name);
            Assert.assertit(hostAndPort != null, "null value returned");
            si = new AppServerInstance(hostAndPort, name);
            si.setContextHolder(this.adminServerComponent.getContextHolder());
        }
        catch (AFException e) {
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return si;
    }

    public AppServerInstance getAdminInstance() throws AFException {
        HostAndPort hostAndPort = this.getInstanceHostPort("admin-server");
        Assert.assertit(hostAndPort != null, "null value returned");
        AppServerInstance si = new AppServerInstance(hostAndPort, "admin-server");
        si.setContextHolder(this.adminServerComponent.getContextHolder());
        return si;
    }

    public ServerModelIterator getAllServerInstances() {
        Vector<AppServerInstance> serverInstances = new Vector<AppServerInstance>();
        ObjectName mbeanName = ObjectNames.getControllerObjectName();
        String[] signature = new String[]{};
        Object[] params = new Object[]{};
        ContextHolder ctxHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        try {
            String[] instances = (String[])dispatcher.invoke(mbeanName, GET_ALL_SERVER_INSTANCES, params, signature);
            if (instances != null) {
                int i = 0;
                while (i < instances.length) {
                    AppServerInstance si = this.getServerInstance(instances[i]);
                    if (si != null) {
                        serverInstances.add(si);
                    }
                    ++i;
                }
            }
        }
        catch (AFException e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return new ServerModelIterator(serverInstances);
    }

    public AppServerInstance createServerInstance(HostAndPort hAndp, String instanceName, String runAsUser) throws InstanceAlreadyExistsException, ControlException {
        AppServerInstance serverInstance = null;
        try {
            ContextHolder adminCtxHolder = this.adminServerComponent.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(adminCtxHolder);
            ObjectName mbeanName = ObjectNames.getControllerObjectName();
            Debug.println("createServerInstance : controller mbean name = " + mbeanName.toString());
            Object[] params = new Object[]{instanceName, hAndp, runAsUser, Boolean.FALSE};
            String[] signature = new String[]{"java.lang.String", "com.iplanet.ias.admin.util.HostAndPort", "java.lang.String", "boolean"};
            Object result = dispatcher.invoke(mbeanName, CREATE_INSTANCE, params, signature);
            Debug.println("createServerInstance : instance " + instanceName + " created successfully");
            serverInstance = new AppServerInstance(hAndp, instanceName);
            serverInstance.setContextHolder(adminCtxHolder);
        }
        catch (AFException e) {
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return serverInstance;
    }

    public AppServerInstance createServerInstance(HostAndPort hAndp, String instanceName, String mailHost, String user, String docRoot, int jmsPort, String jmsUser, String jmsPasswd) throws InstanceAlreadyExistsException, ControlException {
        AppServerInstance serverInstance = null;
        try {
            ContextHolder adminCtxHolder = this.adminServerComponent.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(adminCtxHolder);
            ObjectName mbeanName = ObjectNames.getControllerObjectName();
            Debug.println("createServerInstance : controller mbean name = " + mbeanName.toString());
            String[] signature = new String[]{"com.iplanet.ias.admin.util.HostAndPort", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "java.lang.String", "java.lang.String", "boolean"};
            Object[] params = new Object[]{hAndp, instanceName, mailHost, user, docRoot, new Integer(jmsPort), jmsUser, jmsPasswd, Boolean.FALSE};
            Object result = dispatcher.invoke(mbeanName, CREATE_INSTANCE, params, signature);
            Debug.println("createServerInstance : instance " + instanceName + " created successfully");
            serverInstance = new AppServerInstance(hAndp, instanceName);
            serverInstance.setContextHolder(adminCtxHolder);
        }
        catch (AFException e) {
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return serverInstance;
    }

    public boolean deleteServerInstance(String instanceName) throws NoSuchInstanceException, ControlException {
        boolean isDeleted = false;
        try {
            ContextHolder adminCtxHolder = this.adminServerComponent.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(adminCtxHolder);
            ObjectName mbeanName = ObjectNames.getControllerObjectName();
            Object[] params = new Object[]{instanceName};
            String[] signature = new String[]{"java.lang.String"};
            Object result = dispatcher.invoke(mbeanName, DELETE_INSTANCE, params, signature);
            Debug.println("deleteServerInstance : instance " + instanceName + " deleted successfully");
            isDeleted = true;
        }
        catch (AFException e) {
            if (e instanceof NoSuchInstanceException) {
                throw (NoSuchInstanceException)e;
            }
            if (e instanceof ControlException) {
                throw (ControlException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return isDeleted;
    }

    public boolean deleteServerInstance(AppServerInstance serverInstance) throws NoSuchInstanceException, ControlException {
        return this.deleteServerInstance(serverInstance.getName());
    }

    public AttributeList getGenericAttributes(String[] attributes) throws AFTargetNotFoundException, AttributeNotFoundException {
        ArgChecker.checkValid(attributes, "attributes");
        AttributeList attribList = null;
        try {
            Object[] params = new Object[]{attributes};
            String[] signature = new String[]{attributes.getClass().getName()};
            attribList = (AttributeList)this.invokeGenericConfigurator(GET_GENERIC_ATTRIBUTES, params, signature);
        }
        catch (AFException e) {
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return attribList;
    }

    public AttributeList getGenericAttributeDefaultValues(String instanceName, String configMBeanType, String[] attributes) throws AFTargetNotFoundException {
        ArgChecker.checkValid(attributes, "attributes");
        AttributeList attribList = null;
        try {
            Object[] params = new Object[]{instanceName, configMBeanType, attributes};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", attributes.getClass().getName()};
            attribList = (AttributeList)this.invokeGenericConfigurator(GET_GENERIC_DEFAULT_VALUES, params, signature);
        }
        catch (AFException e) {
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return attribList;
    }

    public String[] listGenericDottedNameContinuiations(String dottedNamePrefix) throws AFTargetNotFoundException {
        String[] names = null;
        try {
            Object[] params = new Object[]{dottedNamePrefix};
            String[] signature = new String[]{dottedNamePrefix.getClass().getName()};
            names = (String[])this.invokeGenericConfigurator(LIST_GENERIC_NAMES, params, signature);
        }
        catch (AFException e) {
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return names;
    }

    public AttributeList setGenericAttributes(AttributeList al) throws AFTargetNotFoundException {
        ArgChecker.checkValid(al, "al");
        AttributeList setList = null;
        try {
            Object[] params = new Object[]{al};
            String[] signature = new String[]{"javax.management.AttributeList"};
            setList = (AttributeList)this.invokeGenericConfigurator(SET_GENERIC_ATTRIBUTES, params, signature);
        }
        catch (AFException e) {
            if (e instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)e;
            }
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return setList;
    }

    public String[] listMonitorableComponents(String parent) throws AFException {
        ArgChecker.checkValid(parent, "parent", StringValidator.getInstance());
        Object[] params = new Object[]{parent};
        String[] signature = new String[]{"java.lang.String"};
        String[] componentNames = (String[])this.invokeGenericConfigurator(LIST_MONITORABLE_COMPONENTS, params, signature);
        return componentNames;
    }

    public AttributeList getMonitorAttributes(String[] attributes) throws AFException {
        ArgChecker.checkValid(attributes, "attributes");
        Object[] params = new Object[]{attributes};
        String[] signature = new String[]{attributes.getClass().getName()};
        AttributeList attributeList = (AttributeList)this.invokeGenericConfigurator(GET_MONITOR_ATTRIBUTES, params, signature);
        return attributeList;
    }

    public AttributeList setMonitorAttributes(AttributeList al) throws AFException {
        ArgChecker.checkValid(al, "al");
        Object[] params = new Object[]{al};
        String[] signature = new String[]{"javax.management.AttributeList"};
        AttributeList attributeList = (AttributeList)this.invokeGenericConfigurator(SET_MONITOR_ATTRIBUTES, params, signature);
        return attributeList;
    }

    public String getVersion() throws AFException {
        String version = (String)this.invokeServerController(GET_VERSION, null, null);
        Assert.assertit(version != null, "null value returned");
        return version;
    }

    public String getFullVersion() throws AFException {
        String version = (String)this.invokeServerController(GET_FULL_VERSION, null, null);
        Assert.assertit(version != null, "null value returned");
        return version;
    }

    public void stopServer() throws AFException {
        this.invokeServerController(STOP_SERVER, null, null);
    }

    public String uploadFile(String filePath) throws Exception {
        String remoteLocation = null;
        long begin = System.currentTimeMillis();
        ObjectName mbeanName = new ObjectName("ias:type=controller");
        String operationName = "uploadToServer";
        ContextHolder ctxHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        File f = new File(filePath);
        RandomAccessFile file = new RandomAccessFile(f, "r");
        byte[] bytes = new byte[65536];
        int bytesRead = 0;
        long totalBytesRead = 0L;
        boolean isFirstChunk = true;
        boolean isLastChunk = false;
        long fileSize = file.length();
        int index = 0;
        while ((bytesRead = file.read(bytes)) != -1) {
            totalBytesRead += (long)bytesRead;
            if (bytesRead < bytes.length) {
                byte[] realBytes = new byte[bytesRead];
                int i = 0;
                while (i < bytesRead) {
                    realBytes[i] = bytes[i];
                    ++i;
                }
                bytes = realBytes;
            }
            if (totalBytesRead == fileSize) {
                isLastChunk = true;
            }
            ByteChunk aChunk = new ByteChunk(bytes, f.getName(), isFirstChunk, isLastChunk);
            ParamInfo paramInfo = new ParamInfo(operationName, aChunk);
            remoteLocation = (String)dispatcher.invoke(mbeanName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
            Debug.println("Chunk[" + index + "] sent");
            ++index;
            isFirstChunk = false;
        }
        long end = System.currentTimeMillis();
        Debug.println("Time to transfer : " + (end - begin) + " ms");
        return remoteLocation;
    }

    private Object invokeGenericConfigurator(String operationName, Object[] params, String[] signature) throws AFException {
        ContextHolder ctxHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        ObjectName mbeanName = null;
        try {
            mbeanName = new ObjectName("ias:type=configurator");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        Assert.assertit(mbeanName != null, "null value returned");
        Object retValue = dispatcher.invoke(mbeanName, operationName, params, signature);
        return retValue;
    }

    private Object invokeServerController(String operationName, Object[] params, String[] signature) throws AFException {
        ContextHolder ctxHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        ObjectName mbeanName = ObjectNames.getControllerObjectName();
        Object retValue = dispatcher.invoke(mbeanName, operationName, params, signature);
        return retValue;
    }

    private HostAndPort getInstanceHostPort(String instanceName) throws AFException {
        ObjectName mbeanName = ObjectNames.getServerInstanceObjectName(instanceName);
        ContextHolder ctxHolder = this.adminServerComponent.getContextHolder();
        SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
        HostAndPort hostAndPort = (HostAndPort)dispatcher.invoke(mbeanName, GET_INSTANCE_HOSTPORT, null, null);
        return hostAndPort;
    }

    public DomainEntry[] listDomains() throws AFException {
        DomainEntry[] domains = (DomainEntry[])this.invokeServerController(LIST_DOMAINS, null, null);
        return domains;
    }

    public void stopDomain(boolean stopAdmin) throws AFException {
        Object[] params = new Boolean[]{new Boolean(stopAdmin)};
        String[] signature = new String[]{"boolean"};
        this.invokeServerController(STOP_DOMAIN, params, signature);
    }

    public String getLicenseInfo() throws AFException {
        String licenseInfo = (String)this.invokeServerController(GET_LICENSE_INFO, null, null);
        return licenseInfo;
    }
}

