/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.impl.client;

import com.sun.netstorage.mgmt.ui.cli.Constants;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.client.ClientHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.client.ClientHandlerChain;
import com.sun.netstorage.mgmt.ui.cli.util.Localizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpPostHandler
implements ClientHandler {
    String HTTP = "http://";
    String HTTPS = "https://";
    static TrustManager[] trustAllCerts = null;
    static SSLContext sc = null;

    public InputStream execute(Vector command, ClientHandlerChain chain, Hashtable context) throws IOException, CLIException, CLIExecutionException {
        if (null == command) {
            throw new RuntimeException(Localizer.getString("command-not-found"));
        }
        String server = "";
        String port = "";
        String path = "";
        boolean secure = false;
        boolean strict = false;
        int j = 1;
        HashMap<String, String> keyValuePairs = new HashMap<String, String>();
        Locale sampleLocale = Locale.US;
        keyValuePairs.put("~locale_country", sampleLocale.getCountry());
        keyValuePairs.put("~locale_language", sampleLocale.getLanguage());
        keyValuePairs.put("~locale_variant", sampleLocale.getVariant());
        int i = 0;
        while (i < command.size()) {
            String args = (String)command.elementAt(i);
            if (args != null) {
                if (args.equals("~server")) {
                    server = (String)command.elementAt(i + 1);
                    ++i;
                } else if (args.equals("~port")) {
                    port = (String)command.elementAt(i + 1);
                    ++i;
                } else if (args.equals("~servlet_path")) {
                    path = (String)command.elementAt(i + 1);
                    ++i;
                } else if (args.equals("~secure")) {
                    secure = new Boolean((String)command.elementAt(i + 1));
                    ++i;
                } else if (args.equals("~strict-certificate")) {
                    strict = new Boolean((String)command.elementAt(i + 1));
                    ++i;
                } else if (args.equals("~app")) {
                    keyValuePairs.put("~app", (String)command.elementAt(i + 1));
                    ++i;
                } else if (args.equals("~username")) {
                    keyValuePairs.put("~username", (String)command.elementAt(i + 1));
                    ++i;
                } else if (args.equals("~password")) {
                    keyValuePairs.put("~password", (String)command.elementAt(i + 1));
                    ++i;
                } else if (args.equals("~rolename")) {
                    keyValuePairs.put("~rolename", (String)command.elementAt(i + 1));
                    ++i;
                } else if (args.equals("~role_password")) {
                    keyValuePairs.put("~role_password", (String)command.elementAt(i + 1));
                    ++i;
                } else {
                    keyValuePairs.put("~param" + j, (String)command.elementAt(i));
                    ++j;
                }
            }
            ++i;
        }
        if (secure) {
            if (trustAllCerts == null && !strict) {
                trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
            }
            try {
                if (sc == null) {
                    sc = SSLContext.getInstance("SSL");
                    sc.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    if (!strict) {
                        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                            public boolean verify(String hostname, SSLSession session) {
                                return true;
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String urlStr = secure ? this.HTTPS : this.HTTP;
        urlStr = urlStr + server + ":" + port + path;
        if (Constants.verbose) {
            System.out.println("HttpPostHandler: connecting to " + urlStr);
        }
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
        PrintWriter out = new PrintWriter(byteStream, true);
        StringBuffer postData = new StringBuffer();
        Iterator allParamKeys = keyValuePairs.keySet().iterator();
        while (allParamKeys.hasNext()) {
            String localKey = (String)allParamKeys.next();
            String localValue = (String)keyValuePairs.get(localKey);
            postData.append(URLEncoder.encode(localKey) + "=" + URLEncoder.encode(localValue) + "&");
        }
        if (postData.length() > 0) {
            postData.setLength(postData.length() - 1);
        }
        out.print(postData.toString());
        out.flush();
        String lengthString = String.valueOf(byteStream.size());
        connection.setRequestProperty("Content-Length", lengthString);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        try {
            connection.connect();
        }
        catch (IOException ex) {
            throw new IOException(Localizer.getString("connection-failure") + urlStr);
        }
        byteStream.writeTo(connection.getOutputStream());
        return connection.getInputStream();
    }

    public static void main(String[] args) {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < args.length) {
            v.addElement(args[i]);
            ++i;
        }
        HttpPostHandler hp = new HttpPostHandler();
        try {
            InputStream is = hp.execute(v, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

