/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.impl.client;

import com.sun.netstorage.mgmt.ui.cli.util.Localizer;
import com.sun.netstorage.mgmt.ui.cli.util.PasswordField;
import com.sun.netstorage.mgmt.ui.cli.util.ValueField;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class HandlerHelper {
    public static void loadRequiredParams(Vector command, String[] keys) throws RuntimeException {
        HandlerHelper.loadRequiredParams(command, keys, "");
    }

    public static void loadRequiredParams(Vector command, String[] keys, String resourceFileName) throws RuntimeException {
        HandlerHelper.loadParams(command, keys, resourceFileName, true);
    }

    public static void loadParams(Vector command, String[] keys, String resourceFileName, boolean required) throws RuntimeException {
        block10: {
            Properties props = null;
            try {
                if (keys == null) {
                    props = new Properties();
                    props.load(new FileInputStream(resourceFileName));
                    Enumeration<Object> enumeration = props.keys();
                    while (enumeration.hasMoreElements()) {
                        String key = (String)enumeration.nextElement();
                        String value = props.getProperty(key);
                        if (value != null && !"".equals(value)) {
                            System.out.println("adding: key=" + key + " value=" + value);
                            command.insertElementAt(value, 0);
                        }
                        command.insertElementAt(key, 0);
                    }
                } else {
                    int i = 0;
                    while (i < keys.length) {
                        String value = null;
                        String key = keys[i];
                        if (keys[i] != null && command.indexOf(keys[i]) < 0) {
                            if (props == null) {
                                props = new Properties();
                                props.load(new FileInputStream(resourceFileName));
                            }
                            if ((value = props.getProperty(key)) != null) {
                                command.insertElementAt(value, 0);
                                command.insertElementAt(keys[i], 0);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (IOException ex) {
                if (!required) break block10;
                throw new RuntimeException(Localizer.getString("props-not-available") + ex.getMessage());
            }
        }
    }

    public static void checkRequiredParams(Vector command, String[] keys) throws RuntimeException {
        if (keys == null) {
            throw new IllegalArgumentException("key==null");
        }
        String appName = "";
        int ind = command.indexOf("~app");
        if (ind < 0) {
            throw new RuntimeException(Localizer.getString("application-name-is-not-found"));
        }
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            int idx = command.indexOf(keys[i]);
            String keyValue = (String)command.elementAt(idx + 1);
            if (keys[i] != null && command.indexOf(keys[i]) < 0) {
                throw new RuntimeException(Localizer.getString("missing-param") + keys[i]);
            }
            if (null == keyValue || "".equals(keyValue.trim()) || keyValue.startsWith("-")) {
                throw new RuntimeException(Localizer.getString("missing-required-param" + key));
            }
            ++i;
        }
    }

    public static void promptRequiredParams(Vector command, String[] keys) throws RuntimeException {
        if (keys == null) {
            throw new IllegalArgumentException("key==null");
        }
        int i = 0;
        while (i < keys.length) {
            String value = null;
            String key = keys[i];
            int idx = command.indexOf(keys[i]);
            String keyValue = (String)command.elementAt(idx + 1);
            if (keys[i] != null && command.indexOf(keys[i]) < 0) {
                try {
                    value = !key.equals("~password") && !key.equals("~role_password") ? new ValueField().getValue(key.toUpperCase() + ":") : new PasswordField().getPassword(key.toUpperCase() + ":");
                    command.add(keys[i]);
                    command.add(value);
                }
                catch (IOException ex) {}
            } else if (null == keyValue || "".equals(keyValue.trim()) || keyValue.startsWith("-")) {
                throw new RuntimeException("Missing required value for " + key);
            }
            ++i;
        }
    }

    public static String getApplicationName(Vector command) {
        int ind = command.indexOf("~app");
        if (ind >= 0 && command.size() > ind + 1) {
            return (String)command.elementAt(ind + 1);
        }
        return "";
    }

    public static void printCommand(Vector command) {
        Iterator iter = command.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public static void main(String[] argv) {
        Vector<String> command = new Vector<String>();
        command.add("~app");
        command.add("rk");
        HandlerHelper.loadRequiredParams(command, new String[]{"~password", "port"}, "config");
        Iterator iter = command.iterator();
        while (iter.hasNext()) {
            String elem = (String)iter.next();
            System.out.println(elem + ",");
        }
    }
}

