/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.impl.client;

import com.sun.netstorage.mgmt.ui.cli.Constants;
import com.sun.netstorage.mgmt.ui.cli.impl.client.HandlerHelper;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.client.ClientHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.client.ClientHandlerChain;
import com.sun.netstorage.mgmt.ui.cli.util.PasswordField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CredentialsHandler
implements ClientHandler {
    private static String TEST_LONG_OPT = "--params";
    private static String TEST_SHORT_OPT = "-x";
    private static String PASSWORD = "password";
    private static String PASSWORD_KEY = "password-key";
    private static String TEST_PASSWORD_FILE = Constants.RSR_HOME + File.separator + ".esm-test";
    public static String fileName = Constants.RSR_HOME + File.separator + ".clif-" + "user";
    private static String[] CONFIG_PARAM = new String[]{"~username", "~password", "~rolename", "~role_password"};

    public InputStream execute(Vector command, ClientHandlerChain chain, Hashtable context) throws IOException, CLIException, CLIExecutionException {
        HandlerHelper.loadRequiredParams(command, CONFIG_PARAM, fileName);
        HandlerHelper.promptRequiredParams(command, CONFIG_PARAM);
        this.loadTestPassword(command);
        return chain.execute(command, context);
    }

    private void loadTestPassword(Vector command) throws CLIException {
        int testParamsIndex = -1;
        String testParams = null;
        int a = 0;
        while (a < command.size()) {
            if (TEST_LONG_OPT.equals((String)command.elementAt(a)) || TEST_SHORT_OPT.equals((String)command.elementAt(a))) {
                testParamsIndex = a + 1;
                testParams = (String)command.elementAt(a + 1);
                break;
            }
            ++a;
        }
        Vector v = new Vector();
        String testParameters = null;
        if (null != testParams) {
            StringTokenizer stk = new StringTokenizer(testParams, ",");
            while (stk.hasMoreTokens()) {
                String keyValue;
                block17: {
                    keyValue = stk.nextToken().trim();
                    String key = keyValue.substring(0, keyValue.indexOf("="));
                    String passwdKey = keyValue.substring(keyValue.indexOf("=") + 1);
                    String value = null;
                    if (key.equalsIgnoreCase(PASSWORD)) {
                        throw new CLIException("Please define password by using password-key in: " + TEST_PASSWORD_FILE);
                    }
                    if (key.equals(PASSWORD_KEY)) {
                        Properties props = new Properties();
                        try {
                            props.load(new FileInputStream(TEST_PASSWORD_FILE));
                            value = props.getProperty(passwdKey);
                            if (value != null && !"".equals(value)) {
                                keyValue = PASSWORD + "=" + value;
                                break block17;
                            }
                            System.out.println("No password defined for " + passwdKey + " in " + TEST_PASSWORD_FILE);
                            System.out.println("Please enter password for this test");
                            try {
                                value = new PasswordField().getPassword(PASSWORD + ":");
                                if (value != null && !"".equals(value)) {
                                    keyValue = PASSWORD + "=" + value;
                                    break block17;
                                }
                                throw new CLIException("No password entered for this test");
                            }
                            catch (Exception e) {
                                throw new CLIException(e.getMessage());
                            }
                        }
                        catch (FileNotFoundException fe) {
                            String[] passwd = new String[]{PASSWORD};
                            System.out.println(TEST_PASSWORD_FILE + " was not found. " + "Please enter password for this test");
                            try {
                                value = new PasswordField().getPassword(PASSWORD + ":");
                                if (value != null && !"".equals(value)) {
                                    keyValue = PASSWORD + "=" + value;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new CLIException(e.getMessage());
                            }
                        }
                        catch (Exception e) {
                            throw new CLIException(e.getMessage());
                        }
                    }
                }
                testParameters = null == testParameters ? keyValue : testParameters + ", " + keyValue;
            }
        }
        if (testParamsIndex != -1) {
            command.remove(testParamsIndex);
            command.add(testParamsIndex, testParameters);
        }
    }
}

