/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.impl.client;

import com.sun.netstorage.mgmt.ui.cli.Constants;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.client.CLIMain;
import com.sun.netstorage.mgmt.ui.cli.interfaces.client.ClientHandlerChain;
import com.sun.netstorage.mgmt.ui.cli.util.Localizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class CLIMainImpl
implements CLIMain {
    private static int exitCode = 0;
    public static boolean withDaemon = false;

    public void setBackgroundMode() {
        withDaemon = true;
    }

    public static void setExitCode(int code) {
        exitCode = code;
    }

    public int execute(String[] args) throws IOException, CLIException, CLIExecutionException {
        try {
            if (null == args) {
                throw new RuntimeException(Localizer.getString("no-command-provided"));
            }
            Vector<String> vct = new Vector<String>();
            int i = 0;
            while (i < args.length) {
                vct.addElement(args[i]);
                ++i;
            }
            String chainClazz = "com.sun.netstorage.mgmt.ui.cli.impl.client.ClientChainPipe";
            ClientHandlerChain chc = null;
            chc = (ClientHandlerChain)Class.forName(chainClazz).newInstance();
            InputStream in = chc.execute(vct, null);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            return this.handleException(ex);
        }
        return exitCode;
    }

    private int handleException(Throwable t) {
        String prefix = "\t";
        System.err.print(Localizer.getString("Error-executing-command") + " ");
        System.err.println(t.getMessage());
        if (t.getCause() != null) {
            System.err.println(prefix + "\tCause: " + t.getCause().getClass().getName() + " " + t.getCause().getMessage());
        }
        if (Constants.verbose) {
            t.printStackTrace(System.err);
        }
        System.err.print(Localizer.getString("CLI_SEE_ESM_HELP") + "\n");
        if (!withDaemon) {
            System.exit(9);
        }
        return 9;
    }

    public static void main(String[] args) {
        Localizer.setResource(Localizer.CLIENT_RESOURCE);
        CLIMainImpl cm = new CLIMainImpl();
        Object cause = null;
        try {
            exitCode = cm.execute(args);
        }
        catch (Throwable t) {
            exitCode = cm.handleException(t);
        }
        System.exit(exitCode);
    }
}

