/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.sun.jade.apps.diags.exec.DiagnosticTestService;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ParameterType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.ui.util.Item;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.diagnostics.TestUtil;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import com.sun.netstorage.mgmt.ui.cli.util.IdentityHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;

public class ViewTestHandler
extends SimpleHandler {
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        String resultKey = theSubcommandData.getSingleValueOption("result");
        String testId = theSubcommandData.getSingleValueOption("test-id");
        String idStr = super.getQuery(theSubcommandData);
        if (null == resultKey || "".trim().equals(resultKey)) {
            if (null == idStr || "".trim().equals(idStr) || null == testId || "".trim().equals(testId)) {
                this.reportInvalidArgException("cli.command.syntax.error", "roadking.cli.viewtest.synopsis");
            }
        } else if (null != idStr || null != testId) {
            this.reportInvalidArgException("cli.command.syntax.error", "roadking.cli.viewtest.synopsis");
        }
        if (null != resultKey) {
            this.displayTestResults(resultKey, out);
        } else {
            try {
                DiagnosticTestService service = TestUtil.getDiagService();
                Identity identity = this.getIdentity(theSubcommandData);
                String comp = theSubcommandData.getSingleValueOption("comp");
                if (null != comp) {
                    identity = new Identity(identity, comp, IdentityType.DISPLAY_NAME);
                    identity = IdentityHelper.resovleComponentID(identity);
                }
                if (identity == null) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.device.found", (Locale)this.getLocale()), 9);
                }
                DiagnosticTestInfo testInfo = service.getTestByName(identity, testId, this.getLocale());
                String[][] data = null;
                if (testInfo != null) {
                    int[] cValues = testInfo.getTestCharacteristics();
                    Item[] chars = TestUtil.getTestCharactoriestics((int[])cValues);
                    if (chars != null) {
                        data = new String[2 + chars.length][2];
                        data[0][0] = "test.name";
                        data[1][0] = "table.header.description";
                        data[0][1] = testInfo.getTestName();
                        data[1][1] = testInfo.getTestDescription();
                        int i = 0;
                        while (i < chars.length) {
                            data[i + 2][0] = chars[i].getName();
                            data[i + 2][1] = chars[i].getValue().toString();
                            ++i;
                        }
                    }
                    String[] headers = new String[]{"table.header.name", "table.header.value"};
                    CliPrintHelper.print("page.title.testDetails", null, headers, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    DiagnosticSetting setting = testInfo.getSettingsForTest();
                    Object[] parameters = new TestParameter[setting.getTestParameters().size()];
                    setting.getTestParameters().copyInto(parameters);
                    ArrayList<String[]> singleTestValue = new ArrayList<String[]>();
                    ArrayList<String[][]> mutiTestValues = new ArrayList<String[][]>();
                    int i = 0;
                    while (i < parameters.length) {
                        ParameterType parameterType = parameters[i].getParameterType();
                        String displayName = parameters[i].getDisplayName();
                        String name = parameters[i].getName();
                        Object value = parameters[i].getDefaultValue();
                        String[][] testData = null;
                        if (value instanceof String && parameterType.equals((Object)ParameterType.PASSWORD)) {
                            String[] passwordValue = new String[]{displayName, name, "<password>"};
                            singleTestValue.add(passwordValue);
                        } else if (value instanceof String) {
                            if (parameters[i].getValidValues() == null) {
                                String[] singleValue = new String[]{displayName, name, (String)value};
                                singleTestValue.add(singleValue);
                            } else {
                                Object[] objs = parameters[i].getValidValues();
                                if (null != objs) {
                                    testData = new String[objs.length][3];
                                    testData[0][0] = displayName;
                                    testData[0][1] = name;
                                    testData[0][2] = value == null ? "" : (String)value;
                                    int j = 0;
                                    while (j < objs.length - 1) {
                                        if (!objs[j + 1].equals(value)) {
                                            testData[j + 1][0] = " ";
                                            testData[j + 1][1] = " ";
                                            testData[j + 1][2] = objs[j + 1] == null ? " " : (String)objs[j + 1];
                                        }
                                        ++j;
                                    }
                                    mutiTestValues.add(testData);
                                }
                            }
                        } else if (value instanceof Boolean) {
                            Boolean flag = (Boolean)value;
                            if (flag.booleanValue()) {
                                testData = new String[2][3];
                                testData[0][0] = displayName;
                                testData[0][1] = name;
                                testData[0][2] = value.toString();
                                testData[1][0] = "";
                                testData[1][1] = "";
                                testData[1][2] = "false";
                            } else {
                                testData = new String[2][3];
                                testData[0][0] = displayName;
                                testData[0][1] = name;
                                testData[0][2] = value.toString();
                                testData[1][0] = "";
                                testData[1][1] = "";
                                testData[1][2] = "true";
                            }
                            mutiTestValues.add(testData);
                        }
                        ++i;
                    }
                    String[] paramHeading = new String[]{"table.header.name", "test.param.key", "test.param.value"};
                    if (singleTestValue.size() > 0) {
                        String[][] singleTest = (String[][])singleTestValue.toArray((T[])new String[singleTestValue.size()][]);
                        String title = "test.required.value";
                        out.println();
                        CliPrintHelper.print(title, null, paramHeading, singleTest, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    }
                    if (null != mutiTestValues && mutiTestValues.size() > 0) {
                        out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"test.required.values", (Locale)this.getLocale()));
                        int i2 = 0;
                        while (i2 < mutiTestValues.size()) {
                            out.println();
                            String[][] selectiveParams = (String[][])mutiTestValues.get(i2);
                            CliPrintHelper.print(null, paramHeading, selectiveParams, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages") : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                            ++i2;
                        }
                    }
                } else {
                    out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.test.found", (Locale)this.getLocale()));
                }
            }
            catch (Exception e) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.test.found", (Locale)this.getLocale()), e.getCause(), 9);
            }
        }
        return 0;
    }

    private void displayTestResults(String testKey, PrintWriter out) throws CLIExecutionException {
        try {
            DiagnosticTestService service = TestUtil.getDiagService();
            DiagnosticResult result = service.getInSessionDiagnosticResult(testKey.toString());
            if (result == null) {
                result = service.getDiagnosticResult(testKey.toString());
            }
            if (result != null) {
                String[][] data = new String[7][2];
                data[0][0] = "test.name";
                data[1][0] = "table.header.startTime";
                data[2][0] = "table.header.completionTime";
                data[3][0] = "table.header.lastUpdateTime";
                data[4][0] = "table.header.inSuit";
                data[5][0] = "table.header.percentageComplete";
                data[6][0] = "table.header.status";
                data[0][1] = result.getDiagnosticName();
                data[1][1] = result.getTestStartTime() == null ? "" : result.getTestStartTime().getCalendar().getTime().toString();
                data[2][1] = result.getTestCompletionTime() == null ? "" : result.getTestCompletionTime().getCalendar().getTime().toString();
                data[3][1] = result.getTimeStamp() == null ? "" : result.getTimeStamp().getCalendar().getTime().toString();
                data[4][1] = String.valueOf(result.getIsPackageValue());
                data[5][1] = result.getPercentComplete().toString();
                data[6][1] = result.getLocalizedTestState(this.getLocale());
                String[] headers = new String[]{"table.header.name", "table.header.value"};
                CliPrintHelper.print("table.header.status", null, headers, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                String[] results = result.getTestResults();
                String[][] resultData = new String[results.length][1];
                int i = 0;
                while (i < results.length) {
                    resultData[i][0] = results[i];
                    ++i;
                }
                String[] resultHeaders = new String[]{"table.header.result"};
                CliPrintHelper.print("table.title.testResult", null, resultHeaders, resultData, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
            } else {
                out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.test.result.found", (Locale)this.getLocale()));
            }
        }
        catch (Exception e) {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ViewTestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.test.result.found", (Locale)this.getLocale()), e.getCause(), 9);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

