/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.sun.jade.apps.diags.exec.DiagnosticTestService;
import com.sun.jade.apps.diags.lib.DiagnosticTestInfo;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.mse.ElementKey;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.diagnostics.Converter;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.diagnostics.NotInRangeException;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.diagnostics.TestUtil;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.util.IdentityHelper;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.StringTokenizer;

public class TestHandler
extends SimpleHandler {
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        String testParams = theSubcommandData.getSingleValueOption("params");
        String testId = theSubcommandData.getSingleValueOption("test-id");
        try {
            DiagnosticTestInfo testInfo;
            DiagnosticTestService service = TestUtil.getDiagService();
            Identity identity = this.getIdentity(theSubcommandData);
            String comp = theSubcommandData.getSingleValueOption("comp");
            if (null != comp) {
                identity = new Identity(identity, comp, IdentityType.DISPLAY_NAME);
                identity = IdentityHelper.resovleComponentID(identity);
            }
            if ((testInfo = service.getTestByName(identity, testId, this.getLocale())) != null) {
                DiagnosticSetting setting = testInfo.getSettingsForTest();
                Object[] parameters = new TestParameter[setting.getTestParameters().size()];
                setting.getTestParameters().copyInto(parameters);
                StringTokenizer stk = new StringTokenizer(testParams, ",");
                while (stk.hasMoreTokens()) {
                    String keyValue = stk.nextToken().trim();
                    if (keyValue.indexOf("=") == -1) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = TestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.test.params", (Object[])new String[]{keyValue}, (Locale)this.getLocale()), 1);
                    }
                    String key = keyValue.substring(0, keyValue.indexOf("="));
                    String value = keyValue.substring(keyValue.indexOf("=") + 1);
                    boolean found = false;
                    int i = 0;
                    while (i < parameters.length) {
                        if (parameters[i].getName().equalsIgnoreCase(key) && value != null) {
                            found = true;
                            try {
                                Object obj = Converter.getValue((TestParameter)parameters[i], (String)value);
                                parameters[i].setCurrentValue(obj);
                            }
                            catch (NotInRangeException ex) {
                                out.println(" error: " + parameters[i].getDisplayName() + " not in range" + ex.getMin() + " " + ex.getMax());
                                throw new CLIExecutionException(ex.getMessage(), ex.getCause(), 9);
                            }
                            catch (NumberFormatException ex) {
                                out.println("error: " + parameters[i].getDisplayName() + " not valid");
                                throw new CLIExecutionException(ex.getMessage(), ex.getCause(), 9);
                            }
                        }
                        ++i;
                    }
                    if (found) continue;
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = TestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"test.key.invalid", (Object[])new String[]{key}, (Locale)this.getLocale()), 9);
                }
            }
            String user = theSubcommandData.getUserName();
            String userSessionID = service.openSession(user, null, this.getLocale());
            ElementKey testKey = service.submitTest(userSessionID, testInfo, identity);
            out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = TestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"test.is.running", (Object[])new String[]{testKey.toString()}, (Locale)this.getLocale()));
        }
        catch (NullPointerException e) {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = TestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"test.not.running", (Locale)this.getLocale()), 9);
        }
        catch (Exception e) {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = TestHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"test.not.running", (Locale)this.getLocale()), 9);
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

