/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.iplanet.jato.model.DefaultModel;
import com.sun.jade.apps.diags.exec.DiagnosticTestService;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService;
import com.sun.netstorage.mgmt.esm.logic.service.api.ServiceLocator;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.diagnostics.DiagnosticsDataHelper;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.diagnostics.TestUtil;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.job.DiscoveryJobDataHelper;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class ListJobsHandler
extends SimpleHandler {
    private static final String DISCOVERY_TYPE = "discovery";
    private static final String TEST_TYPE = "test";
    private static final String ARCHIVED_TEST = "test-archives";
    private static final String PAGE_OPTION = "page";
    private static final String ROW_OPTION = "row";
    private static final String MAX_ROWS = "25";
    private static final int MAX_ROW_NUM = 100;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        block30: {
            super.execute(theSubcommandData, out);
            String type = theSubcommandData.getSingleValueOption("type");
            String page = theSubcommandData.getSingleValueOption(PAGE_OPTION);
            String Row = theSubcommandData.getSingleValueOption(ROW_OPTION);
            try {
                if (type.equals(DISCOVERY_TYPE)) {
                    if (null != page) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.option", (Object[])new String[]{PAGE_OPTION}), 1);
                    }
                    if (null != Row) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.option", (Object[])new String[]{ROW_OPTION}), 1);
                    }
                    DiscoveryService svc = null;
                    svc = (DiscoveryService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService == null ? (class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService = ListJobsHandler.class$("com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService")) : class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService));
                    DiscoveryJobDataHelper helper = new DiscoveryJobDataHelper(svc, this.getLocale());
                    Map tasks = helper.getCurrentDiscoveries();
                    if (tasks == null || tasks.size() == 0) {
                        return this.reportNoData(out, "cli.listjobs.no.discovery.jobs.found");
                    }
                    String[][] data = new String[tasks.size()][3];
                    int row = 0;
                    Iterator ite = tasks.keySet().iterator();
                    while (ite.hasNext()) {
                        Map task = (Map)tasks.get(ite.next());
                        data[row][0] = (String)task.get("discovery.range");
                        data[row][1] = (String)task.get("discovery.started");
                        data[row][2] = (String)task.get("discovery.progress");
                        ++row;
                    }
                    String[] headers = new String[]{"discovery.task.range", "discovery.task.start", "discovery.task.progress"};
                    CliPrintHelper.print("admin.discovery.running.table.title", null, headers, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    break block30;
                }
                if (type.equals(TEST_TYPE)) {
                    if (null != page) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.option", (Object[])new String[]{PAGE_OPTION}), 1);
                    }
                    if (null != Row) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.option", (Object[])new String[]{ROW_OPTION}), 1);
                    }
                    DiagnosticTestService service = TestUtil.getDiagService();
                    DiagnosticResult[] drs = service.getInSessionDiagnosticResults();
                    if (drs == null || drs.length == 0) {
                        return this.reportNoData(out, "cli.listjobs.no.running.tests.found");
                    }
                    String[][] data = new String[drs.length][4];
                    int i = 0;
                    while (i < drs.length) {
                        data[i][0] = drs[i].getDiagnosticName();
                        data[i][1] = drs[i].getUserID();
                        data[i][2] = drs[i].getTestStartTime() == null ? "" : drs[i].getTestStartTime().getCalendar().getTime().toString();
                        data[i][3] = drs[i].getPercentComplete() + "%";
                        ++i;
                    }
                    String[] headers = new String[]{"test.name", "table.header.userName", "table.header.startTime", "table.header.percentageComplete"};
                    CliPrintHelper.print("page.title.runningTestList", null, headers, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    break block30;
                }
                if (type.equals(ARCHIVED_TEST)) {
                    DefaultModel model = new DefaultModel();
                    ArrayList al = new ArrayList();
                    Properties p = new Properties();
                    Locale locale = super.getLocale();
                    String user = null;
                    int pageNumber = 1;
                    if (null != page) {
                        try {
                            pageNumber = Integer.parseInt(page);
                            p.setProperty("currentPage", page);
                        }
                        catch (NumberFormatException e) {
                            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.page.number", (Object[])new String[]{"listjobs"}, (Locale)this.getLocale()), 9);
                        }
                    } else {
                        p.setProperty("currentPage", "1");
                    }
                    if (null != Row) {
                        try {
                            int rowNumber = Integer.parseInt(Row);
                            if (rowNumber > 100) {
                                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.row.number", (Object[])new String[]{"listjobs"}, (Locale)this.getLocale()), 9);
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.row.number", (Object[])new String[]{"listjobs"}, (Locale)this.getLocale()), 9);
                        }
                        p.setProperty("maxRows", Row);
                    } else {
                        p.setProperty("maxRows", MAX_ROWS);
                    }
                    DiagnosticsDataHelper diagHelper = new DiagnosticsDataHelper();
                    try {
                        diagHelper.populateArchivedTestsTableModel(model, locale, al, p, user);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
                    }
                    ArrayList<String[]> testList = new ArrayList<String[]>();
                    String totalCounts = p.getProperty("recordNumber");
                    String currentPage = p.getProperty("currentPage");
                    String rowNumber = "";
                    rowNumber = Row != null ? Row : MAX_ROWS;
                    double totalNumber = new Integer(totalCounts).doubleValue() / new Integer(rowNumber).doubleValue() + 0.9999;
                    int totalPageNumber = new Double(totalNumber).intValue();
                    try {
                        model.beforeFirst();
                        while (model.next()) {
                            String testName = (String)model.getValue("testNameStr");
                            String testKey = (String)model.getValue("useRuntime.TestKey");
                            String startTime = (String)model.getValue("startTimeStr");
                            String userName = (String)model.getValue("userNameStr");
                            String completionTime = (String)model.getValue("completionTimeStr");
                            String[] testData = new String[]{testName, testKey, userName, startTime, completionTime};
                            testList.add(testData);
                        }
                    }
                    catch (Exception e) {
                        throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
                    }
                    String[][] data = (String[][])testList.toArray((T[])new String[testList.size()][]);
                    if (data.length == 0) {
                        return this.reportNoData(out, "archived.test.list.not.found");
                    }
                    String[] heading = new String[]{"test.name", "test.key", "test.user", "test.start.time", "test.completion.time"};
                    String title = "cli.title.test.list.summary";
                    String[] titleArgs = new String[]{totalCounts, new Integer(totalPageNumber).toString(), currentPage};
                    CliPrintHelper.print(title, titleArgs, heading, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    break block30;
                }
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListJobsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.type", (Object[])new String[]{type}), 1);
            }
            catch (CLIException ce) {
                throw ce;
            }
            catch (CLIExecutionException cee) {
                throw cee;
            }
            catch (Exception e) {
                throw new CLIExecutionException(e.getMessage(), e, 9);
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

