/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.esm.logic.event.api.EventPersistenceService;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.EventUtil;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.EventsDataHelper;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandHandler;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ListEventsHandler
extends SimpleHandler
implements SubcommandHandler {
    private static final String MAX_ROWS = "25";
    private static final int MAX_ROW_NUM = 100;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        String row = theSubcommandData.getSingleValueOption("row");
        String page = theSubcommandData.getSingleValueOption("page");
        String filter = theSubcommandData.getSingleValueOption("filter");
        String sort = theSubcommandData.getSingleValueOption("sort");
        String scope = theSubcommandData.getSingleValueOption("scope");
        Identity scopeIdentity = null;
        if (scope == null) {
            scope = "SAN";
            scopeIdentity = new Identity("", IdentityType.SAN);
        } else {
            scopeIdentity = new Identity(scope, IdentityType.GUID);
        }
        String idStr = super.getIdentityStr(theSubcommandData);
        DefaultModel model = new DefaultModel();
        ArrayList al = new ArrayList();
        Properties p = new Properties();
        Locale locale = super.getLocale();
        if (null != page) {
            try {
                int pageNumber = Integer.parseInt(page);
            }
            catch (NumberFormatException e) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.page.number", (Object[])new String[]{"listevents"}, (Locale)this.getLocale()), 9);
            }
            p.setProperty("currentPage", page);
        } else {
            p.setProperty("currentPage", "1");
        }
        if (null != row) {
            try {
                int rowNumber = Integer.parseInt(row);
                if (rowNumber > 100 || rowNumber < 1) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.row.number", (Object[])new String[]{"listevents"}, (Locale)this.getLocale()), 9);
                }
            }
            catch (NumberFormatException e) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.row.number", (Object[])new String[]{"listevents"}, (Locale)this.getLocale()), 9);
            }
            p.setProperty("maxRows", row);
        } else {
            p.setProperty("maxRows", MAX_ROWS);
        }
        p.setProperty("severity", "all");
        p.setProperty("state", "all");
        p.setProperty("scopeID", scopeIdentity.toCondensedString());
        p.setProperty("PrimarySortNameHiddenField", "timeStr");
        p.setProperty("PrimarySortOrderHiddenField", "descending");
        if (filter != null) {
            this.setFilter(filter, p);
        }
        if (sort != null) {
            this.setSort(sort, p);
        }
        if (null != idStr) {
            p.setProperty("deviceID", idStr);
        }
        EventsDataHelper eventData = new EventsDataHelper();
        try {
            eventData.populateEventsTableModel(model, p, al, locale);
        }
        catch (Exception e) {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.event.retrieved", (Object[])new String[]{super.getQuery(theSubcommandData)}, (Locale)this.getLocale()), e.getCause(), 9);
        }
        ArrayList<String[]> eventList = new ArrayList<String[]>();
        String totalCounts = p.getProperty("recordNumber");
        String currentPage = p.getProperty("currentPage");
        String rowNumber = "";
        rowNumber = row != null ? row : MAX_ROWS;
        int totalPageNumber = (new Integer(totalCounts) - 1) / new Integer(rowNumber) + 1;
        try {
            model.beforeFirst();
            while (model.next()) {
                String eventID = (String)model.getValue("eventID");
                String timeStr = (String)model.getValue("timeStr");
                String name = (String)model.getValue("deviceNameStr");
                String type = (String)model.getValue("deviceTypeStr");
                String topic = (String)model.getValue("topicStr");
                String device = (String)model.getValue("parentNameStr");
                String[] theEvents = new String[]{eventID, timeStr, topic, name, type, device};
                eventList.add(theEvents);
            }
        }
        catch (Exception e) {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.event.retrieved", (Object[])new String[]{super.getQuery(theSubcommandData)}, (Locale)this.getLocale()), e.getCause(), 9);
        }
        String[][] data = (String[][])eventList.toArray((T[])new String[eventList.size()][]);
        String[] heading = new String[]{"cli.title.event.id", "cli.title.time", "cli.title.topic", "element.name", "element.type", "parent.name"};
        String title = "cli.title.event.summary";
        String[] titleArgs = new String[]{totalCounts, new Integer(totalPageNumber).toString(), currentPage};
        if (null == data || data.length < 1) {
            return this.reportNoData(out, "cli.no.event.found");
        }
        CliPrintHelper.print(title, titleArgs, heading, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
        return 0;
    }

    private void setFilter(String filter, Properties p) throws CLIExecutionException {
        StringTokenizer stk = new StringTokenizer(filter, ",");
        while (stk.hasMoreTokens()) {
            String keyValue = stk.nextToken().trim();
            if (keyValue.indexOf("=") == -1) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.key.incorrect", (Object[])new String[]{keyValue}, (Locale)this.getLocale()), 1);
            }
            String key = keyValue.substring(0, keyValue.indexOf("=")).trim();
            String value = keyValue.substring(keyValue.indexOf("=") + 1).trim();
            if (key.equalsIgnoreCase("event")) {
                Map typesMap = null;
                EventPersistenceService eps = null;
                try {
                    eps = EventUtil.getEventService();
                }
                catch (Exception ex) {
                    throw new CLIExecutionException("get exception when connected to event persistence service", ex, 9);
                }
                if (eps == null) {
                    throw new CLIExecutionException("event persistence service not found.", 9);
                }
                try {
                    typesMap = eps.getEventTypes(this.getLocale());
                }
                catch (Exception ex) {
                    throw new CLIExecutionException("get exception when working with event persistence service", ex, 9);
                }
                if (typesMap == null) {
                    throw new CLIExecutionException("get null return from event persistence service", 9);
                }
                String[] mapKeys = new String[typesMap.keySet().size()];
                typesMap.keySet().toArray(mapKeys);
                if (null != value && value.equalsIgnoreCase("all")) {
                    p.setProperty("topic", "all");
                    continue;
                }
                if (null != value) {
                    String filterKey = null;
                    int i = 0;
                    while (i < mapKeys.length) {
                        String mapKey = mapKeys[i];
                        String mapValue = (String)typesMap.get(mapKey);
                        if (value.equalsIgnoreCase(mapValue)) {
                            filterKey = mapKey;
                            break;
                        }
                        ++i;
                    }
                    if (null != filterKey) {
                        p.setProperty("topic", filterKey);
                        continue;
                    }
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.value.incorrect", (Object[])new String[]{value, key}, (Locale)this.getLocale()), 1);
                }
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.value.incorrect", (Object[])new String[]{value, key}, (Locale)this.getLocale()), 1);
            }
            if (key.equalsIgnoreCase("device")) {
                if (null != value && value.equalsIgnoreCase("all")) {
                    p.setProperty("deviceType", "all");
                    continue;
                }
                if (null != value && value.equalsIgnoreCase("Array")) {
                    p.setProperty("deviceType", "array");
                    continue;
                }
                if (null != value && value.equalsIgnoreCase("Host")) {
                    p.setProperty("deviceType", "host");
                    continue;
                }
                if (null != value && value.equalsIgnoreCase("Switch")) {
                    p.setProperty("deviceType", "switch");
                    continue;
                }
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.value.incorrect", (Object[])new String[]{value, key}, (Locale)this.getLocale()), 1);
            }
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.key.incorrect", (Object[])new String[]{key}, (Locale)this.getLocale()), 1);
        }
    }

    private String getSortValue(String sortValue) throws CLIExecutionException {
        String sort = null;
        if (null == sortValue) {
            return null;
        }
        if (sortValue.equalsIgnoreCase("Time")) {
            sort = "timeStr";
        } else if (sortValue.equalsIgnoreCase("Topic")) {
            sort = "topicStr";
        } else if (sortValue.equalsIgnoreCase("Element Name")) {
            sort = "deviceNameStr";
        } else if (sortValue.equalsIgnoreCase("Element Type")) {
            sort = "deviceTypeStr";
        } else if (sortValue.equalsIgnoreCase("Parent Name")) {
            sort = "parentNameStr";
        } else {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"sort.key.incorrect", (Object[])new String[]{sortValue}, (Locale)this.getLocale()), 1);
        }
        return sort;
    }

    private void setSort(String filter, Properties p) throws CLIExecutionException {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(filter, ",");
        while (stk.hasMoreTokens()) {
            String keyValue = stk.nextToken().trim();
            if (keyValue.indexOf("=") == -1) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.key.incorrect", (Object[])new String[]{keyValue}, (Locale)this.getLocale()), 1);
            }
            al.add(keyValue);
        }
        String[] sortData = al.toArray(new String[al.size()]);
        int i = 0;
        while (i < sortData.length) {
            String key = sortData[i].substring(0, sortData[i].indexOf("=")).trim();
            String value = sortData[i].substring(sortData[i].indexOf("=") + 1).trim();
            String sortDirection = "";
            if (value.equalsIgnoreCase("ascending")) {
                sortDirection = "ascending";
            } else if (value.equalsIgnoreCase("descending")) {
                sortDirection = "descending";
            } else {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"sort.value.incorrect", (Object[])new String[]{value}, (Locale)this.getLocale()), 1);
            }
            String sortValue = this.getSortValue(key);
            if (null == key) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListEventsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"sort.value.incorrect", (Object[])new String[]{value}, (Locale)this.getLocale()), 1);
            }
            if (i == 0) {
                p.setProperty("PrimarySortNameHiddenField", sortValue);
                p.setProperty("PrimarySortOrderHiddenField", sortDirection);
            } else if (i == 1) {
                p.setProperty("SecondarySortNameHiddenField", sortValue);
                p.setProperty("SecondarySortOrderHiddenField", sortDirection);
            } else if (i == 2) {
                p.setProperty("AdvancedSortNameHiddenField", sortValue);
                p.setProperty("AdvancedSortOrderHiddenField", sortDirection);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

