/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmCountSummary;
import com.sun.netstorage.mgmt.esm.logic.asset.api.AssetService;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceFlavor;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.logic.service.api.ElementDetails;
import com.sun.netstorage.mgmt.esm.logic.service.api.ElementSummary;
import com.sun.netstorage.mgmt.esm.logic.service.api.ServiceLocator;
import com.sun.netstorage.mgmt.esm.util.domain.Capacity;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.Property;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandHandler;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import com.sun.netstorage.mgmt.ui.cli.util.IdentityHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;

public class ListCompsHandler
extends SimpleHandler
implements SubcommandHandler {
    private static final String theSubComponentType_ARRAY = "StorEdgeT3_LogicalDisk";
    private static final String theSubComponentType_HOST = "StorAdeHBA_TargetMap";
    String theSubComponentType = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        String idStr = this.getIdentityStr(theSubcommandData);
        Boolean volume = theSubcommandData.getBooleanOption("volume");
        Identity identity = this.getIdentity(theSubcommandData);
        String comp = theSubcommandData.getSingleValueOption("comp");
        if (null != comp) {
            if (null != volume) {
                this.reportInvalidArgException("cli.command.syntax.error", "roadking.cli.listcomps.synopsis");
            } else {
                identity = new Identity(identity, comp, IdentityType.DISPLAY_NAME);
            }
        }
        if (null != volume) {
            try {
                identity = IdentityHelper.resovleComponentID(identity);
                AssetService assetService = (AssetService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService == null ? (class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService = ListCompsHandler.class$("com.sun.netstorage.mgmt.esm.logic.asset.api.AssetService")) : class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService));
                ElementSummary[] allFrus = this.getSubList(assetService, identity, null);
                ArrayList al = new ArrayList();
                this.getVolList(assetService, allFrus, al);
                String[][] listData = (String[][])al.toArray((T[])new String[al.size()][]);
                String title = "cli.title.vol.report";
                String[] heading = new String[]{"cli.title.volume.id", "capacity", "cli.title.alarm", "device.path"};
                if (null == listData || listData.length < 1) {
                    return this.reportNoData(out, "cli.no.vol.found");
                }
                CliPrintHelper.print(title, heading, listData, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListCompsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
            }
            catch (CLIExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
            }
        }
        try {
            identity = IdentityHelper.resovleComponentID(identity);
            AssetService assetService = (AssetService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService == null ? (class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService = ListCompsHandler.class$("com.sun.netstorage.mgmt.esm.logic.asset.api.AssetService")) : class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService));
            ElementSummary[] allFrus = this.getSubList(assetService, identity, comp);
            if (allFrus != null) {
                ArrayList<String[]> al = new ArrayList<String[]>();
                int j = 0;
                while (j < allFrus.length) {
                    ElementSummary specificFru = allFrus[j];
                    if (specificFru != null) {
                        Property[] fp = specificFru.getProperties().toArray();
                        if (fp == null) {
                            throw new CLIExecutionException("cli.no.subcomponent.list", 9);
                        }
                        ElementDetails ed = assetService.getComponentDetails(specificFru.getIdentity());
                        long assetDownAlarms = 0L;
                        long assetCriticalAlarms = 0L;
                        long assetMajorAlarms = 0L;
                        long assetMinorAlarms = 0L;
                        AlarmCountSummary acs = ed.getAlarmCounts();
                        assetDownAlarms = acs.getDown();
                        assetCriticalAlarms = acs.getCritical();
                        assetMajorAlarms = acs.getMajor();
                        assetMinorAlarms = acs.getMinor();
                        String alarm = assetDownAlarms + "/" + assetCriticalAlarms + "/" + assetMajorAlarms + "/" + assetMinorAlarms;
                        String[] subList = new String[]{fp[0].getCanonicalName(), fp[0].getLocalizedName(), alarm, fp[0].getLocalizedValue()};
                        al.add(subList);
                    }
                    ++j;
                }
                String[][] listData = (String[][])al.toArray((T[])new String[al.size()][]);
                String title = "cli.title.sub.report";
                String[] heading = new String[]{"cli.head.name", "cli.head.type", "cli.title.alarm", "cli.head.sub.id"};
                if (null == listData || listData.length < 1) {
                    return this.reportNoData(out, "cli.no.asset.found");
                }
                CliPrintHelper.print(title, heading, listData, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListCompsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListCompsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.device.found", (Locale)this.getLocale()), e.getCause(), 2);
        }
        return 0;
    }

    protected ElementSummary[] getSubList(AssetService assetService, Identity identity, String comp) throws CLIExecutionException, Exception {
        Identity theIdentity = identity;
        ArrayList selectedSpecificFrus = new ArrayList();
        ElementDetails subList = null;
        try {
            if (comp != null) {
                subList = assetService.getComponentDetails(theIdentity);
            } else {
                subList = assetService.getAssetDetails(theIdentity);
                DeviceFlavor df = (DeviceFlavor)subList.getElementType().getFlavor();
                if (df.equals((Object)DeviceFlavor.ARRAY)) {
                    this.theSubComponentType = theSubComponentType_ARRAY;
                } else if (df.equals((Object)DeviceFlavor.HOST)) {
                    this.theSubComponentType = theSubComponentType_HOST;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (subList == null) {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListCompsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.asset.found", (Locale)this.getLocale()), 2);
        }
        ElementSummary[] physicalComponents = subList.getPhysicalComponents();
        ElementSummary[] logicalComponents = subList.getLogicalComponents();
        ElementSummary[] subListSummary = new ElementSummary[]{};
        if (physicalComponents == null) {
            subListSummary = logicalComponents;
        } else if (logicalComponents == null) {
            subListSummary = physicalComponents;
        } else if (physicalComponents == null && logicalComponents == null) {
            subListSummary = null;
        } else {
            subListSummary = new ElementSummary[physicalComponents.length + logicalComponents.length];
            int index = 0;
            while (index < physicalComponents.length) {
                subListSummary[index] = physicalComponents[index];
                ++index;
            }
            int count = 0;
            while (count < logicalComponents.length) {
                subListSummary[physicalComponents.length + count] = logicalComponents[count];
                ++count;
            }
        }
        return subListSummary;
    }

    private void getVolList(AssetService assetService, ElementSummary[] subListSummary, ArrayList al) throws CLIExecutionException, Exception {
        if (null == this.theSubComponentType) {
            throw new CLIExecutionException("Unknown device type for volume listing", 9);
        }
        if (subListSummary != null) {
            int j = 0;
            while (j < subListSummary.length) {
                ElementSummary specificVolume = subListSummary[j];
                if (specificVolume != null) {
                    Property[] fp = specificVolume.getProperties().toArray();
                    if (fp == null) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListCompsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.vol.found", (Locale)this.getLocale()), 2);
                    }
                    int m = 0;
                    while (m < fp.length) {
                        if (fp[m].getCanonicalName() == null || fp[m].getCanonicalName().equals("")) {
                            throw new Exception("VolumeDataHelper:getSpecificVolumeSummaries:fp[m].getCanonicalName() is null");
                        }
                        if (this.theSubComponentType.equals(fp[m].getCanonicalName())) {
                            ElementDetails ed = assetService.getComponentDetails(specificVolume.getIdentity());
                            if (ed == null) {
                                throw new Exception("Volume identity is null: getSpecificVolumeSummaries(...)");
                            }
                            long assetDownAlarms = 0L;
                            long assetCriticalAlarms = 0L;
                            long assetMajorAlarms = 0L;
                            long assetMinorAlarms = 0L;
                            AlarmCountSummary acs = ed.getAlarmCounts();
                            assetDownAlarms = acs.getDown();
                            assetCriticalAlarms = acs.getCritical();
                            assetMajorAlarms = acs.getMajor();
                            assetMinorAlarms = acs.getMinor();
                            String alarm = assetDownAlarms + "/" + assetCriticalAlarms + "/" + assetMajorAlarms + "/" + assetMinorAlarms;
                            if (fp[m].getLocalizedName() == null || fp[m].getLocalizedName().equals("")) {
                                throw new Exception("VolumeDataHelper:getSpecificVolumeSummaries:fp[m].getLocalizedName() is null");
                            }
                            Property[] columnInfo = specificVolume.getProperties().toArray();
                            int a = 0;
                            while (a < columnInfo.length) {
                                ++a;
                            }
                            String volume_id = "";
                            String device_path = "";
                            String block_size = "";
                            String number_of_blocks = "";
                            int prop = 0;
                            while (prop < columnInfo.length) {
                                if ("volume.uniqueID".toString().equals(columnInfo[prop].getCanonicalName())) {
                                    volume_id = columnInfo[prop].getLocalizedValue();
                                } else if ("volume.osDeviceName".toString().equals(columnInfo[prop].getCanonicalName())) {
                                    device_path = columnInfo[prop].getLocalizedValue();
                                } else if ("volume.blockSize".toString().equals(columnInfo[prop].getCanonicalName())) {
                                    block_size = columnInfo[prop].getLocalizedValue();
                                } else if ("volume.nbrBlocks".toString().equals(columnInfo[prop].getCanonicalName())) {
                                    number_of_blocks = columnInfo[prop].getLocalizedValue();
                                    StringBuffer withoutColumn = new StringBuffer(number_of_blocks);
                                    int size = 0;
                                    while (size < withoutColumn.length()) {
                                        char charat = withoutColumn.charAt(size);
                                        if (charat == ',') {
                                            withoutColumn.deleteCharAt(size);
                                            size = 0;
                                        }
                                        ++size;
                                    }
                                    number_of_blocks = withoutColumn.toString();
                                }
                                ++prop;
                            }
                            long capacity = 0L;
                            boolean trueCapacity = false;
                            if (block_size != null && !block_size.equals("") && number_of_blocks != null && !number_of_blocks.equals("")) {
                                long arg1 = Long.parseLong(block_size);
                                long arg2 = Long.parseLong(number_of_blocks);
                                capacity = Capacity.getCapacityMB((long)Long.parseLong(block_size), (long)Long.parseLong(number_of_blocks));
                                trueCapacity = true;
                            }
                            String calculatedCapacity = "";
                            if (trueCapacity) {
                                calculatedCapacity = capacity + "";
                            }
                            String[] volumeList = new String[]{fp[m].getLocalizedValue(), calculatedCapacity, alarm, device_path};
                            al.add(volumeList);
                        }
                        ++m;
                    }
                }
                ++j;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

