/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmCountSummary;
import com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmService;
import com.sun.netstorage.mgmt.esm.logic.asset.api.AssetException;
import com.sun.netstorage.mgmt.esm.logic.asset.api.AssetQuery;
import com.sun.netstorage.mgmt.esm.logic.asset.api.AssetService;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceFlavor;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.logic.service.api.ElementSummary;
import com.sun.netstorage.mgmt.esm.logic.service.api.ServiceLocator;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.reports.AssetTableDataHelper;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.Property;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandHandler;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class ListAssetsHandler
extends SimpleHandler
implements SubcommandHandler {
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$alarmservice$api$AlarmService;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        String type = theSubcommandData.getSingleValueOption("type");
        String scope = theSubcommandData.getSingleValueOption("scope");
        if (type == null && super.getQuery(theSubcommandData) != null) {
            this.reportInvalidArgException("cli.command.syntax.error", "roadking.cli.listassets.synopsis");
        }
        if (scope == null) {
            scope = "SAN";
        }
        if (null != type) {
            if (type.equalsIgnoreCase("Storage")) {
                type = "Array";
            } else if (!(type.equalsIgnoreCase("Host") || type.equalsIgnoreCase("HBA") || type.equalsIgnoreCase("Switch"))) {
                this.reportInvalidArgException("cli.command.asset.type.error", "roadking.cli.listassets.synopsis");
            }
            DeviceFlavor typeId = DeviceFlavor.getInstance((String)type);
            if (null == typeId) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.error.unknown.device", (Locale)this.getLocale()), 2);
            }
            String pattern = this.getQuery(theSubcommandData);
            this.listAssetsByType(scope, typeId, pattern, out);
        } else {
            this.listAllAssets(scope, out);
        }
        return 0;
    }

    private void listAllAssets(String scope, PrintWriter out) throws CLIExecutionException, CLIException {
        block55: {
            AlarmService alarmService = null;
            try {
                alarmService = (AlarmService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$alarmservice$api$AlarmService == null ? (class$com$sun$netstorage$mgmt$esm$logic$alarmservice$api$AlarmService = ListAssetsHandler.class$("com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmService")) : class$com$sun$netstorage$mgmt$esm$logic$alarmservice$api$AlarmService));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
            }
            AssetService assetService = null;
            try {
                assetService = (AssetService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService == null ? (class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService = ListAssetsHandler.class$("com.sun.netstorage.mgmt.esm.logic.asset.api.AssetService")) : class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
            }
            if (null == alarmService) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.alarm.found", (Locale)this.getLocale()), 9);
            }
            if (null == assetService) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.asset.found", (Locale)this.getLocale()), 9);
            }
            try {
                Identity scopeId = null;
                scopeId = scope.equals("SAN") ? new Identity("", IdentityType.SAN) : new Identity(scope, IdentityType.GUID);
                ElementSummary[] allAssets = assetService.getAssets(scopeId);
                if (allAssets != null) {
                    ArrayList<String[]> al = new ArrayList<String[]>();
                    long assetDownAlarms = 0L;
                    long assetCriticalAlarms = 0L;
                    long assetMajorAlarms = 0L;
                    long assetMinorAlarms = 0L;
                    int arrayCount = 0;
                    int switchCount = 0;
                    int hostCount = 0;
                    int hbaCount = 0;
                    int n = 0;
                    while (n < allAssets.length) {
                        Identity assetId = allAssets[n].getIdentity();
                        String monitorStatus = "";
                        monitorStatus = assetService.isAssetMonitor(assetId) ? "cli.monitor.on" : "cli.monitor.off";
                        AlarmCountSummary acs = allAssets[n].getAlarmCounts();
                        assetDownAlarms = acs.getDown();
                        assetCriticalAlarms = acs.getCritical();
                        assetMajorAlarms = acs.getMajor();
                        assetMinorAlarms = acs.getMinor();
                        String alarm = assetDownAlarms + "/" + assetCriticalAlarms + "/" + assetMajorAlarms + "/" + assetMinorAlarms;
                        Property[] properties = allAssets[n].getProperties().toArray();
                        String[] rowData = null;
                        if (properties != null) {
                            int j;
                            String name = "";
                            String status = "";
                            String ip = "";
                            String vendor = "";
                            String model = "";
                            if (DeviceFlavor.ARRAY.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++arrayCount;
                                j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    } else if ("header.vendor".toString().equals(properties[j].getCanonicalName())) {
                                        vendor = properties[j].getLocalizedValue();
                                    } else if ("header.ip".toString().equals(properties[j].getCanonicalName())) {
                                        ip = properties[j].getLocalizedValue();
                                    } else if ("header.model".toString().equals(properties[j].getCanonicalName())) {
                                        model = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                            } else if (DeviceFlavor.SWITCH.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++switchCount;
                                j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    } else if ("header.vendor".toString().equals(properties[j].getCanonicalName())) {
                                        vendor = properties[j].getLocalizedValue();
                                    } else if ("header.ip".toString().equals(properties[j].getCanonicalName())) {
                                        ip = properties[j].getLocalizedValue();
                                    } else if ("header.model".toString().equals(properties[j].getCanonicalName())) {
                                        model = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                            } else if (DeviceFlavor.HOST.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++hostCount;
                                j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    } else if ("header.vendor".toString().equals(properties[j].getCanonicalName())) {
                                        vendor = properties[j].getLocalizedValue();
                                    } else if ("header.ip".toString().equals(properties[j].getCanonicalName())) {
                                        ip = properties[j].getLocalizedValue();
                                    } else if ("header.model".toString().equals(properties[j].getCanonicalName())) {
                                        model = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                            } else if (DeviceFlavor.HBA.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++hbaCount;
                                j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                            }
                            rowData = new String[]{name, allAssets[n].getElementType().getFlavor().toString(), alarm, monitorStatus, status, vendor, model};
                        }
                        al.add(rowData);
                        ++n;
                    }
                    String title = "cli.title.asset.summary";
                    int count = arrayCount + switchCount + hostCount + hbaCount;
                    String[] titleArgs = new String[]{"" + count};
                    String[] heading = new String[]{"cli.title.name", "cli.title.type", "cli.title.alarm", "cli.title.health.monitor", "cli.title.status", "cli.title.vendor", "cli.title.model"};
                    String[][] data = (String[][])al.toArray((T[])new String[al.size()][]);
                    AssetTableDataHelper dataHelper = new AssetTableDataHelper();
                    dataHelper.fetchSummaryRows(DeviceFlavor.HBA, scope, "");
                    Iterator assetList = dataHelper.iterator();
                    String hbaTitle = "cli.title.hba.summary";
                    String[] hbaHeading = new String[]{"cli.title.hba.wwn", "cli.title.status", "cli.title.alarm", "cli.title.hostname"};
                    ArrayList<String[]> hbaAl = new ArrayList<String[]>();
                    while (assetList.hasNext()) {
                        String rowID = (String)assetList.next();
                        String alarmDown = dataHelper.getDataValue(rowID, "alarms.count.down");
                        String alarmCritical = dataHelper.getDataValue(rowID, "alarms.count.critical");
                        String alarmMajor = dataHelper.getDataValue(rowID, "alarms.count.major");
                        String alarmMinor = dataHelper.getDataValue(rowID, "alarms.count.minor");
                        String alarm = alarmDown + "/" + alarmCritical + "/" + alarmMajor + "/" + alarmMinor;
                        String[] rowData = new String[]{dataHelper.getDataValue(rowID, "header.logicalName"), dataHelper.getDataValue(rowID, "header.status"), alarm, dataHelper.getDataValue(rowID, "header.hba.hostName")};
                        hbaAl.add(rowData);
                    }
                    String[][] hbaData = (String[][])hbaAl.toArray((T[])new String[hbaAl.size()][]);
                    int hbaCt = hbaAl.size();
                    String[] hbaArgs = new String[]{"" + hbaCt};
                    if (null == data || data.length < 1) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.asset.found", (Locale)this.getLocale()), 2);
                    }
                    CliPrintHelper.print(title, titleArgs, heading, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    if (null != hbaData && hbaData.length > 0) {
                        CliPrintHelper.print(hbaTitle, hbaArgs, hbaHeading, hbaData, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    }
                    break block55;
                }
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.asset.found", (Locale)this.getLocale()), 2);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
            }
        }
    }

    private void listAssetsByType(String scope, DeviceFlavor assetType, String pattern, PrintWriter out) throws CLIExecutionException, CLIException {
        block65: {
            AlarmService alarmService = null;
            try {
                alarmService = (AlarmService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$alarmservice$api$AlarmService == null ? (class$com$sun$netstorage$mgmt$esm$logic$alarmservice$api$AlarmService = ListAssetsHandler.class$("com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmService")) : class$com$sun$netstorage$mgmt$esm$logic$alarmservice$api$AlarmService));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
            }
            AssetService assetService = null;
            try {
                assetService = (AssetService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService == null ? (class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService = ListAssetsHandler.class$("com.sun.netstorage.mgmt.esm.logic.asset.api.AssetService")) : class$com$sun$netstorage$mgmt$esm$logic$asset$api$AssetService));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
            }
            if (null == alarmService) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.alarm.found", (Locale)this.getLocale()), 9);
            }
            if (null == assetService) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.asset.found", (Locale)this.getLocale()), 9);
            }
            try {
                Identity scopeId = null;
                scopeId = scope.equals("SAN") ? new Identity("", IdentityType.SAN) : new Identity(scope, IdentityType.GUID);
                ElementSummary[] allAssets = new ElementSummary[]{};
                try {
                    AssetQuery assetQuery = new AssetQuery();
                    assetQuery.setScopeId(scopeId);
                    if (assetType != null) {
                        assetQuery.setAssetFlavor(assetType);
                    }
                    allAssets = pattern == null ? assetService.getAssets(assetQuery) : assetService.searchAssets(assetQuery, pattern);
                }
                catch (AssetException ae) {
                    throw new CLIExecutionException("Internal error, failed to retrieve asset summaries", ae, 9);
                }
                catch (Exception ae) {
                    throw new CLIExecutionException("Internal error, failed to retrieve asset summaries", ae, 9);
                }
                if (allAssets != null) {
                    String[] heading = null;
                    ArrayList<String[]> al = new ArrayList<String[]>();
                    long assetDownAlarms = 0L;
                    long assetCriticalAlarms = 0L;
                    long assetMajorAlarms = 0L;
                    long assetMinorAlarms = 0L;
                    int arrayCount = 0;
                    int switchCount = 0;
                    int hostCount = 0;
                    int hbaCount = 0;
                    int n = 0;
                    while (n < allAssets.length) {
                        Identity assetId = allAssets[n].getIdentity();
                        String monitorStatus = "";
                        monitorStatus = assetService.isAssetMonitor(assetId) ? "cli.monitor.on" : "cli.monitor.off";
                        AlarmCountSummary acs = allAssets[n].getAlarmCounts();
                        assetDownAlarms = acs.getDown();
                        assetCriticalAlarms = acs.getCritical();
                        assetMajorAlarms = acs.getMajor();
                        assetMinorAlarms = acs.getMinor();
                        String alarm = assetDownAlarms + "/" + assetCriticalAlarms + "/" + assetMajorAlarms + "/" + assetMinorAlarms;
                        Property[] properties = allAssets[n].getProperties().toArray();
                        String[] rowData = null;
                        if (properties != null) {
                            String name = "";
                            String status = "";
                            String ip = "";
                            String vendor = "";
                            String model = "";
                            String id = "";
                            if (DeviceFlavor.ARRAY.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++arrayCount;
                                int j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    } else if ("header.vendor".toString().equals(properties[j].getCanonicalName())) {
                                        vendor = properties[j].getLocalizedValue();
                                    } else if ("header.ip".toString().equals(properties[j].getCanonicalName())) {
                                        ip = properties[j].getLocalizedValue();
                                    } else if ("header.deviceID".toString().equals(properties[j].getCanonicalName())) {
                                        id = properties[j].getLocalizedValue();
                                    } else if ("header.model".toString().equals(properties[j].getCanonicalName())) {
                                        model = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                                rowData = new String[]{name, alarm, monitorStatus, status, ip, id, vendor, model};
                                heading = new String[]{"cli.title.name", "cli.title.alarm", "cli.title.health.monitor", "cli.title.status", "cli.title.ip", "cli.title.id", "cli.title.vendor", "cli.title.model"};
                            } else if (DeviceFlavor.SWITCH.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++switchCount;
                                int j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    } else if ("header.vendor".toString().equals(properties[j].getCanonicalName())) {
                                        vendor = properties[j].getLocalizedValue();
                                    } else if ("header.ip".toString().equals(properties[j].getCanonicalName())) {
                                        ip = properties[j].getLocalizedValue();
                                    } else if ("header.deviceID".toString().equals(properties[j].getCanonicalName())) {
                                        id = properties[j].getLocalizedValue();
                                    } else if ("header.model".toString().equals(properties[j].getCanonicalName())) {
                                        model = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                                rowData = new String[]{name, alarm, monitorStatus, status, ip, id, vendor, model};
                                heading = new String[]{"cli.title.name", "cli.title.alarm", "cli.title.health.monitor", "cli.title.status", "cli.title.ip", "cli.title.id", "cli.title.vendor", "cli.title.model"};
                            } else if (DeviceFlavor.HOST.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++hostCount;
                                int j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    } else if ("header.vendor".toString().equals(properties[j].getCanonicalName())) {
                                        vendor = properties[j].getLocalizedValue();
                                    } else if ("header.ip".toString().equals(properties[j].getCanonicalName())) {
                                        ip = properties[j].getLocalizedValue();
                                    } else if ("header.deviceID".toString().equals(properties[j].getCanonicalName())) {
                                        id = properties[j].getLocalizedValue();
                                    } else if ("header.model".toString().equals(properties[j].getCanonicalName())) {
                                        model = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                                rowData = new String[]{name, alarm, monitorStatus, status, ip, id, vendor, model};
                                heading = new String[]{"cli.title.name", "cli.title.alarm", "cli.title.health.monitor", "cli.title.status", "cli.title.ip", "cli.title.id", "cli.title.vendor", "cli.title.model"};
                            } else if (DeviceFlavor.HBA.toString().equals(allAssets[n].getElementType().getFlavor().toString())) {
                                ++hbaCount;
                                String hba_host = "";
                                int j = 0;
                                while (j < properties.length) {
                                    if ("header.logicalName".toString().equals(properties[j].getCanonicalName())) {
                                        name = properties[j].getLocalizedValue();
                                    } else if ("header.status".toString().equals(properties[j].getCanonicalName())) {
                                        status = properties[j].getLocalizedValue();
                                    } else if ("header.hba.hostName".equals(properties[j].getCanonicalName())) {
                                        hba_host = properties[j].getLocalizedValue();
                                    }
                                    ++j;
                                }
                                rowData = new String[]{name, status, alarm, hba_host};
                                heading = new String[]{"cli.title.hba.wwn", "cli.title.status", "cli.title.alarm", "cli.title.hostname"};
                            }
                        }
                        al.add(rowData);
                        ++n;
                    }
                    String title = "cli.title.asset.summary";
                    int count = arrayCount + switchCount + hostCount + hbaCount;
                    String[] titleArgs = new String[]{"" + count};
                    String[][] data = (String[][])al.toArray((T[])new String[al.size()][]);
                    if (null == data || data.length < 1) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.asset.found", (Locale)this.getLocale()), 2);
                    }
                    CliPrintHelper.print(title, titleArgs, heading, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                    break block65;
                }
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAssetsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.asset.found", (Locale)this.getLocale()), 2);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CLIExecutionException(e.getMessage(), e.getCause(), 9);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

