/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.iplanet.jato.model.DefaultModel;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.EventsDataHelper;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandHandler;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class ListAlarmsHandler
extends SimpleHandler
implements SubcommandHandler {
    private static final String MAX_ROWS = "25";
    private static final int MAX_ROW_NUM = 100;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        String row = theSubcommandData.getSingleValueOption("row");
        String page = theSubcommandData.getSingleValueOption("page");
        String filter = theSubcommandData.getSingleValueOption("filter");
        String sort = theSubcommandData.getSingleValueOption("sort");
        String scope = theSubcommandData.getSingleValueOption("scope");
        Identity scopeIdentity = null;
        if (scope == null) {
            scope = "SAN";
            scopeIdentity = new Identity("", IdentityType.SAN);
        } else {
            scopeIdentity = new Identity(scope, IdentityType.GUID);
        }
        String idStr = super.getIdentityStr(theSubcommandData);
        DefaultModel model = new DefaultModel();
        ArrayList al = new ArrayList();
        Properties p = new Properties();
        Locale locale = super.getLocale();
        if (null != page) {
            try {
                int pageNumber = Integer.parseInt(page);
            }
            catch (NumberFormatException e) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.page.number", (Object[])new String[]{"listalarms"}, (Locale)this.getLocale()), 9);
            }
            p.setProperty("currentPage", page);
        } else {
            p.setProperty("currentPage", "1");
        }
        if (null != row) {
            try {
                int rowNumber = Integer.parseInt(row);
                if (rowNumber > 100 || rowNumber < 1) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.row.number", (Object[])new String[]{"listalarms"}, (Locale)this.getLocale()), 9);
                }
            }
            catch (NumberFormatException e) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"invalid.row.number", (Object[])new String[]{"listalarms"}, (Locale)this.getLocale()), 9);
            }
            p.setProperty("maxRows", row);
        } else {
            p.setProperty("maxRows", MAX_ROWS);
        }
        p.setProperty("scopeID", scopeIdentity.toCondensedString());
        p.setProperty("PrimarySortNameHiddenField", "Alarm0");
        p.setProperty("PrimarySortOrderHiddenField", "descending");
        p.setProperty("SecondarySortNameHiddenField", "timeStr");
        p.setProperty("SecondarySortOrderHiddenField", "descending");
        p.setProperty("severity", "all");
        p.setProperty("state", "all");
        String serverity = null;
        String topics = null;
        String type = null;
        String state = null;
        if (null != idStr) {
            p.setProperty("deviceID", idStr);
        }
        if (sort != null) {
            this.setSort(sort, p);
        }
        if (null != filter) {
            StringTokenizer stk = new StringTokenizer(filter, ",");
            while (stk.hasMoreTokens()) {
                String keyValue = stk.nextToken().trim();
                if (keyValue.indexOf("=") == -1) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.key.incorrect", (Object[])new String[]{keyValue}, (Locale)this.getLocale()), 1);
                }
                String key = keyValue.substring(0, keyValue.indexOf("=")).trim();
                String value = keyValue.substring(keyValue.indexOf("=") + 1).trim();
                if (key.equalsIgnoreCase("severity")) {
                    serverity = value;
                    if (null != value && value.equalsIgnoreCase("all")) {
                        p.setProperty("severity", serverity);
                        continue;
                    }
                    if (null != serverity && serverity.equalsIgnoreCase("down")) {
                        serverity = "4";
                        p.setProperty("severity", serverity);
                        continue;
                    }
                    if (null != serverity && serverity.equalsIgnoreCase("critical")) {
                        serverity = "3";
                        p.setProperty("severity", serverity);
                        continue;
                    }
                    if (null != serverity && serverity.equalsIgnoreCase("major")) {
                        serverity = "2";
                        p.setProperty("severity", serverity);
                        continue;
                    }
                    if (null != serverity && serverity.equalsIgnoreCase("minor")) {
                        serverity = "1";
                        p.setProperty("severity", serverity);
                        continue;
                    }
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.value.incorrect", (Object[])new String[]{value, key}, (Locale)this.getLocale()), 1);
                }
                if (key.equalsIgnoreCase("topics")) {
                    topics = value;
                    if (null != topics && topics.equalsIgnoreCase("all")) {
                        p.setProperty("topic", topics);
                        continue;
                    }
                    if (null != topics && topics.equalsIgnoreCase("communication")) {
                        topics = "alarmType.communicationStateChange";
                        p.setProperty("topic", topics);
                        continue;
                    }
                    if (null != topics && topics.equalsIgnoreCase("logentry")) {
                        topics = "alarmType.logEntry";
                        p.setProperty("topic", topics);
                        continue;
                    }
                    if (null != topics && topics.equalsIgnoreCase("state")) {
                        topics = "alarmType.stateChange";
                        p.setProperty("topic", topics);
                        continue;
                    }
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.value.incorrect", (Object[])new String[]{value, key}, (Locale)this.getLocale()), 1);
                }
                if (key.equalsIgnoreCase("type")) {
                    type = value;
                    if (null != type && type.equalsIgnoreCase("all")) {
                        p.setProperty("deviceType", type);
                        continue;
                    }
                    if (null != type && type.equalsIgnoreCase("array")) {
                        p.setProperty("deviceType", type);
                        continue;
                    }
                    if (null != type && type.equalsIgnoreCase("host")) {
                        p.setProperty("deviceType", type);
                        continue;
                    }
                    if (null != type && type.equalsIgnoreCase("switch")) {
                        p.setProperty("deviceType", type);
                        continue;
                    }
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.value.incorrect", (Object[])new String[]{value, key}, (Locale)this.getLocale()), 1);
                }
                if (key.equalsIgnoreCase("state")) {
                    state = value;
                    if (null != state && state.equalsIgnoreCase("all")) {
                        p.setProperty("state", "all");
                        continue;
                    }
                    if (null != state && state.equalsIgnoreCase("acknowledged")) {
                        state = "1";
                        p.setProperty("state", state);
                        continue;
                    }
                    if (null != state && state.equalsIgnoreCase("cleared")) {
                        state = "2";
                        p.setProperty("state", state);
                        continue;
                    }
                    if (null != state && state.equalsIgnoreCase("open")) {
                        state = "0";
                        p.setProperty("state", state);
                        continue;
                    }
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.value.incorrect", (Object[])new String[]{value, key}, (Locale)this.getLocale()), 1);
                }
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.key.incorrect", (Object[])new String[]{key}, (Locale)this.getLocale()), 1);
            }
        }
        EventsDataHelper eventData = new EventsDataHelper();
        try {
            eventData.populateAlarmsTableModel(model, p, al, locale);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.alarm.retrieved", (Object[])new String[]{super.getQuery(theSubcommandData)}, (Locale)this.getLocale()), e.getCause(), 9);
        }
        ArrayList<String[]> alarmList = new ArrayList<String[]>();
        String totalAlarmCounts = p.getProperty("recordNumber");
        String currentPage = p.getProperty("currentPage");
        String rowNumber = "";
        rowNumber = row != null ? row : MAX_ROWS;
        int totalPageNumber = (new Integer(totalAlarmCounts) - 1) / new Integer(rowNumber) + 1;
        try {
            model.beforeFirst();
            while (model.next()) {
                String[] alarmData = new String[]{(String)model.getValue("useRuntime.AlarmDetails"), (String)model.getValue("severity"), (String)model.getValue("topicStr"), (String)model.getValue("stateStr"), (String)model.getValue("timeStr"), (String)model.getValue("deviceNameStr"), (String)model.getValue("deviceTypeStr"), (String)model.getValue("parentNameStr")};
                alarmList.add(alarmData);
            }
        }
        catch (Exception e) {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.no.alarm.retrieved", (Object[])new String[]{super.getQuery(theSubcommandData)}, (Locale)this.getLocale()), e.getCause(), 9);
        }
        String[][] data = (String[][])alarmList.toArray((T[])new String[alarmList.size()][]);
        String[] heading = new String[]{"cli.alarm.id", "severity", "cli.title.topic", "cli.title.state", "cli.title.time", "element.name", "element.type", "parent.name"};
        String title = "cli.title.alarm.page";
        String[] titleArgs = new String[]{totalAlarmCounts, new Integer(totalPageNumber).toString(), currentPage};
        int retCode = 0;
        if (null == data || data.length < 1) {
            return this.reportNoData(out, "cli.no.alarm.found");
        }
        CliPrintHelper.print(title, titleArgs, heading, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
        return retCode;
    }

    private void setSort(String filter, Properties p) throws CLIExecutionException {
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(filter, ",");
        while (stk.hasMoreTokens()) {
            String keyValue = stk.nextToken().trim();
            if (keyValue.indexOf("=") == -1) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"filter.key.incorrect", (Object[])new String[]{keyValue}, (Locale)this.getLocale()), 1);
            }
            al.add(keyValue);
        }
        String[] sortData = al.toArray(new String[al.size()]);
        int i = 0;
        while (i < sortData.length) {
            String key = sortData[i].substring(0, sortData[i].indexOf("=")).trim();
            String value = sortData[i].substring(sortData[i].indexOf("=") + 1).trim();
            String sortDirection = "";
            if (value.equalsIgnoreCase("ascending")) {
                sortDirection = "ascending";
            } else if (value.equalsIgnoreCase("descending")) {
                sortDirection = "descending";
            } else {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"sort.value.incorrect", (Object[])new String[]{value}, (Locale)this.getLocale()), 1);
            }
            String sortValue = this.getSortValue(key);
            if (null == key) {
                throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"sort.value.incorrect", (Object[])new String[]{value}, (Locale)this.getLocale()), 1);
            }
            if (i == 0) {
                p.setProperty("PrimarySortNameHiddenField", sortValue);
                p.setProperty("PrimarySortOrderHiddenField", sortDirection);
            } else if (i == 1) {
                p.setProperty("SecondarySortNameHiddenField", sortValue);
                p.setProperty("SecondarySortOrderHiddenField", sortDirection);
            } else if (i == 2) {
                p.setProperty("AdvancedSortNameHiddenField", sortValue);
                p.setProperty("AdvancedSortOrderHiddenField", sortDirection);
            }
            ++i;
        }
    }

    private String getSortValue(String sortValue) throws CLIExecutionException {
        String sort = null;
        if (null == sortValue) {
            return null;
        }
        if (sortValue.equalsIgnoreCase("Severity")) {
            sort = "Alarm0";
        } else if (sortValue.equalsIgnoreCase("State")) {
            sort = "stateStr";
        } else if (sortValue.equalsIgnoreCase("Time")) {
            sort = "timeStr";
        } else if (sortValue.equalsIgnoreCase("Topic")) {
            sort = "topicStr";
        } else if (sortValue.equalsIgnoreCase("Element Name")) {
            sort = "deviceNameStr";
        } else if (sortValue.equalsIgnoreCase("Element Type")) {
            sort = "deviceTypeStr";
        } else if (sortValue.equalsIgnoreCase("Parent Name")) {
            sort = "parentNameStr";
        } else {
            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ListAlarmsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"sort.key.incorrect", (Object[])new String[]{sortValue}, (Locale)this.getLocale()), 1);
        }
        return sort;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

