/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.sun.netstorage.mgmt.esm.logic.notification.api.ContractSpecificationException;
import com.sun.netstorage.mgmt.esm.logic.notification.api.NotificationService;
import com.sun.netstorage.mgmt.esm.logic.service.api.ServiceLocator;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.CriteriaParser;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.SNMPDataHelper;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ConfigSnmpHandler
extends SimpleHandler {
    private static final String ALL = "all";
    private static final Map SEVERITY_MAP = new HashMap();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        block24: {
            super.execute(theSubcommandData, out);
            Boolean remove = theSubcommandData.getBooleanOption("remove");
            Boolean add = theSubcommandData.getBooleanOption("add");
            boolean isRemove = remove != null ? remove : false;
            boolean isAdd = add != null ? add : false;
            String host = theSubcommandData.getSingleValueOption("host");
            String cid = theSubcommandData.getSingleValueOption("id");
            String level = theSubcommandData.getSingleValueOption("level");
            String recipient = theSubcommandData.getSingleValueOption("recipient");
            String port = theSubcommandData.getSingleValueOption("port");
            try {
                NotificationService svc = null;
                svc = (NotificationService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService == null ? (class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService = ConfigSnmpHandler.class$("com.sun.netstorage.mgmt.esm.logic.notification.api.NotificationService")) : class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService));
                SNMPDataHelper helper = new SNMPDataHelper(svc, this.getLocale());
                if (!isRemove && !isAdd) {
                    Map subscribers;
                    if (host != null || cid != null || level != null || recipient != null || port != null) {
                        this.reportInvalidArgException("cli.option.missing", "roadking.cli.configsnmp.synopsis");
                    }
                    if ((subscribers = helper.getSubscribers()) == null || subscribers.size() == 0) {
                        return this.reportNoData(out, "cli.no.snmp.subscriptions.found");
                    }
                    String[][] data = new String[subscribers.size()][5];
                    int row = 0;
                    Iterator ite = subscribers.keySet().iterator();
                    while (ite.hasNext()) {
                        String contractId = (String)ite.next();
                        Map subscriber = (Map)subscribers.get(contractId);
                        data[row][0] = contractId;
                        data[row][1] = (String)subscriber.get("subscriber.subscriber");
                        data[row][2] = (String)subscriber.get("subscriber.host");
                        data[row][3] = (String)subscriber.get("subscriber.port");
                        data[row][4] = (String)subscriber.get("subscriber.severity");
                        ++row;
                    }
                    String[] headers = new String[]{"cli.notification.contractid", "snmp.subscriber.subscriber", "snmp.subscriber.host", "snmp.subscriber.port", "snmp.subscriber.severity"};
                    CliPrintHelper.print("admin.snmp.page.title", null, headers, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigSnmpHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
                }
                if (isRemove) {
                    if (cid == null) {
                        this.reportInvalidArgException("cli.snmp.id.null.error", "roadking.cli.configsnmp.synopsis");
                    }
                    Long id = null;
                    try {
                        id = Long.valueOf(cid);
                    }
                    catch (NumberFormatException nfe) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigSnmpHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.arg", (Object[])new String[]{cid}, (Locale)this.getLocale()), 1);
                    }
                    boolean result = helper.removeSubscription(id.longValue());
                    if (!result) {
                        throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigSnmpHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.snmp.remove.failed", (Object[])new String[]{cid}, (Locale)this.getLocale()), 1);
                    }
                    out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigSnmpHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.snmp.remove.succeeded", (Object[])new String[]{cid}, (Locale)this.getLocale()));
                }
                if (!isAdd) break block24;
                if (host == null) {
                    this.reportInvalidArgException("cli.snmp.host.null.error", "roadking.cli.configsnmp.synopsis");
                }
                if (recipient == null) {
                    this.reportInvalidArgException("cli.snmp.recipient.null.error", "roadking.cli.configsnmp.synopsis");
                }
                if (port == null) {
                    this.reportInvalidArgException("cli.snmp.port.null.error", "roadking.cli.configsnmp.synopsis");
                }
                Integer intPort = null;
                try {
                    intPort = Integer.valueOf(port);
                }
                catch (NumberFormatException nfe) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigSnmpHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.arg", (Object[])new String[]{port}, (Locale)this.getLocale()), 1);
                }
                level = level == null ? ALL : level;
                String mlevel = (String)SEVERITY_MAP.get(level);
                if (CriteriaParser.SEVERITY_MAP.get(mlevel) == null) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigSnmpHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.arg", (Object[])new String[]{level}, (Locale)this.getLocale()), 1);
                }
                helper.saveSubscription(null, recipient, host, intPort.intValue(), mlevel);
            }
            catch (CLIExecutionException cee) {
                throw cee;
            }
            catch (ContractSpecificationException ce) {
                int errorNo = ce.getErrorNo();
                if (errorNo == 103) {
                    this.reportInvalidArgException("admin.snmp.error.exist.msg");
                } else {
                    this.reportInvalidArgException("admin.snmp.error.add.msg");
                }
            }
            catch (NumberFormatException ne) {
                this.reportInvalidArgException("admin.snmp.error.subscription.invalidport.msg");
            }
            catch (IllegalArgumentException iae) {
                this.reportInvalidArgException("admin.snmp.error.subscription.invalidport.msg");
            }
            catch (UnknownHostException ue) {
                this.reportInvalidArgException("admin.snmp.error.subscription.unknownhost.msg");
            }
            catch (Exception e) {
                throw new CLIExecutionException(e.getMessage(), e, 9);
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SEVERITY_MAP.put(ALL, "alarm.severity.minor");
        SEVERITY_MAP.put("down", "alarm.severity.down");
        SEVERITY_MAP.put("critical", "alarm.severity.critical");
        SEVERITY_MAP.put("major", "alarm.severity.major");
    }
}

