/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.sun.netstorage.mgmt.esm.logic.notification.api.ContractSpecificationException;
import com.sun.netstorage.mgmt.esm.logic.notification.api.NotificationService;
import com.sun.netstorage.mgmt.esm.logic.service.api.ServiceLocator;
import com.sun.netstorage.mgmt.esm.ui.util.StringUtil;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.CriteriaParser;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.EmailDataHelper;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.TopicAnalyzer;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ConfigEmailHandler
extends SimpleHandler {
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String ALL = "all";
    private static final Map TOPIC_MAP = new HashMap();
    private static final Map DEVICE_MAP;
    private static final Map SEVERITY_MAP;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        Boolean remove = theSubcommandData.getBooleanOption("remove");
        Boolean add = theSubcommandData.getBooleanOption("add");
        boolean isRemove = remove != null ? remove : false;
        boolean isAdd = add != null ? add : false;
        String email = theSubcommandData.getSingleValueOption("email");
        String cid = theSubcommandData.getSingleValueOption("id");
        String level = theSubcommandData.getSingleValueOption("level");
        String[] topics = theSubcommandData.getMultipleValueOption("topics");
        String device = theSubcommandData.getSingleValueOption("device");
        Boolean isPager = theSubcommandData.getBooleanOption("pager");
        String recipient = theSubcommandData.getSingleValueOption("recipient");
        try {
            NotificationService svc = null;
            svc = (NotificationService)ServiceLocator.getService((Class)(class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService == null ? (class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.esm.logic.notification.api.NotificationService")) : class$com$sun$netstorage$mgmt$esm$logic$notification$api$NotificationService));
            EmailDataHelper helper = new EmailDataHelper(svc, this.getLocale());
            if (!isRemove && !isAdd) {
                Map subscribers;
                if (email != null || cid != null || level != null || topics != null || device != null || isPager != null || recipient != null) {
                    this.reportInvalidArgException("cli.option.missing", "roadking.cli.configemail.synopsis");
                }
                if ((subscribers = helper.getSubscribers()) == null || subscribers.size() == 0) {
                    return this.reportNoData(out, "cli.no.email.subscriptions.found");
                }
                String[][] data = new String[subscribers.size()][7];
                int row = 0;
                Iterator ite = subscribers.keySet().iterator();
                while (ite.hasNext()) {
                    String contractId = (String)ite.next();
                    Map subscriber = (Map)subscribers.get(contractId);
                    data[row][0] = contractId;
                    data[row][1] = (String)subscriber.get("subscriber.subscriber");
                    data[row][2] = (String)subscriber.get("subscriber.address");
                    data[row][3] = (String)subscriber.get("subscriber.device");
                    data[row][4] = (String)subscriber.get("subscriber.severity");
                    data[row][5] = (String)subscriber.get("subscriber.pager");
                    String tpcs = (String)subscriber.get("subscriber.topics");
                    String[] topicArray = StringUtil.tokenize((String)tpcs, (String)",");
                    topicArray = TopicAnalyzer.getLocalizedTopics((String[])topicArray, (Locale)this.getLocale());
                    data[row][6] = tpcs = StringUtil.concatenate((String[])topicArray, (String)"<BR>");
                    ++row;
                }
                String[] headers = new String[]{"cli.notification.contractid", "email.subscriber.subscriber", "email.subscriber.address", "email.subscriber.device", "email.subscriber.severity", "email.subscriber.pager", "subscription.alarm.topics.title"};
                CliPrintHelper.print("admin.email.page.title", null, headers, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale());
            }
            if (isRemove) {
                if (cid == null) {
                    this.reportInvalidArgException("cli.email.id.null.error", "roadking.cli.configemail.synopsis");
                }
                Long id = null;
                try {
                    id = Long.valueOf(cid);
                }
                catch (NumberFormatException nfe) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.arg", (Object[])new String[]{cid}, (Locale)this.getLocale()), 1);
                }
                boolean result = helper.removeSubscription(id.longValue());
                if (!result) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.email.remove.failed", (Object[])new String[]{cid}, (Locale)this.getLocale()), 1);
                }
                out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.email.remove.succeeded", (Object[])new String[]{cid}, (Locale)this.getLocale()));
            }
            if (isAdd) {
                String[] stringArray;
                if (email == null) {
                    this.reportInvalidArgException("cli.email.address.null.error", "roadking.cli.configemail.synopsis");
                }
                if (recipient == null) {
                    this.reportInvalidArgException("cli.email.recipient.null.error", "roadking.cli.configemail.synopsis");
                }
                String pager = isPager != null ? (isPager.booleanValue() ? YES : NO) : NO;
                level = level == null ? ALL : level;
                String mlevel = (String)SEVERITY_MAP.get(level);
                if (CriteriaParser.SEVERITY_MAP.get(mlevel) == null) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.arg", (Object[])new String[]{level}, (Locale)this.getLocale()), 1);
                }
                String mdevice = (String)DEVICE_MAP.get(device = device == null ? ALL : device);
                if (CriteriaParser.DEVICE_MAP.get(mdevice) == null) {
                    throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.arg", (Object[])new String[]{device}, (Locale)this.getLocale()), 1);
                }
                String topicList = "";
                if (topics == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = ALL;
                } else {
                    stringArray = topics = topics;
                }
                if (topics != null) {
                    int i = 0;
                    while (i < topics.length) {
                        String topic;
                        if (i > 0) {
                            topicList = topicList + "|";
                        }
                        if ((topic = (String)TOPIC_MAP.get(topics[i])) == null) {
                            throw new CLIExecutionException(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigEmailHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.invalid.topic", (Object[])new String[]{topics[i]}, (Locale)this.getLocale()), 1);
                        }
                        topicList = topicList + topic;
                        ++i;
                    }
                }
                helper.saveSubscription(null, recipient, email, pager, mdevice, mlevel, topicList);
            }
        }
        catch (CLIExecutionException cee) {
            throw cee;
        }
        catch (ContractSpecificationException ce) {
            int errorNo = ce.getErrorNo();
            if (errorNo == 103) {
                this.reportInvalidArgException("admin.email.error.exist.msg");
            } else {
                this.reportInvalidArgException("admin.email.error.add.msg");
            }
        }
        catch (Exception e) {
            throw new CLIExecutionException(e.getMessage(), e, 9);
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TOPIC_MAP.put(ALL, TopicAnalyzer.getAllTopicOptions());
        TOPIC_MAP.put("all_alarm", TopicAnalyzer.getAllAlarmTopicOptions());
        TOPIC_MAP.put("log_create", ".definition.create.alarm.logEntry");
        TOPIC_MAP.put("log_update", ".definition.create.alarm.logEntry|.state.update.alarm.logEntry|.definition.delete.alarm.logEntry");
        TOPIC_MAP.put("state_change_create", ".definition.create.alarm.stateChange");
        TOPIC_MAP.put("state_change_update", ".definition.create.alarm.stateChange|.state.update.alarm.stateChange|.definition.delete.alarm.stateChange");
        TOPIC_MAP.put("comm_change_create", ".definition.create.alarm.comStateChange");
        TOPIC_MAP.put("comm_change_update", ".definition.create.alarm.comStateChange|.state.update.alarm.comStateChange|.definition.delete.alarm.comStateChange");
        TOPIC_MAP.put("all_event", TopicAnalyzer.getAllEventTopicOptions());
        TOPIC_MAP.put("diagnostic", ".action.start.diagnosis|.action.update.diagnosis");
        TOPIC_MAP.put("device_host_discovery", ".definition.create.device|.definition.create.host");
        TOPIC_MAP.put("device_host_removal", ".definition.delete.device|.definition.delete.host");
        TOPIC_MAP.put("log", ".definition.create.logEntry");
        TOPIC_MAP.put("topology", ".definition.create.topology.sanzonepath|.definition.restore.topology.sanzonepath|.definition.delete.topology.sanzonepath");
        TOPIC_MAP.put("fru_addition", ".definition.create.fru");
        TOPIC_MAP.put("fru_removal", ".definition.delete.fru");
        TOPIC_MAP.put("device", ".state.update.device");
        TOPIC_MAP.put("health", ".state.update.health");
        TOPIC_MAP.put("communication", ".state.update.topology.sanzonepath");
        TOPIC_MAP.put("monitoring_start", ".action.start.monitor.resType.resModel");
        TOPIC_MAP.put("monitoring_end", ".action.end.monitor.resType.resModel");
        DEVICE_MAP = new HashMap();
        DEVICE_MAP.put(ALL, "alarm.device.all");
        DEVICE_MAP.put("host", "alarm.device.host");
        DEVICE_MAP.put("3510", "alarm.device.3510");
        DEVICE_MAP.put("rack", "alarm.device.rack");
        DEVICE_MAP.put("switch", "alarm.device.switch");
        DEVICE_MAP.put("t3", "alarm.device.t3");
        DEVICE_MAP.put("6120", "alarm.device.6120");
        DEVICE_MAP.put("9900", "alarm.device.9900");
        SEVERITY_MAP = new HashMap();
        SEVERITY_MAP.put(ALL, "alarm.severity.minor");
        SEVERITY_MAP.put("down", "alarm.severity.down");
        SEVERITY_MAP.put("critical", "alarm.severity.critical");
        SEVERITY_MAP.put("major", "alarm.severity.major");
    }
}

