/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.ui.cli.handlers;

import com.sun.netstorage.mgmt.esm.logic.asset.api.SAP;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceFlavor;
import com.sun.netstorage.mgmt.esm.ui.common.UserValidationException;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.SupportAppConstants;
import com.sun.netstorage.mgmt.esm.ui.viewbeans.admin.SupportAppDataHelper;
import com.sun.netstorage.mgmt.locale.Localize;
import com.sun.netstorage.mgmt.ui.cli.handlers.SimpleHandler;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.CLIExecutionException;
import com.sun.netstorage.mgmt.ui.cli.interfaces.server.SubcommandData;
import com.sun.netstorage.mgmt.ui.cli.util.CliPrintHelper;
import java.io.PrintWriter;
import java.util.Locale;

public class ConfigAppsHandler
extends SimpleHandler
implements SupportAppConstants {
    private static final String SWITCH = "switch";
    private static final String ARRAY = "array";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages;

    public int execute(SubcommandData theSubcommandData, PrintWriter out) throws CLIException, CLIExecutionException {
        super.execute(theSubcommandData, out);
        Boolean remove = theSubcommandData.getBooleanOption("remove");
        Boolean add = theSubcommandData.getBooleanOption("add");
        Boolean map = theSubcommandData.getBooleanOption("map");
        boolean isRemove = remove != null ? remove : false;
        boolean isAdd = add != null ? add : false;
        boolean isMap = map != null ? map : false;
        String app = theSubcommandData.getSingleValueOption("application");
        String location = theSubcommandData.getSingleValueOption("location");
        String type = theSubcommandData.getSingleValueOption("type");
        try {
            SupportAppDataHelper helper = new SupportAppDataHelper();
            if (!(isRemove || isAdd || isMap)) {
                SAP[] saps;
                if (app != null || location != null || type != null || this.getIdentityStr(theSubcommandData) != null) {
                    this.reportInvalidArgException("cli.option.missing", "roadking.cli.configapps.synopsis");
                }
                if ((saps = helper.getSupportApps()) == null || saps.length == 0) {
                    return this.reportNoData(out, "cli.no.saps.found");
                }
                String[][] data = new String[saps.length][4];
                int i = 0;
                while (i < saps.length) {
                    data[i][0] = saps[i].getAppName();
                    data[i][1] = saps[i].getAppLocation();
                    data[i][2] = helper.getFormattedVmfsList(saps[i].getAppName(), "<BR>");
                    data[i][3] = saps[i].getAssetType().toString();
                    ++i;
                }
                String[] headers = new String[]{"SupportAppName", "SupportAppLocation", "SupportAppVMF", "SupportAppElementType"};
                CliPrintHelper.print("ListSupportApps.title", null, headers, data, this.isVerbose(), this.isNoHeading(), out, class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigAppsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages, this.getLocale(), false);
            }
            if (isRemove) {
                if (app == null) {
                    this.reportInvalidArgException("cli.sap.app.null.error", "roadking.cli.configapps.synopsis");
                }
                helper.delete(app);
                out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigAppsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.sap.remove.success", (Object[])new String[]{app}, (Locale)this.getLocale()));
            }
            if (isAdd) {
                if (app == null) {
                    this.reportInvalidArgException("cli.sap.app.null.error", "roadking.cli.configapps.synopsis");
                }
                if (type == null) {
                    this.reportInvalidArgException("cli.sap.type.null.error", "roadking.cli.configapps.synopsis");
                }
                if (location == null) {
                    this.reportInvalidArgException("cli.sap.location.null.error", "roadking.cli.configapps.synopsis");
                }
                if (!type.equals(SWITCH) && !type.equals(ARRAY)) {
                    this.reportInvalidArgException("cli.sap.type.arg.error");
                }
                DeviceFlavor deviceFlavor = type.equals(ARRAY) ? DeviceFlavor.ARRAY : DeviceFlavor.SWITCH;
                SupportAppDataHelper.create((String)app, (String)location, (DeviceFlavor)deviceFlavor);
                out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigAppsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.sap.add.success", (Object[])new String[]{app}, (Locale)this.getLocale()));
            }
            if (isMap) {
                String identity;
                if (app == null) {
                    this.reportInvalidArgException("cli.sap.app.null.error", "roadking.cli.configapps.synopsis");
                }
                if ((identity = this.getIdentityStr(theSubcommandData)) == null) {
                    this.reportInvalidArgException("cli.sap.map.no.device.error", "roadking.cli.configapps.synopsis");
                }
                helper.setAssignment(identity, app);
                out.println(Localize.getString((Object)(class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages == null ? (class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages = ConfigAppsHandler.class$("com.sun.netstorage.mgmt.ui.cli.handlers.HandlerMessages")) : class$com$sun$netstorage$mgmt$ui$cli$handlers$HandlerMessages), (String)"cli.sap.map.success", (Object[])new String[]{app, identity}, (Locale)this.getLocale()));
            }
        }
        catch (UserValidationException uve) {
            this.reportInvalidArgException("cli.sap.null");
        }
        catch (IllegalArgumentException iae) {
            throw new CLIExecutionException(iae.getMessage(), 1);
        }
        catch (CLIExecutionException ce) {
            throw ce;
        }
        catch (Throwable e) {
            throw new CLIExecutionException(e.getMessage(), e, 9);
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

