/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_FS_SECPOLICY_H
#define	_SYS_FS_SECPOLICY_H

#pragma ident	"@(#)fs_secpolicy.h	7.11	04/03/23 SMI; TSOL 2.x"

#include <sys/secpolicy.h>

#ifdef	__cplusplus
extern "C" {
#endif

int	secpolicy_acl_modify(cred_t *, vnode_t *);
int	secpolicy_acl_read(cred_t *, vnode_t *);
void	secpolicy_fs_get(cred_t *, vfs_t *, vnode_t *);
int	secpolicy_fs_unmount(cred_t *, vfs_t *);
int	secpolicy_fs_acl_modify(cred_t *, vnode_t *);
int	secpolicy_fs_acl_read(cred_t *, vnode_t *);
int	secpolicy_fs_buildoptionstr(mntopt_t *, char **, char *, int);
int	secpolicy_fs_config_modify(cred_t *, vnode_t *);
void	secpolicy_fs_copyopt(cred_t *, mntopt_t *, mntopt_t *);
void	secpolicy_fs_copyopttbl(cred_t *, mntopts_t *, mntopts_t *, int);
int	secpolicy_fs_ids_modify(cred_t *, vnode_t *);
int	secpolicy_fs_lnkdir_create(cred_t *, vnode_t *);
int	secpolicy_fs_lnkdir_destroy(cred_t *, vnode_t *);
int	secpolicy_fs_access(cred_t *, vnode_t *);
int	secpolicy_fs_minfree_modify(cred_t *, vnode_t *);
int	secpolicy_fs_mode_modify(cred_t *, vnode_t *);
int	secpolicy_fs_mount(cred_t *, vfs_t *);
void	secpolicy_fs_parsemntflags(cred_t *, struct mounta *, mntopts_t *);
void	secpolicy_fs_release(cred_t *, vfs_t *);
int	secpolicy_fs_setids_modify(cred_t *, vnode_t *);
int	secpolicy_fs_setids_setids(cred_t *, vnode_t *);
int	secpolicy_fs_setmntopt(cred_t *, vfs_t *);
int	secpolicy_fs_stky_modify(cred_t *, vnode_t *);
int	secpolicy_fs_utime_modify(cred_t *, vnode_t *);

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_FS_SECPOLICY_H */
