#!/bin/sh
#  @(#)f90.f77.intel.ver.sh 1.1 (Sun Microsystems, Inc.) 04/04/23
#
#  Copyright (C) 2001 Sun Microsystems, Inc.
#  All rights reserved.
#
# Description:
#     This is a wrapper for running the f90 compiler
#     in f77 compatibility mode.
#
# This string is here for the 'version' command:
# It gets sed'ed in at build-time:
# @(#)RELEASE VERSION Sun Fortran 95 8.0 Patch 115985-03 2005/03/08
inv=0
inl=""
f90opt=""
f90ftr="-ftrap=%none"
for i in $*
do
  case $i in
     -errtags=INVOKE) inv=1;;
     -silent)         inv=1; f90opt="$f90opt $i" ;;
     -fast)           f90opt="$f90opt $i -ftrap=%none";f90ftr="";;
     -ftrap*)         f90opt="$f90opt $i";f90ftr="";;
     -*)              f90opt="$f90opt $i";;
      *)              f90opt="$f90opt $i";;
  esac
done
f90fff=`/bin/dirname $0`
if [ ! -x "$f90fff/f90" ]; then
	ss=`/bin/ls -al "$0" | grep "\-\>" | awk '{print $NF;}' `
        ss=`/bin/dirname $ss`
	[ -x "$ss/f90" ] && f90fff=$ss
fi
f90fff=$f90fff/f90

[ $inv -eq 0 ] && \
    echo NOTICE: Invoking $f90fff -f77 $f90ftr $f90opt
exec $f90fff -f77 $f90ftr $f90opt $inl
