<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <!-- 
        Stylesheet to convert EKE v2.0 XML Output to plain TEXT  
        Originally Created by Sumon Shahed on Nov 03, -2002 
    -->
    <xsl:output method="text" encoding="iso-8859-1" indent="yes"/>


    <xsl:strip-space elements="*"/>

    <xsl:template match="kaeresult">

	    <xsl:apply-templates select="*"/>

    </xsl:template>



    <!-- Skip following elements -->
    <xsl:template match="generatedBy|general_info|customer_info|partner_info|field_eng_info|CRC">
	  <!-- No Info will be shown! -->
    </xsl:template>

    <xsl:template match="date|kae_version|comment|input_data|run_system_info|run_summary">
	  <!-- No Info will be shown! -->
    </xsl:template>




    <xsl:template match="run_info">
	    <xsl:apply-templates select="checkresult" mode="remove_delim"/>
    </xsl:template>



    <!-- Process checkresult -->
    <xsl:template match="checkresult" mode="remove_delim">
<xsl:apply-templates select="check_id/id" mode="remove_delim"/>,<xsl:value-of select="normalize-space(@severity)"/>, <xsl:apply-templates select="description" mode="remove_delim"/>, <xsl:apply-templates select="analysis" mode="remove_delim"/>, <xsl:apply-templates select="recommendations" mode="remove_delim"/> <xsl:text>
</xsl:text>
    </xsl:template>

    <xsl:template match="check_id/id" mode="remove_delim">
		<xsl:value-of select="normalize-space()"/>
    </xsl:template>

    <xsl:template match="check_id/id" mode="remove_delim">
        <xsl:value-of select="normalize-space(translate(text(),',',' '))"/>
    </xsl:template>

    <xsl:template match="description" mode="remove_delim">
        <xsl:value-of select="translate(normalize-space(),',',' ')"/>
    </xsl:template>

    <xsl:template match="analysis" mode="remove_delim">
        <xsl:value-of select="normalize-space(translate(text(),',',' '))"/>
    </xsl:template>

    <xsl:template match="recommendations" mode="remove_delim">
        <xsl:value-of select="normalize-space(translate(text(),',',' '))"/>
    </xsl:template>

</xsl:stylesheet>

