<?xml version="1.0" ?>
<!--
 * Copyright (c) 2000-2002 Sun Microsystems, Inc.
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information"). You shall not
 * disclose such confidential information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
-->
<!-- For converting CML to HTML -->
<!-- See java/com/sun/eras/kae/translator/cml/*.java -->
<!-- We assume an enclosing textbody tag, but remove it. -->
<!-- @author Larry Smith -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="no"/>
  
  <!-- Get settings from TranslationContext object (if set) -->
  <!-- If the enclosing textbody has an anchorRootPath attribute, use it to make an href. -->
  <xsl:variable name="anchorRootPath" select="/textbody/@anchorRootPath"/>

  <xsl:template match="textbody"><xsl:apply-templates/></xsl:template>
  
  <!-- If the anchor tag has an href, use it. 
       Otherwise, the anchor tag anchors to a Explorer, not a URL tag. Look to textbody anchorRootPath attribute. -->
  <xsl:template match="a"><xsl:choose>
                            <xsl:when test="@href">
                              <a>
                                <xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
                                                               <xsl:value-of select="text()"/>
                                                             </a>
                            </xsl:when>
                            <xsl:when test="$anchorRootPath"><a>
                                                               <xsl:attribute name="HREF"><xsl:value-of select="$anchorRootPath"/><xsl:text>/</xsl:text><xsl:value-of select="text()"/></xsl:attribute>
                                                               <code><xsl:value-of select="text()"/></code>
                                                             </a></xsl:when>
                            <xsl:otherwise>Explorer file: <code><xsl:value-of select="text()"/></code></xsl:otherwise>
                          </xsl:choose></xsl:template>
  <xsl:template match="pre"><pre><code><xsl:apply-templates/></code></pre></xsl:template>
  <xsl:template match="code"><code><xsl:apply-templates/></code></xsl:template>
  <xsl:template match="br"><br/></xsl:template>
  <xsl:template match="p"><p><xsl:apply-templates/></p></xsl:template>
  <xsl:template match="ol"><ol><xsl:apply-templates/></ol></xsl:template>
  <xsl:template match="ul"><ul><xsl:apply-templates/></ul></xsl:template>
  <xsl:template match="li"><li><xsl:apply-templates/></li></xsl:template>
  <xsl:template match="table"><table><xsl:apply-templates/></table></xsl:template>
  <xsl:template match="row"><tr><xsl:apply-templates/></tr></xsl:template>
  <xsl:template match="col"><td valign="top"><xsl:if test="@width">
                                      <xsl:attribute name="width">
                                        <xsl:value-of select="@width"/><xsl:text>%</xsl:text>
                                      </xsl:attribute></xsl:if><xsl:apply-templates/></td></xsl:template>
</xsl:stylesheet>
