<?xml version="1.0" ?>
<!-- For converting CML to PDF via FO -->
<!-- See java/com/sun/eras/kae/translator/cml/*.java -->
<!-- We assume an enclosing textbody tag, but remove it. -->
<!-- @author Larry Smith -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:rx="http://www.renderx.com/XSL/Extensions">
  <xsl:output method="xml" indent="no"
              omit-xml-declaration="yes"/>
  
  <!-- Get settings from TranslationContext object (if set) -->
  <!-- If the enclosing textbody has an anchorRootPath attribute, use it to make an href. -->
  <xsl:variable name="anchorRootPath" select="/textbody/@anchorRootPath"/>
  <xsl:variable name="mediaWidth" select="/textbody/@mediaWidth"/>
  <xsl:variable name="mediaWidthUnit" select="/textbody/@mediaWidthUnit"/>

  <xsl:template match="textbody"><xsl:apply-templates/></xsl:template>
  
  <!-- The anchor tag anchors to a Explorer, not a URL tag. Look to textbody anchorRootPath attribute. -->
  <xsl:template match="a"><xsl:choose>
                            <xsl:when test="@href">External URL: <xsl:text>"</xsl:text><xsl:value-of select="@href"/><xsl:text>" (</xsl:text> <xsl:value-of select="text()"/><xsl:text>)</xsl:text></xsl:when>
                            <xsl:when test="$anchorRootPath">Explorer file: <xsl:value-of select="$anchorRootPath"/><xsl:text>/</xsl:text><xsl:value-of select="text()"/></xsl:when>
                              <xsl:otherwise>Explorer file: <xsl:value-of select="text()"/></xsl:otherwise>
                            </xsl:choose></xsl:template>
  <xsl:template match="pre"><fo:block font-family="Courier" font-weight="normal"
                                      linefeed-treatment="preserve" space-treatment="preserve"
                                      white-space-collapse="false"><xsl:apply-templates/></fo:block></xsl:template>
  <xsl:template match="code"><fo:block font-family="Courier" font-weight="normal"
                                       linefeed-treatment="preserve" space-treatment="preserve"
                                       white-space-collapse="false"><xsl:apply-templates/></fo:block></xsl:template>
  <xsl:template match="br"><fo:block linefeed-treatment="preserve" padding-top="1pt"/></xsl:template>
  <xsl:template match="p"> <fo:block space-before.optimum="8pt" text-align="start" text-indent=".5in">
                             <xsl:apply-templates/>
                           </fo:block></xsl:template>
  <xsl:template match="ol"><fo:list-block space-before="3pt" space-after="3pt">
                             <xsl:apply-templates select="li" mode="ordered"/>
                           </fo:list-block></xsl:template>
  <xsl:template match="ul"><fo:list-block space-before="3pt" space-after="3pt">
                             <xsl:apply-templates select="li"/>
                           </fo:list-block></xsl:template>
  <xsl:template match="li" mode="ordered"><fo:list-item>
                                            <fo:list-item-label><xsl:number level="multiple" count="li" from="ol"/></fo:list-item-label>
                                            <fo:list-item-body>
                                              <fo:block>
                                                <xsl:apply-templates/>
                                              </fo:block>
                                            </fo:list-item-body>
                                          </fo:list-item></xsl:template>

  <xsl:template match="li"><fo:list-item>
                             <fo:list-item-label><xsl:text>*</xsl:text></fo:list-item-label>
                             <fo:list-item-body>
                               <fo:block>
                                 <xsl:apply-templates/>
                               </fo:block>
                             </fo:list-item-body>
                           </fo:list-item></xsl:template>

  <!-- I treat the first row specially - @width only appears in the first row of the output -->
  <xsl:template match="table"><fo:table>
                                <xsl:apply-templates select="row[1]" mode="columnsetup"/>
                                <fo:table-body><xsl:apply-templates select="row"/></fo:table-body>
                              </fo:table></xsl:template>
  <xsl:template match="row" mode="columnsetup"><xsl:apply-templates select="col" mode="columnsetup"/></xsl:template>
  <xsl:template match="row"><fo:table-row>
                              <xsl:apply-templates select="col" />
                            </fo:table-row></xsl:template>

  <!-- on the first row, migrate largest @width up to the top. -->
  <xsl:template match="col" mode="columnsetup">
    <xsl:variable name="pos" select="position()"/>
    <xsl:variable name="col-max-width">
      <xsl:call-template name="max-width">
        <!-- go up to enclosing table, get all cols in this position that have widths -->
        <xsl:with-param name="list" select="../../row/col[$pos][@width]"/>
      </xsl:call-template>
    </xsl:variable>
    <fo:table-column><xsl:if test="$col-max-width != 0">
                       <xsl:variable name="abswidth" select="$mediaWidth * $col-max-width div 100"/>
                       <xsl:attribute name="column-width">
                         <xsl:value-of select="$abswidth"/><xsl:value-of select="$mediaWidthUnit"/>
                       </xsl:attribute> 
                     </xsl:if></fo:table-column></xsl:template>

  <xsl:template match="col"><fo:table-cell><xsl:apply-templates/></fo:table-cell></xsl:template>

  <xsl:template name="max-width">
    <!-- From the given list of col tags that are known to have widths,
         return the largest width (or 0 if none) -->
    <xsl:param name="list"/>
    <xsl:choose>
      <xsl:when test="$list">
        <xsl:variable name="first" select="$list[1]/@width" /> 
        <xsl:variable name="rest">
          <xsl:call-template name="max-width">
            <xsl:with-param name="list" select="$list[position() != 1]"/>
          </xsl:call-template>
        </xsl:variable>
        <!-- XSL Error: pattern = 'max($first, $rest)' Could not find function: max -->
        <xsl:choose>
          <xsl:when test="$first &gt; $rest">
            <xsl:value-of select="$first"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$rest"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
