/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.DOMCache;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.dom.DOMAdapter;
import org.apache.xalan.xsltc.dom.MultiDOM;
import org.apache.xalan.xsltc.dom.SAXImpl;
import org.apache.xalan.xsltc.dom.SingletonIterator;
import org.apache.xalan.xsltc.dom.UnionIterator;
import org.apache.xalan.xsltc.dom.XSLTCDTMManager;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class LoadDocument {
    private static final String NAMESPACE_FEATURE = "http://xml.org/sax/features/namespaces";

    public static DTMAxisIterator document(String uri, String base, AbstractTranslet translet, DOM dom) throws Exception {
        DOM newdom;
        DOM newDom;
        int mask;
        File file;
        String originalUri = uri;
        MultiDOM multiplexer = (MultiDOM)dom;
        if (uri == null || uri.equals("")) {
            return new SingletonIterator(-1, true);
        }
        if (!(base == null || base.equals("") || uri.startsWith(base) || uri.startsWith("/") || uri.startsWith("http:/") || uri.startsWith("file:/"))) {
            uri = base + uri;
        }
        if ((file = new File(uri)).exists()) {
            uri = file.toURL().toExternalForm();
        }
        if ((mask = multiplexer.getDocumentMask(uri)) != -1 && (newDom = ((DOMAdapter)multiplexer.getDOMAdapter(uri)).getDOMImpl()) instanceof SAXImpl) {
            return new SingletonIterator(((SAXImpl)newDom).getDocument(), true);
        }
        DOMCache cache = translet.getDOMCache();
        mask = multiplexer.nextMask();
        if (cache != null) {
            newdom = cache.retrieveDocument(uri, mask, translet);
            if (newdom == null) {
                FileNotFoundException e = new FileNotFoundException(originalUri);
                throw new TransletException(e);
            }
        } else {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser2 = factory.newSAXParser();
            XMLReader reader = parser2.getXMLReader();
            try {
                reader.setFeature(NAMESPACE_FEATURE, true);
            }
            catch (Exception e) {
                throw new TransletException(e);
            }
            XSLTCDTMManager dtmManager = (XSLTCDTMManager)((DTMDefaultBase)((Object)((DOMAdapter)multiplexer.getMain()).getDOMImpl())).m_mgr;
            newdom = (SAXImpl)dtmManager.getDTM(new SAXSource(reader, new InputSource(uri)), false, null, true, false, translet.hasIdCall());
            translet.prepassDocument(newdom);
            ((SAXImpl)newdom).setDocumentURI(uri);
        }
        DOMAdapter domAdapter = translet.makeDOMAdapter(newdom);
        multiplexer.addDOMAdapter(domAdapter);
        translet.buildKeys(domAdapter, null, null, ((SAXImpl)newdom).getDocument());
        return new SingletonIterator(((SAXImpl)newdom).getDocument(), true);
    }

    /*
     * WARNING - void declaration
     */
    public static DTMAxisIterator document(Object arg, String xmlURI, String xslURI, AbstractTranslet translet, DOM dom) throws TransletException {
        try {
            int sep;
            if (xmlURI != null) {
                sep = xmlURI.lastIndexOf(92) + 1;
                if (sep <= 0) {
                    sep = xmlURI.lastIndexOf(47) + 1;
                }
                xmlURI = xmlURI.substring(0, sep);
            } else {
                xmlURI = "";
            }
            if (xslURI != null) {
                sep = xslURI.lastIndexOf(92) + 1;
                if (sep <= 0) {
                    sep = xslURI.lastIndexOf(47) + 1;
                }
                xslURI = xslURI.substring(0, sep);
            } else {
                xslURI = "";
            }
            if (arg instanceof String) {
                try {
                    return LoadDocument.document((String)arg, xmlURI, translet, dom);
                }
                catch (FileNotFoundException e) {
                    return LoadDocument.document((String)arg, xslURI, translet, dom);
                }
                catch (SAXParseException e) {
                    return LoadDocument.document((String)arg, xslURI, translet, dom);
                }
            }
            if (arg instanceof DTMAxisIterator) {
                int node;
                UnionIterator union = new UnionIterator(dom);
                DTMAxisIterator iterator = (DTMAxisIterator)arg;
                while ((node = iterator.next()) != -1) {
                    void var7_13;
                    String uri = dom.getStringValueX((int)var7_13);
                    if (xmlURI == null || xmlURI.equals("")) {
                        xmlURI = dom.getDocumentURI((int)var7_13);
                        int sep2 = xmlURI.lastIndexOf(92) + 1;
                        if (sep2 <= 0) {
                            sep2 = xmlURI.lastIndexOf(47) + 1;
                        }
                        xmlURI = xmlURI.substring(0, sep2);
                    }
                    try {
                        union.addIterator(LoadDocument.document(uri, xmlURI, translet, dom));
                    }
                    catch (FileNotFoundException e) {
                        union.addIterator(LoadDocument.document(uri, xslURI, translet, dom));
                    }
                }
                return union;
            }
            String err = "document(" + arg.toString() + ")";
            throw new IllegalArgumentException(err);
        }
        catch (TransletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransletException(e);
        }
    }
}

