/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;

public class EDParse_Photon
extends ExplorerDirEntityParser
implements EntityParserImpl {
    private static final String EnclosureSectionPattern = "^Found";
    private static final String SENAHeadPattern = "^\\s*(.+)\\s+Name:(\\S+)\\s+Node WWN:(\\S+)(?:\\s+Logical Path:(\\S+))?";
    private static final String FCDeviceSectionPattern = "^Found Fibre Channel device\\(s\\)";
    private static final String FCDevicePattern = "^\\s*Node WWN:(\\S+)\\s+Device Type:(.*)";
    private static final String PathHeadPattern = "^\\s*(Logical|Physical) Path:(\\S+)?";
    private static final String PathContentPattern = "^\\s*(\\S+)";
    private static final String DiskSectionPattern = "^\\s*DISK STATUS\\s*$";
    private static final String DiskHeadingPattern = "^(SLOT\\s*)(FRONT DISKS\\s*)(\\(Node WWN\\)\\s*)(REAR DISKS\\s*)\\(Node WWN\\)";
    private static final String SubsystemSectionPattern = "^\\s*SUBSYSTEM STATUS\\s*$";
    private static final String boxPropertiesPattern = "^FW Revision:([\\d.]+)\\s*Box ID:(\\d+)\\s*Node WWN:([\\da-f]+)\\s*Enclosure Name:(\\S+)";
    private static final String labelledStringPattern = "^\\s*([^\\d\\s].*):\\s*(.*?)\\s*$";
    private static final String fullLinePattern = "^\\s*(.*?)\\s*$";
    private static final String powerPattern = "^Power Supplies";
    private static final String fansPattern = "^Fans";
    private static final String esiBoardPattern = "^ESI Interface board\\(IB\\)";
    private static final String diskBackplanePattern = "^Disk backplane";
    private static final String interconnectPattern = "^Interconnect assembly";
    private static final String loopConfigPattern = "^Loop\\s+configuration";
    private static final String languagePattern = "^Language\\s+(.*?)\\s*$";
    private static final int initial = 0;
    private static final int inDiskStatus = 1;
    private static final int inSubsystemStatus = 2;
    private static final int inPowerSupplies = 3;
    private static final int inFans = 4;
    private static final int inESIBoards = 5;
    private static final int inDiskBackplanes = 6;
    private static final int inInterconnects = 7;
    private static final int inLoopConfig = 8;

    public EDParse_Photon(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        ExplorerDirEntityParser.testExplorerDirEntityParser("EDParse_Photon", stringArray);
    }

    public Vector parse() throws ParserException {
        Object object;
        Object object2;
        Vector<ParsedBlock> vector = new Vector<ParsedBlock>();
        ParsedBlock parsedBlock = null;
        StringBuffer stringBuffer = null;
        if (this.trace) {
            parsedBlock = new ParsedBlock("TRACE");
            vector.add(parsedBlock);
            stringBuffer = new StringBuffer("EDParse_Photon.parse() called for explorer path ");
            stringBuffer.append(this.path());
            stringBuffer.append("\n");
        }
        ParsedBlock parsedBlock2 = new ParsedBlock("Photon");
        vector.add(parsedBlock2);
        TreeMap<String, ParsedBlock> treeMap = new TreeMap<String, ParsedBlock>();
        parsedBlock2.put("Enclosures", treeMap);
        ArrayList<ParsedBlock> arrayList = new ArrayList<ParsedBlock>();
        parsedBlock2.put("FibreChannelDevices", arrayList);
        String string = null;
        inputFile inputFile2 = null;
        BufferedReader bufferedReader = null;
        String string2 = null;
        MatchResult matchResult = null;
        ParsedBlock parsedBlock3 = null;
        String string3 = null;
        String string4 = null;
        string = String.valueOf(this.path()) + "/disks/photon/luxadm_probe-p.out";
        try {
            inputFile2 = new inputFile(string);
            bufferedReader = inputFile2.reader();
            inputFile2.defineRegexp("Enclosures section", EnclosureSectionPattern);
            inputFile2.defineRegexp("SENA header", SENAHeadPattern);
            inputFile2.defineRegexp("Fibre Channel devices section", FCDeviceSectionPattern);
            inputFile2.defineRegexp("Fibre Channel device header", FCDevicePattern);
            inputFile2.defineRegexp("Path header", PathHeadPattern);
            inputFile2.defineRegexp("Path content", PathContentPattern);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Vector<String> vector2 = null;
            object2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string5;
                if (bl3) {
                    matchResult = inputFile2.matchRegexp("Path content", string2);
                    if (matchResult != null) {
                        if (parsedBlock3 != null && string3 != null) {
                            parsedBlock3.put(string3, matchResult.group(1));
                        }
                    } else if (this.trace) {
                        stringBuffer.append("needPathContent but no \"Path content\" match\n");
                    }
                    string3 = null;
                    bl3 = false;
                    continue;
                }
                matchResult = inputFile2.matchRegexp("Enclosures section", string2);
                if (matchResult != null && inputFile2.matchRegexp("Fibre Channel devices section", string2) == null) {
                    bl = true;
                    bl2 = false;
                    continue;
                }
                matchResult = inputFile2.matchRegexp("Fibre Channel devices section", string2);
                if (matchResult != null) {
                    bl2 = true;
                    bl = false;
                    continue;
                }
                if (bl && (matchResult = inputFile2.matchRegexp("SENA header", string2)) != null) {
                    vector2 = new Vector<String>();
                    object2 = new Vector();
                    string5 = matchResult.group(1).trim();
                    string4 = matchResult.group(2);
                    parsedBlock3 = string5.equals("SENA") ? new ParsedBlock("PhotonBox") : new ParsedBlock("NotPhotonBox");
                    parsedBlock3.put("Name", string4);
                    parsedBlock3.put("WWN", matchResult.group(3));
                    if (matchResult.group(4) != null && matchResult.group(4).length() > 0) {
                        vector2.add(matchResult.group(4));
                    }
                    parsedBlock3.put("logicalPathes", vector2);
                    parsedBlock3.put("physicalPathes", object2);
                    treeMap.put(string4, parsedBlock3);
                    continue;
                }
                if (bl2 && (matchResult = inputFile2.matchRegexp("Fibre Channel device header", string2)) != null) {
                    parsedBlock3 = new ParsedBlock("FCD");
                    parsedBlock3.put("WWN", matchResult.group(1));
                    parsedBlock3.put("deviceType", matchResult.group(2));
                    arrayList.add(parsedBlock3);
                    continue;
                }
                matchResult = inputFile2.matchRegexp("Path header", string2);
                if (matchResult == null) continue;
                string5 = matchResult.group(1).toLowerCase();
                object = matchResult.group(2);
                if (object == null || ((String)object).length() == 0) {
                    bl3 = true;
                    continue;
                }
                if (bl) {
                    if (string5.equals("logical")) {
                        vector2.add((String)object);
                    }
                    if (!string5.equals("physical")) continue;
                    ((Vector)object2).add(object);
                    continue;
                }
                string3 = String.valueOf(string5) + "Path";
            }
            inputFile2.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileIOException(string, "EDParse_Photon.parse", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new FileIOException(string, "EDParse_Photon.parse", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string, "EDParse_Photon.parse", malformedPatternException);
        }
        String string6 = String.valueOf(this.path()) + "/disks/photon/boxnames";
        File file = new File(string6);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string4 = stringArray[n];
                if (!string4.startsWith(".")) {
                    object2 = null;
                    if (!treeMap.containsKey(string4)) {
                        if (this.trace) {
                            stringBuffer.append("Cannot find PhotonBox block for " + string4 + "\n");
                        }
                    } else {
                        object2 = (ParsedBlock)treeMap.get(string4);
                        string = String.valueOf(this.path()) + "/disks/photon/boxnames/" + string4 + "/luxadm_display.out";
                        ((ParsedBlock)object2).put("fullpath", String.valueOf(this.path()) + "/disks/photon/boxnames/" + string4);
                        ((ParsedBlock)object2).put("relativepath", "disks/photon/boxnames/" + string4);
                        ((ParsedBlock)object2).put("boxname", string4);
                        try {
                            inputFile2 = new inputFile(string);
                            bufferedReader = inputFile2.reader();
                            inputFile2.defineRegexp("Disk Section", DiskSectionPattern);
                            inputFile2.defineRegexp("Disk Headings", DiskHeadingPattern);
                            inputFile2.defineRegexp("Subsystem Section", SubsystemSectionPattern);
                            inputFile2.defineRegexp("box properties", boxPropertiesPattern);
                            inputFile2.defineRegexp("labelled String", labelledStringPattern);
                            inputFile2.defineRegexp("full line", fullLinePattern);
                            inputFile2.defineRegexp("power supplies", powerPattern);
                            inputFile2.defineRegexp("fans", fansPattern);
                            inputFile2.defineRegexp("esi board", esiBoardPattern);
                            inputFile2.defineRegexp("disk backplane", diskBackplanePattern);
                            inputFile2.defineRegexp("interconnect", interconnectPattern);
                            inputFile2.defineRegexp("loop configuration", loopConfigPattern);
                            inputFile2.defineRegexp("language", languagePattern);
                            int n2 = 0;
                            object = null;
                            String string7 = null;
                            String string8 = null;
                            TreeMap<String, String> treeMap2 = null;
                            String string9 = null;
                            TreeMap<String, String> treeMap3 = null;
                            while ((string2 = bufferedReader.readLine()) != null) {
                                if (n2 == 0 && (matchResult = inputFile2.matchRegexp("Disk Headings", string2)) != null) {
                                    StringBuffer stringBuffer2 = new StringBuffer("^([\\d\\s]{");
                                    stringBuffer2.append(String.valueOf(matchResult.group(1).length()) + "})(.{");
                                    stringBuffer2.append(String.valueOf(matchResult.group(2).length()) + "})(.{");
                                    stringBuffer2.append(String.valueOf(matchResult.group(3).length()) + "})(.{");
                                    stringBuffer2.append(String.valueOf(matchResult.group(4).length()) + "})(.*)$");
                                    inputFile2.defineRegexp("disk content", stringBuffer2.toString());
                                    object = new ArrayList();
                                    ((ParsedBlock)object2).put("Disks", object);
                                    n2 = 1;
                                    continue;
                                }
                                if (n2 == 1 && (matchResult = inputFile2.matchRegexp("disk content", string2)) != null) {
                                    parsedBlock3 = new ParsedBlock("DiskStatus");
                                    object.add(parsedBlock3);
                                    parsedBlock3.put("pbslotId", matchResult.group(1).trim());
                                    parsedBlock3.put("frontDiskStatus", matchResult.group(2).trim());
                                    parsedBlock3.put("frontDiskWWN", matchResult.group(3).trim());
                                    parsedBlock3.put("rearDiskStatus", matchResult.group(4).trim());
                                    parsedBlock3.put("rearDiskWWN", matchResult.group(5).trim());
                                    continue;
                                }
                                if (n2 == 1 && (matchResult = inputFile2.matchRegexp("Subsystem Section", string2)) != null) {
                                    n2 = 2;
                                    continue;
                                }
                                if (n2 == 2 && (matchResult = inputFile2.matchRegexp("box properties", string2)) != null) {
                                    ((ParsedBlock)object2).put("fwVersion", matchResult.group(1).trim());
                                    ((ParsedBlock)object2).put("boxId", matchResult.group(2).trim());
                                    ((ParsedBlock)object2).put("nodeWWN", matchResult.group(3).trim());
                                    ((ParsedBlock)object2).put("enclosureName", matchResult.group(4).trim());
                                    continue;
                                }
                                if (n2 == 2 && (matchResult = inputFile2.matchRegexp("power supplies", string2)) != null) {
                                    n2 = 3;
                                    string7 = "";
                                    string8 = "";
                                    continue;
                                }
                                if (n2 == 3 && (matchResult = inputFile2.matchRegexp("fans", string2)) != null) {
                                    n2 = 4;
                                    string7 = "";
                                    string8 = "";
                                    continue;
                                }
                                if (n2 == 3 && (matchResult = inputFile2.matchRegexp("full line", string2)) != null) {
                                    string7 = String.valueOf(string7) + string8 + matchResult.group(1).trim();
                                    string8 = "\n";
                                    ((ParsedBlock)object2).put("powerSupplies", string7);
                                    continue;
                                }
                                if (n2 == 4 && (matchResult = inputFile2.matchRegexp("esi board", string2)) != null) {
                                    n2 = 5;
                                    treeMap2 = new TreeMap<String, String>();
                                    ((ParsedBlock)object2).put("esiIB", treeMap2);
                                    continue;
                                }
                                if (n2 == 4 && (matchResult = inputFile2.matchRegexp("full line", string2)) != null) {
                                    string7 = String.valueOf(string7) + string8 + matchResult.group(1).trim();
                                    string8 = "\n";
                                    ((ParsedBlock)object2).put("fans", string7);
                                    continue;
                                }
                                if (n2 == 5 && (matchResult = inputFile2.matchRegexp("disk backplane", string2)) != null) {
                                    n2 = 6;
                                    treeMap3 = new TreeMap<String, String>();
                                    ((ParsedBlock)object2).put("diskBackplane", treeMap3);
                                    continue;
                                }
                                if (n2 == 5 && (matchResult = inputFile2.matchRegexp("labelled String", string2)) != null) {
                                    string9 = matchResult.group(1).trim();
                                    string7 = matchResult.group(2).trim();
                                    treeMap2.put(string9, string7);
                                    continue;
                                }
                                if (n2 == 5 && (matchResult = inputFile2.matchRegexp("full line", string2)) != null) {
                                    string7 = String.valueOf(string7) + "\n" + matchResult.group(1).trim();
                                    treeMap2.put(string9, string7);
                                    continue;
                                }
                                if (n2 == 6 && (matchResult = inputFile2.matchRegexp("interconnect", string2)) != null) {
                                    n2 = 7;
                                    string7 = "";
                                    string8 = "";
                                    continue;
                                }
                                if (n2 == 6 && (matchResult = inputFile2.matchRegexp("labelled String", string2)) != null) {
                                    string9 = matchResult.group(1).trim();
                                    string7 = matchResult.group(2).trim();
                                    treeMap3.put(string9, string7);
                                    continue;
                                }
                                if (n2 == 6 && (matchResult = inputFile2.matchRegexp("full line", string2)) != null) {
                                    string7 = String.valueOf(string7) + "\n" + matchResult.group(1).trim();
                                    treeMap3.put(string9, string7);
                                    continue;
                                }
                                if (n2 == 7 && (matchResult = inputFile2.matchRegexp("loop configuration", string2)) != null) {
                                    n2 = 8;
                                    string7 = "";
                                    string8 = "";
                                    continue;
                                }
                                if (n2 == 7 && (matchResult = inputFile2.matchRegexp("full line", string2)) != null) {
                                    string7 = String.valueOf(string7) + string8 + matchResult.group(1).trim();
                                    string8 = "\n";
                                    ((ParsedBlock)object2).put("interconnect", string7);
                                    continue;
                                }
                                if (n2 == 8 && (matchResult = inputFile2.matchRegexp("language", string2)) != null) {
                                    ((ParsedBlock)object2).put("language", matchResult.group(1).trim());
                                    break;
                                }
                                if (n2 != 8 || (matchResult = inputFile2.matchRegexp("full line", string2)) == null) continue;
                                string7 = String.valueOf(string7) + string8 + matchResult.group(1).trim();
                                string8 = "\n";
                                ((ParsedBlock)object2).put("loop", string7);
                            }
                            inputFile2.close();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new FileIOException(string, "EDParse_Photon.parse", fileNotFoundException);
                        }
                        catch (IOException iOException) {
                            throw new FileIOException(string, "EDParse_Photon.parse", iOException);
                        }
                        catch (MalformedPatternException malformedPatternException) {
                            throw new FileParseException(string, "EDParse_Photon.parse", malformedPatternException);
                        }
                    }
                }
                ++n;
            }
        }
        if (this.trace) {
            parsedBlock.put("trace", stringBuffer.toString());
        }
        return vector;
    }
}

