/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.parsers.explorerDir;

import com.sun.eras.parsers.EntityParserImpl;
import com.sun.eras.parsers.ParsedBlock;
import com.sun.eras.parsers.ParserException;
import com.sun.eras.parsers.explorerDir.ExplorerDirEntityParser;
import com.sun.eras.parsers.explorerDir.FileIOException;
import com.sun.eras.parsers.explorerDir.FileParseException;
import com.sun.eras.parsers.inputFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;

public class EDParseClusterA
extends ExplorerDirEntityParser
implements EntityParserImpl {
    public EDParseClusterA(String string) {
        super(string);
    }

    private int clusterVers() {
        File file = new File(String.valueOf(this.path()) + "/cluster/etc/cluster");
        if (file.exists() && file.isDirectory()) {
            return 3;
        }
        return 2;
    }

    public Vector parse() throws ParserException {
        Vector<ParsedBlock> vector = new Vector<ParsedBlock>();
        ParsedBlock parsedBlock = null;
        StringBuffer stringBuffer = null;
        if (this.trace) {
            parsedBlock = new ParsedBlock("TRACE");
            vector.add(parsedBlock);
            stringBuffer = new StringBuffer("EDParse_ClassTemplate.parse() called for explorer path ");
            stringBuffer.append(this.path());
            stringBuffer.append("\n");
        }
        int n = this.clusterVers();
        ParsedBlock parsedBlock2 = new ParsedBlock("Cluster");
        vector.add(parsedBlock2);
        String string = "unknown";
        if (n == 2) {
            this.parse2(vector, stringBuffer);
            string = "2";
        } else if (n == 3) {
            this.parse3(vector, stringBuffer);
            string = "3";
        }
        parsedBlock2.put("version", string);
        if (this.trace) {
            parsedBlock.put("trace", stringBuffer.toString());
        }
        return vector;
    }

    private void parse2(Vector vector, StringBuffer stringBuffer) throws ParserException {
        String string = String.valueOf(this.path()) + "/cluster/etc/pnmconfig";
        try {
            inputFile inputFile2 = new inputFile(string);
            inputFile2.defineRegexp("nafo data", "^(\\S+)\\s+(.*)");
            BufferedReader bufferedReader = inputFile2.reader();
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                MatchResult matchResult = inputFile2.matchRegexp("nafo data", string2);
                if (matchResult == null) continue;
                ParsedBlock parsedBlock = new ParsedBlock("nafo");
                vector.add(parsedBlock);
                parsedBlock.put("name", matchResult.group(1));
                parsedBlock.put("adapters", matchResult.group(2));
            }
            inputFile2.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.trace) {
                stringBuffer.append("EDParseClusterA.parse2: did not find cluster/etc/pnmconfig\n");
            }
        }
        catch (IOException iOException) {
            throw new FileIOException(string, "EDParseClusterA.parse2", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string, "EDParseClusterA.parse2", malformedPatternException);
        }
    }

    private void parse3(Vector vector, StringBuffer stringBuffer) throws ParserException {
        String string = String.valueOf(this.path()) + "/cluster/etc/cluster/pnmconfig";
        try {
            inputFile inputFile2 = new inputFile(string);
            inputFile2.defineRegexp("nafo data", "^(\\S+)\\s+(.*)");
            BufferedReader bufferedReader = inputFile2.reader();
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                MatchResult matchResult = inputFile2.matchRegexp("nafo data", string2);
                if (matchResult == null) continue;
                ParsedBlock parsedBlock = new ParsedBlock("nafo");
                vector.add(parsedBlock);
                parsedBlock.put("name", matchResult.group(1));
                parsedBlock.put("adapters", matchResult.group(2));
            }
            inputFile2.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileIOException(string, "EDParseClusterA.parse3", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new FileIOException(string, "EDParseClusterA.parse3", iOException);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new FileParseException(string, "EDParseClusterA.parse3", malformedPatternException);
        }
    }
}

